#
# TABLE STRUCTURE FOR: acc_coa
#

DROP TABLE IF EXISTS `acc_coa`;

CREATE TABLE `acc_coa` (
  `HeadCode` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `HeadName` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `PHeadName` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `HeadLevel` int(11) NOT NULL,
  `IsActive` tinyint(1) NOT NULL,
  `IsTransaction` tinyint(1) NOT NULL,
  `IsGL` tinyint(1) NOT NULL,
  `HeadType` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `IsBudget` tinyint(1) NOT NULL,
  `IsDepreciation` tinyint(1) NOT NULL,
  `DepreciationRate` decimal(18,2) NOT NULL,
  `CreateBy` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `CreateDate` datetime NOT NULL,
  `UpdateBy` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `UpdateDate` datetime NOT NULL,
  PRIMARY KEY (`HeadName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021403', 'AC', 'Repair and Maintenance', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 19:33:55', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202', 'Account Payable', 'Current Liabilities', '2', '1', '0', '1', 'L', '0', '0', '0.00', 'admin', '2015-10-15 19:50:43', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10203', 'Account Receivable', 'Current Asset', '2', '1', '0', '0', 'A', '0', '0', '0.00', '', '2019-08-10 11:01:12', 'admin', '2013-09-18 15:29:35');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202001', 'Acmunio International Ltd.-4', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 04:34:58', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202002', 'Active Fine Chemicals Ltd.-5', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 04:34:59', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202003', 'Ad-din Pharmaceuticals Ltd.-6', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 04:35:00', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020201', 'Advance', 'Advance, Deposit And Pre-payments', '3', '1', '0', '1', 'A', '0', '0', '0.00', 'Zoherul', '2015-05-31 13:29:12', 'admin', '2015-12-31 16:46:32');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('102020103', 'Advance House Rent', 'Advance', '4', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2016-10-02 16:55:38', 'admin', '2016-10-02 16:57:32');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10202', 'Advance, Deposit And Pre-payments', 'Current Asset', '2', '1', '0', '0', 'A', '0', '0', '0.00', '', '2019-08-10 11:01:12', 'admin', '2015-12-31 16:46:24');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202004', 'Advanced Chemical Industries Limited-7', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 04:35:05', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202005', 'Advent Pharma Ltd.-8', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 04:35:48', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020602', 'Advertisement and Publicity', 'Promonational Expence', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 18:51:44', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010410', 'Air Cooler', 'Others Assets', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2016-05-23 12:13:55', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020603', 'AIT Against Advertisement', 'Promonational Expence', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 18:52:09', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202006', 'Al-Madina Pharmaceuticals Ltd.-9', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 04:35:49', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202007', 'Albion Laboratories Ltd.-10', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 04:35:53', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202008', 'Alco Pharma Limited-11', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 04:36:13', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202009', 'Alkad Laboratories-12', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 04:36:25', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Allied Pharmaceuticals Ltd.-13', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 04:36:28', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Ambee Pharmaceuticals Ltd.-14', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 04:36:29', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Amico Laboratories Ltd.-15', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 04:36:39', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Amulet Pharmaceuticals Ltd.-16', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 04:36:52', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'APC Pharma Limited-17', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 04:36:56', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Apex Pharma Ltd.-18', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 04:37:01', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Apollo Pharmaceutical Laboratories Ltd.-19', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 04:37:19', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Aristopharma Limited-20', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 04:37:24', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Aristopharma Limited, Gazipur-21', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:26:29', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Asiatic Laboratories Ltd.-22', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:26:34', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1', 'Assets', 'COA', '0', '1', '0', '0', 'A', '0', '0', '0.00', '', '2019-08-10 11:01:12', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Astra Biopharmaceuticals Ltd.-23', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:26:59', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010204', 'Attendance Machine', 'Office Equipment', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2015-10-15 15:49:31', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40216', 'Audit Fee', 'Other Expenses', '2', '1', '1', '1', 'E', '0', '0', '0.00', 'admin', '2017-07-18 12:54:30', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Aztec Pharmaceuticals Ltd.-24', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:27:13', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Bangladesh Antibiotic Industries Limited-25', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:27:17', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('102010201', 'Bangladesh Bank', 'Cash At Bank', '4', '1', '1', '0', 'A', '0', '0', '0.00', '1', '2019-11-06 06:39:55', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021002', 'Bank Charge', 'Financial Expenses', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 19:21:03', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30203', 'Bank Interest', 'Other Income', '2', '1', '1', '1', 'I', '0', '0', '0.00', 'Obaidul', '2015-01-03 14:49:54', 'admin', '2016-09-25 11:04:19');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Beacon Pharmaceuticals Ltd.-26', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:27:17', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Belsen Pharmaceuticals Ltd.-27', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:27:55', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Bengal Drugs & Chemical Works Pharm. Ltd.-28', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:27:58', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Bengal Remedies Ltd.-29', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:28:03', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Benham Pharmaceuticals Ltd.-30', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:28:07', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Beximco Pharmaceuticals Ltd.-31', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:28:23', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Beximco Pharmaceuticals Ltd., Kaliakoir-32', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:30:07', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Biogen Pharmaceuticals Ltd.-33', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:30:10', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Biopharma Ltd.-34', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:30:18', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Bios Pharmaceuticals Ltd.-35', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:31:07', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010104', 'Book Shelf', 'Furniture & Fixturers', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2015-10-15 15:46:11', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010407', 'Books and Journal', 'Others Assets', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2016-03-27 10:45:37', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Bridge Pharmaceuticals Ltd.-36', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:31:11', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Bristol Pharma Ltd.-37', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:31:15', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020604', 'Business Development Expenses', 'Promonational Expence', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 18:52:29', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020606', 'Campaign Expenses', 'Promonational Expence', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 18:52:57', 'admin', '2016-09-19 14:52:48');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020502', 'Campus Rent', 'House Rent', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 18:46:53', 'admin', '2017-04-27 17:02:39');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40212', 'Car Running Expenses', 'Other Expenses', '2', '1', '0', '1', 'E', '0', '0', '0.00', 'admin', '2015-10-15 19:28:43', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10201', 'Cash & Cash Equivalent', 'Current Asset', '2', '1', '0', '1', 'A', '0', '0', '0.00', '1', '2019-06-12 11:47:24', 'admin', '2015-10-15 15:57:55');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020102', 'Cash At Bank', 'Cash & Cash Equivalent', '3', '1', '0', '1', 'A', '0', '0', '0.00', '1', '2019-03-18 06:08:18', 'admin', '2015-10-15 15:32:42');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020101', 'Cash In Hand', 'Cash & Cash Equivalent', '3', '1', '1', '0', 'A', '0', '0', '0.00', '1', '2019-01-26 07:38:48', 'admin', '2016-05-23 12:05:43');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010207', 'CCTV', 'Office Equipment', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2015-10-15 15:51:24', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Centeon Pharma Limited-38', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:31:24', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Central Pharmaceutical Ltd.-39', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:31:27', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('102020102', 'CEO Current A/C', 'Advance', '4', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2016-09-25 11:54:54', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Chemist Laboratories Ltd.-40', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:31:35', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Cipla Ltd.-41', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:33:14', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010101', 'Class Room Chair', 'Furniture & Fixturers', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2015-10-15 15:45:29', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021407', 'Close Circuit Cemera', 'Repair and Maintenance', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 19:35:35', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020601', 'Commision on Admission', 'Promonational Expence', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 18:51:21', 'admin', '2016-09-19 14:42:54');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010206', 'Computer', 'Office Equipment', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2015-10-15 15:51:09', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021410', 'Computer (R)', 'Repair and Maintenance', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'Zoherul', '2016-03-24 12:38:52', 'Zoherul', '2016-03-24 12:41:40');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010102', 'Computer Table', 'Furniture & Fixturers', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2015-10-15 15:45:44', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Concord Pharmaceuticals Ltd.-42', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:33:20', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('301020401', 'Continuing Registration fee - UoL (Income)', 'Registration Fee (UOL) Income', '4', '1', '1', '0', 'I', '0', '0', '0.00', 'admin', '2015-10-15 17:40:40', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020904', 'Contratuall Staff Salary', 'Salary & Allowances', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 19:12:34', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Cosmic Pharma Ltd.-43', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:33:38', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Cosmo Pharma Laboratories Ltd.-44', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:33:58', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020709', 'Cultural Expense', 'Miscellaneous Expenses', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'nasmud', '2017-04-29 12:45:10', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('102', 'Current Asset', 'Assets', '1', '1', '0', '0', 'A', '0', '0', '0.00', '', '2019-08-10 11:01:12', 'admin', '2018-07-07 11:23:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('502', 'Current Liabilities', 'Liabilities', '1', '1', '0', '0', 'L', '0', '0', '0.00', 'anwarul', '2014-08-30 13:18:20', 'admin', '2015-10-15 19:49:21');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020301', 'Customer Receivable', 'Account Receivable', '3', '1', '0', '1', 'A', '0', '0', '0.00', '1', '2019-01-24 12:10:05', 'admin', '2018-07-07 12:31:42');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Decent Pharma Laboratories Ltd.-45', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:34:05', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Delta Chemicals Ltd.-46', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:34:12', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Delta Pharma Limited-47', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:34:13', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020202', 'Deposit', 'Advance, Deposit And Pre-payments', '3', '1', '0', '0', 'A', '0', '0', '0.00', 'admin', '2015-10-15 15:40:42', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Desh Pharmaceuticals Ltd.-48', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:34:52', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020605', 'Design & Printing Expense', 'Promonational Expence', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 18:55:00', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020404', 'Dish Bill', 'Utility Expenses', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 18:58:21', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40215', 'Dividend', 'Other Expenses', '2', '1', '1', '1', 'E', '0', '0', '0.00', 'admin', '2016-09-25 14:07:55', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Doctor Tims Pharmaceuticals Ltd.-49', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:35:08', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Doctor\'s Chemicals Works Ltd.-50', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:35:21', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020403', 'Drinking Water Bill', 'Utility Expenses', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 18:58:10', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Drug International Ltd. Unit-2-52', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:37:35', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Drug International Ltd.-51', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:35:43', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010211', 'DSLR Camera', 'Office Equipment', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2015-10-15 15:53:17', 'admin', '2016-01-02 16:23:25');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020908', 'Earned Leave', 'Salary & Allowances', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 19:13:38', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'EDCL (Bogra)-53', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:38:01', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'EDCL (Dhaka)-54', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:38:07', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Edruc Ltd.-55', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:38:51', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020607', 'Education Fair Expenses', 'Promonational Expence', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 18:53:42', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010602', 'Electric Equipment', 'Electrical Equipment', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2016-03-27 10:44:51', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010203', 'Electric Kettle', 'Office Equipment', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2015-10-15 15:49:07', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10106', 'Electrical Equipment', 'Non Current Assets', '2', '1', '0', '1', 'A', '0', '0', '0.00', 'admin', '2016-03-27 10:43:44', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020407', 'Electricity Bill', 'Utility Expenses', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 18:59:31', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'EMCS Pharma Limited-56', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:39:28', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50204', 'Employee Ledger', 'Current Liabilities', '2', '1', '0', '1', 'L', '0', '0', '0.00', '1', '2019-04-08 10:36:32', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('404', 'Employee Salary', 'Expence', '1', '1', '1', '0', 'E', '0', '0', '0.00', '1', '2019-05-23 05:46:14', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40201', 'Entertainment', 'Other Expenses', '2', '1', '1', '1', 'E', '0', '0', '0.00', 'admin', '2013-07-08 16:21:26', 'anwarul', '2013-07-17 14:21:47');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Eon Pharmaceuticals Ltd.-57', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:39:29', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('2', 'Equity', 'COA', '0', '1', '0', '0', 'L', '0', '0', '0.00', '', '2019-08-10 11:01:12', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Eskayef Pharmaceuticals Ltd. Mirpur.-58', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:39:35', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Eskayef Pharmaceuticals Ltd., Narayanganj-59', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:40:26', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Eskayef Pharmaceuticals Ltd., Tongi,Gazipur-60', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:40:34', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Ethical Drug Ltd.-61', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:50:20', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Euro Pharma Ltd.-62', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:50:52', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Everest Pharmaceuticals Ltd.-63', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:51:20', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4', 'Expence', 'COA', '0', '1', '1', '0', 'E', '0', '0', '0.00', '1', '2019-06-18 11:40:41', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020903', 'Faculty,Staff Salary & Allowances', 'Salary & Allowances', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 19:12:21', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021404', 'Fax Machine', 'Repair and Maintenance', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 19:34:15', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020905', 'Festival & Incentive Bonus', 'Salary & Allowances', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 19:12:48', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010103', 'File Cabinet', 'Furniture & Fixturers', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2015-10-15 15:46:02', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40210', 'Financial Expenses', 'Other Expenses', '2', '1', '0', '1', 'E', '0', '0', '0.00', 'anwarul', '2013-08-20 12:24:31', 'admin', '2015-10-15 19:20:36');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010403', 'Fire Extingushier', 'Others Assets', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2016-03-27 10:39:32', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('405', 'Fixed Assets Cost', 'Expence', '1', '1', '1', '0', 'E', '0', '0', '0.00', '1', '2019-05-29 05:32:01', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'FnF Pharmaceuticals Ltd.-64', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:51:38', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021408', 'Furniture', 'Repair and Maintenance', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 19:35:47', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10101', 'Furniture & Fixturers', 'Non Current Assets', '2', '1', '0', '1', 'A', '0', '0', '0.00', 'anwarul', '2013-08-20 16:18:15', 'anwarul', '2013-08-21 13:35:40');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'G. A. Company Ltd.-65', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:51:50', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020406', 'Gas Bill', 'Utility Expenses', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 18:59:20', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'General Pharmaceuticals Ltd, Unit-2-66', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:52:54', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'General Pharmaceuticals Ltd.-67', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:53:19', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('20201', 'General Reserve', 'Reserve & Surplus', '2', '1', '1', '0', 'L', '0', '0', '0.00', 'admin', '2016-09-25 14:07:12', 'admin', '2016-10-02 17:48:49');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10105', 'Generator', 'Non Current Assets', '2', '1', '1', '1', 'A', '0', '0', '0.00', 'Zoherul', '2016-02-27 16:02:35', 'admin', '2016-05-23 12:05:18');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021414', 'Generator Repair', 'Repair and Maintenance', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'Zoherul', '2016-06-16 10:21:05', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40213', 'Generator Running Expenses', 'Other Expenses', '2', '1', '0', '1', 'E', '0', '0', '0.00', 'admin', '2015-10-15 19:29:29', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Gentry Pharmaceuticals Ltd.-68', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:54:53', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Genvio Pharma Ltd.-69', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:54:58', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Get Well Limited-70', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:55:03', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Global Capsules Ltd.-71', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:55:07', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Global Capsules Ltd., Gelatin Division-72', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:55:09', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Global Heavy Chemicals Ltd.-73', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:55:09', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Globe Pharmaceuticals Ltd.-74', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:55:09', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Globex Pharmaceuticals Ltd.-75', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:56:55', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Gonoshasthaya Antibiotic Ltd.-76', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:57:15', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Gonoshasthaya Basic Chemical Ltd.-77', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:57:18', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Gonoshasthaya Pharmaceuticals Ltd.-78', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:57:19', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Goodman Pharmaceuticals Ltd-79', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:58:11', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Greenland Pharmaceuticals Ltd.-80', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:58:15', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10103', 'Groceries and Cutleries', 'Non Current Assets', '2', '1', '1', '1', 'A', '0', '0', '0.00', '2', '2018-07-12 10:02:55', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Guardian Healthcare Ltd.-81', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:58:22', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010408', 'Gym Equipment', 'Others Assets', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2016-03-27 10:46:03', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('102030001', 'Habib-MYPIV2IPH5XZRT1', 'Customer Receivable', '4', '1', '1', '0', 'A', '0', '0', '0.00', '1', '2019-11-04 10:47:37', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Hallmark Pharmaceuticals Ltd.-82', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 05:58:44', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Healthcare Pharmaceuticals Ltd.-83', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:35:39', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020907', 'Honorarium', 'Salary & Allowances', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 19:13:26', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Hope Pharmaceuticals Ltd.-84', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:37:32', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40205', 'House Rent', 'Other Expenses', '2', '1', '0', '1', 'E', '0', '0', '0.00', 'anwarul', '2013-08-24 10:26:56', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Hudson Pharmaceuticals Ltd.-85', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:37:39', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Ibn Sina Pharmaceutical Ind. Ltd.-86', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:38:02', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Incepta Chemicals Ltd.-87', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:39:58', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Incepta Pharmaceuticals Ltd. (Dhamrai Unit)-89', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:44:52', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Incepta Pharmaceuticals Ltd.-88', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:39:59', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Incepta Vaccine Limited-90', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:45:33', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('3', 'Income', 'COA', '0', '1', '0', '0', 'I', '0', '0', '0.00', '1', '2019-05-20 05:32:59', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30204', 'Income from Photocopy & Printing', 'Other Income', '2', '1', '1', '1', 'I', '0', '0', '0.00', 'Zoherul', '2015-07-14 10:29:54', 'admin', '2016-09-25 11:04:28');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('5020302', 'Income Tax Payable', 'Liabilities for Expenses', '3', '1', '0', '1', 'L', '0', '0', '0.00', 'admin', '2016-09-19 11:18:17', 'admin', '2016-09-28 13:18:35');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Indo-Bangla Pharmaceuticals Ltd.-91', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:45:39', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Institute of Public Health-92', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:46:06', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10107', 'Inventory', 'Non Current Assets', '1', '1', '0', '0', 'A', '0', '0', '0.00', '2', '2018-07-07 15:21:58', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Islam Oxygen (Pvt) Ltd.-93', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:46:12', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('102030003', 'jakir-4', 'Customer Receivable', '4', '1', '1', '0', 'A', '0', '0', '0.00', '1', '2019-11-04 12:59:52', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Jalalabad Pharmaceuticals Ltd.-94', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:46:14', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Jayson Pharmaceuticals Ltd.-95', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:46:32', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'JMI Industrial Gas Ltd.-96', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:47:52', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'JMI Syringes & Medical Devices Ltd.-97', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:47:53', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Julphar Bangladesh Ltd.-98', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:47:56', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Kemiko Pharmaceuticals Ltd.-99', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:53:43', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Kumudini Pharma Ltd.-100', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:55:18', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Labaid Pharmaceuticals Ltd.-101', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:56:02', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010210', 'LCD TV', 'Office Equipment', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2015-10-15 15:52:27', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30103', 'Lease Sale', 'Store Income', '1', '1', '1', '1', 'I', '0', '0', '0.00', '2', '2018-07-08 07:51:52', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Leon Pharmaceuticals Ltd.-102', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:56:37', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('5', 'Liabilities', 'COA', '0', '1', '0', '0', 'L', '0', '0', '0.00', 'admin', '2013-07-04 12:32:07', 'admin', '2015-10-15 19:46:54');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50203', 'Liabilities for Expenses', 'Current Liabilities', '2', '1', '0', '0', 'L', '0', '0', '0.00', 'admin', '2015-10-15 19:50:59', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Libra Pharmaceuticls Ltd.-103', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:57:11', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020707', 'Library Expenses', 'Miscellaneous Expenses', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2017-01-10 15:34:54', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021409', 'Lift', 'Repair and Maintenance', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 19:36:12', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Linde Bangladesh Limited-104', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:57:23', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020302', 'Loan Receivable', 'Account Receivable', '3', '1', '0', '1', 'A', '0', '0', '0.00', '1', '2019-01-26 07:37:20', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50101', 'Long Term Borrowing', 'Non Current Liabilities', '2', '1', '0', '1', 'L', '0', '0', '0.00', 'admin', '2013-07-04 12:32:26', 'admin', '2015-10-15 19:47:40');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Maks Drugs Ltd.-105', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:57:26', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Marker Pharmaceuticals Ltd.-106', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:57:36', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020608', 'Marketing & Promotion Exp.', 'Promonational Expence', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 18:53:59', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Marksman Pharmaceutical Ltd.-107', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:57:50', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020901', 'Medical Allowance', 'Salary & Allowances', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 19:11:33', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Medicon Pharmaceuticals Ltd.-108', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:58:09', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Medimet Pharmaceuticals Ltd.-109', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:58:58', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'MedRx Life Science Ltd.-110', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 06:59:44', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010411', 'Metal Ditector', 'Others Assets', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'Zoherul', '2016-08-22 10:55:22', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021413', 'Micro Oven', 'Repair and Maintenance', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'Zoherul', '2016-05-12 14:53:51', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Millat Pharmaceuticals Ltd.-111', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:00:13', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30202', 'Miscellaneous (Income)', 'Other Income', '2', '1', '1', '1', 'I', '0', '0', '0.00', 'anwarul', '2014-02-06 15:26:31', 'admin', '2016-09-25 11:04:35');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020909', 'Miscellaneous Benifit', 'Salary & Allowances', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 19:13:53', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020701', 'Miscellaneous Exp', 'Miscellaneous Expenses', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2016-09-25 12:54:39', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40207', 'Miscellaneous Expenses', 'Other Expenses', '2', '1', '0', '1', 'E', '0', '0', '0.00', 'anwarul', '2014-04-26 16:49:56', 'admin', '2016-09-25 12:54:19');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010401', 'Mobile Phone', 'Others Assets', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2016-01-29 10:43:30', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Modern Pharmaceuticals Ltd.-112', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:00:41', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Momotaz Pharmaceuticals Ltd.-113', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:01:05', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Monicopharma Limited-114', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:01:13', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Monomedi Bangladesh Ltd.-115', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:01:57', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'MSF Pharmaceuticals Ltd.,-116', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:01:58', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'MST Pharma and Healthcare Ltd.-117', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:01:59', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Mundipharma (Bangladesh) Pvt. Ltd.-118', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:02:32', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Naafco Pharma Ltd.-119', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:02:41', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'National Laboratories Ltd.-120', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:03:05', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Navana Pharmaceuticals Ltd.-121', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:03:31', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010212', 'Network Accessories', 'Office Equipment', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2016-01-02 16:23:32', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020408', 'News Paper Bill', 'Utility Expenses', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2016-01-02 15:55:57', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Newtec Pharmaceuticals Ltd.-122', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:05:59', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Nip Chemicals And Pharmaceuticals Ltd.-123', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:06:02', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Nipa Pharmaceuticals Ltd.-124', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:06:04', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'NIPRO JMI Company Ltd.-125', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:07:06', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'NIPRO JMI Pharma Limited-126', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:07:06', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('101', 'Non Current Assets', 'Assets', '1', '1', '0', '0', 'A', '0', '0', '0.00', '', '2019-08-10 11:01:12', 'admin', '2015-10-15 15:29:11');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('501', 'Non Current Liabilities', 'Liabilities', '1', '1', '0', '0', 'L', '0', '0', '0.00', 'anwarul', '2014-08-30 13:18:20', 'admin', '2015-10-15 19:49:21');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Novartis  (Bangladesh) Ltd.-127', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:08:15', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Novelta Bestway Pharmaceuticals Ltd.-128', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:09:48', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Novo Healthcare and Pharma Ltd. (Unit-2)-130', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:11:13', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Novo Healthcare and Pharma Ltd.-129', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:10:14', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Novus Pharmaceuticals Ltd.-131', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:11:15', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Nuvista Pharma Ltd-132', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:11:30', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010404', 'Office Decoration', 'Others Assets', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2016-03-27 10:40:02', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10102', 'Office Equipment', 'Non Current Assets', '2', '1', '0', '1', 'A', '0', '0', '0.00', 'anwarul', '2013-12-06 18:08:00', 'admin', '2015-10-15 15:48:21');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021401', 'Office Repair & Maintenance', 'Repair and Maintenance', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 19:33:15', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30201', 'Office Stationary (Income)', 'Other Income', '2', '1', '1', '1', 'I', '0', '0', '0.00', 'anwarul', '2013-07-17 15:21:06', 'admin', '2016-09-25 11:04:50');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'One Pharma Ltd.-133', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:12:02', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Opso Saline Ltd.-134', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:12:43', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Opsonin Bulk Drugs Ltd.-135', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:13:37', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Opsonin Pharma Limited-136', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:13:41', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Orbit Pharmaceuticals Ltd.-137', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:21:20', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Organic Health Care-138', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:21:44', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Orion Infusion Ltd.-139', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:22:21', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Orion Pharma Ltd.-140', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:22:33', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('302', 'Other Income', 'Income', '1', '1', '0', '0', 'I', '0', '0', '0.00', '2', '2018-07-07 13:40:57', 'admin', '2016-09-25 11:04:09');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40211', 'Others (Non Academic Expenses)', 'Other Expenses', '2', '1', '0', '1', 'E', '0', '0', '0.00', 'Obaidul', '2014-12-03 16:05:42', 'admin', '2015-10-15 19:22:09');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30205', 'Others (Non-Academic Income)', 'Other Income', '2', '1', '0', '1', 'I', '0', '0', '0.00', 'admin', '2015-10-15 17:23:49', 'admin', '2015-10-15 17:57:52');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('10104', 'Others Assets', 'Non Current Assets', '2', '1', '0', '1', 'A', '0', '0', '0.00', 'admin', '2016-01-29 10:43:16', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020910', 'Outstanding Salary', 'Salary & Allowances', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'Zoherul', '2016-04-24 11:56:50', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021405', 'Oven', 'Repair and Maintenance', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 19:34:31', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Oyster Pharmaceuticals Ltd.-141', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:24:51', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021412', 'PABX-Repair', 'Repair and Maintenance', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'Zoherul', '2016-04-24 14:40:18', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Pacific Pharmaceuticals Ltd.-142', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:25:02', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020902', 'Part-time Staff Salary', 'Salary & Allowances', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 19:12:06', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Peoples Pharma Ltd.-143', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:27:00', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Pharmacil Ltd.-144', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:27:39', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Pharmadesh Laboratories Ltd.-145', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:28:08', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Pharmasia Ltd.-146', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:29:26', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Pharmatek Chemicals Ltd.-147', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:31:00', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Pharmik Laboratories Ltd.-148', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:31:01', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Phoenix Chemicals Laboratory (BD) Ltd.-149', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:31:30', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010202', 'Photocopy & Fax Machine', 'Office Equipment', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2015-10-15 15:47:27', 'admin', '2016-05-23 12:14:40');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021411', 'Photocopy Machine Repair', 'Repair and Maintenance', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'Zoherul', '2016-04-24 12:40:02', 'admin', '2017-04-27 17:03:17');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Popular Pharmaceuticals Ltd.-150', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:31:38', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('3020503', 'Practical Fee', 'Others (Non-Academic Income)', '3', '1', '1', '1', 'I', '0', '0', '0.00', 'admin', '2017-07-22 18:00:37', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Premier Pharmaceuticals-151', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:35:39', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1020203', 'Prepayment', 'Advance, Deposit And Pre-payments', '3', '1', '0', '1', 'A', '0', '0', '0.00', 'admin', '2015-10-15 15:40:51', 'admin', '2015-12-31 16:49:58');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Prime Pharmaceuticals Ltd.-152', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:36:15', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010201', 'Printer', 'Office Equipment', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2015-10-15 15:47:15', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40202', 'Printing and Stationary', 'Other Expenses', '2', '1', '1', '1', 'E', '0', '0', '0.00', 'admin', '2013-07-08 16:21:45', 'admin', '2016-09-19 14:39:32');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('402', 'Product Purchase', 'Expence', '1', '1', '1', '0', 'E', '0', '0', '0.00', '1', '2019-05-20 07:46:59', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('304', 'Product Sale', 'Income', '1', '1', '1', '0', 'I', '0', '0', '0.00', '1', '2019-06-16 12:15:40', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('3020502', 'Professional Training Course(Oracal-1)', 'Others (Non-Academic Income)', '3', '1', '1', '0', 'I', '0', '0', '0.00', 'nasim', '2017-06-22 13:28:05', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30207', 'Professional Training Course(Oracal)', 'Other Income', '2', '1', '0', '1', 'I', '0', '0', '0.00', 'nasim', '2017-06-22 13:24:16', 'nasim', '2017-06-22 13:25:56');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010208', 'Projector', 'Office Equipment', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2015-10-15 15:51:44', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40206', 'Promonational Expence', 'Other Expenses', '2', '1', '0', '1', 'E', '0', '0', '0.00', 'anwarul', '2013-07-11 13:48:57', 'anwarul', '2013-07-17 14:23:03');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Quality Pharmaceuticals (Pvt) Ltd.-153', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:36:33', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Radiant Pharmaceuticals Ltd.-154', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:39:09', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Rahman Chemicals Ltd.-155', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:40:17', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Rampart-Power Bangladesh Ltd.-156', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:40:17', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Rangs Pharmaceuticals Ltd.-157', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:40:27', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Reckitt Benckiser Bangladesh Ltd.-158', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:41:34', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Reliance Pharmaceuticals Ltd.-159', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:41:36', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Reman Drug Laboratories Ltd.-160', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:42:12', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Remo Chemical Ltd.-161', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:42:51', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Renata Limited-162', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:42:57', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Renata Limited, Gazipur-163', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:47:28', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Renata Oncology Limited-164', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:48:19', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40214', 'Repair and Maintenance', 'Other Expenses', '2', '1', '0', '1', 'E', '0', '0', '0.00', 'admin', '2015-10-15 19:32:46', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Rephco Pharmaceuticals Ltd.-165', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:48:24', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('202', 'Reserve & Surplus', 'Equity', '1', '1', '0', '1', 'L', '0', '0', '0.00', 'admin', '2016-09-25 14:06:34', 'admin', '2016-10-02 17:48:57');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('20102', 'Retained Earnings', 'Share Holders Equity', '2', '1', '1', '1', 'L', '0', '0', '0.00', 'admin', '2016-05-23 11:20:40', 'admin', '2016-09-25 14:05:06');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020708', 'River Cruse', 'Miscellaneous Expenses', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2017-04-24 15:35:25', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'RN Pharmaceuticals-166', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:49:57', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'S. N. Pharmaceuticals Ltd.-167', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:50:07', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('102020105', 'Salary', 'Advance', '4', '1', '0', '0', 'A', '0', '0', '0.00', 'admin', '2018-07-05 11:46:44', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40209', 'Salary & Allowances', 'Other Expenses', '2', '1', '0', '1', 'E', '0', '0', '0.00', 'anwarul', '2013-12-12 11:22:58', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Salton Pharmaceuticals Ltd.-168', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:50:23', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Sanofi Bangladesh Ltd.-169', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:50:46', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Save Pharmaceutical-170', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:53:11', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Seba Laboratories Ltd.-171', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:53:16', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010406', 'Security Equipment', 'Others Assets', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2016-03-27 10:41:30', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Seema Pharmaceuticals Ltd.-172', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:53:19', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('305', 'Service Income', 'Income', '1', '1', '1', '0', 'I', '0', '0', '0.00', '1', '2019-05-22 13:36:02', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('20101', 'Share Capital', 'Share Holders Equity', '2', '1', '0', '1', 'L', '0', '0', '0.00', 'anwarul', '2013-12-08 19:37:32', 'admin', '2015-10-15 19:45:35');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('201', 'Share Holders Equity', 'Equity', '1', '1', '0', '0', 'L', '0', '0', '0.00', '', '2019-08-10 11:01:12', 'admin', '2015-10-15 19:43:51');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Sharif Pharmaceuticals Ltd.-173', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:53:48', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50201', 'Short Term Borrowing', 'Current Liabilities', '2', '1', '0', '1', 'L', '0', '0', '0.00', 'admin', '2015-10-15 19:50:30', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Silco Pharmaceuticlas Ltd.-174', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:55:15', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Silva Pharmaceuticals Ltd.-175', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:55:49', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'SMC Enterprise Limited-176', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:57:00', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Sodical Chemical Ltd.-177', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:57:23', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40208', 'Software Development Expenses', 'Other Expenses', '2', '1', '0', '1', 'E', '0', '0', '0.00', 'anwarul', '2013-11-21 14:13:01', 'admin', '2015-10-15 19:02:51');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Somatec Pharmaceuticals Ltd.-178', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:57:23', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020906', 'Special Allowances', 'Salary & Allowances', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 19:13:13', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Spectra Oxygen Limited-179', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:59:00', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50102', 'Sponsors Loan', 'Non Current Liabilities', '2', '1', '0', '1', 'L', '0', '0', '0.00', 'admin', '2015-10-15 19:48:02', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020706', 'Sports Expense', 'Miscellaneous Expenses', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'nasmud', '2016-11-09 13:16:53', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Square Cephalosporins Ltd.-180', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:59:01', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Square Formulations Ltd.-181', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 07:59:28', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Square Pharmaceuticals Ltd. (Chemical Division)-182', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 08:00:21', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Square Pharmaceuticals Ltd. Gazipur-183', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 08:01:32', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Square Pharmaceuticals Ltd. Pabna-184', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 08:04:22', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Standard Laboratories Ltd.-185', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 08:14:14', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('301', 'Store Income', 'Income', '1', '1', '0', '0', 'I', '0', '0', '0.00', '2', '2018-07-07 13:40:37', 'admin', '2015-09-17 17:00:02');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('3020501', 'Students Info. Correction Fee', 'Others (Non-Academic Income)', '3', '1', '1', '0', 'I', '0', '0', '0.00', 'admin', '2015-10-15 17:24:45', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010601', 'Sub Station', 'Electrical Equipment', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2016-03-27 10:44:11', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Sun Pharmaceutical (Bangladesh) Ltd.-186', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 08:15:00', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Sunman-Birdem Pharma Ltd.-187', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 08:16:09', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Super Power Pharmaceuticals Ltd.-188', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 08:16:43', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50205', 'Supplier Ledger', 'Current Liabilities', '2', '1', '0', '1', 'L', '0', '0', '0.00', '1', '2019-10-06 06:18:49', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Supreme Pharmaceuticals Ltd.-189', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 08:17:03', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020704', 'TB Care Expenses', 'Miscellaneous Expenses', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2016-10-08 13:03:04', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30206', 'TB Care Income', 'Other Income', '2', '1', '1', '1', 'I', '0', '0', '0.00', 'admin', '2016-10-08 13:00:56', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020501', 'TDS on House Rent', 'House Rent', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 18:44:07', 'admin', '2016-09-19 14:40:16');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('502030201', 'TDS Payable House Rent', 'Income Tax Payable', '4', '1', '1', '0', 'L', '0', '0', '0.00', 'admin', '2016-09-19 11:19:42', 'admin', '2016-09-28 13:19:37');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('502030203', 'TDS Payable on Advertisement Bill', 'Income Tax Payable', '4', '1', '1', '0', 'L', '0', '0', '0.00', 'admin', '2016-09-28 13:20:51', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('502030202', 'TDS Payable on Salary', 'Income Tax Payable', '4', '1', '1', '0', 'L', '0', '0', '0.00', 'admin', '2016-09-28 13:20:17', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Team Pharmaceuticals Ltd.-190', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 08:18:09', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Techno Drugs (Unit-3)-191', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 08:18:59', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Techno Drugs Ltd.-192', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 08:19:01', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Techno Drugs Ltd., Unit-2-193', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 09:00:23', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020402', 'Telephone Bill', 'Utility Expenses', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 18:57:59', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010209', 'Telephone Set & PABX', 'Office Equipment', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2015-10-15 15:51:57', 'admin', '2016-10-02 17:10:40');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('102030002', 'Test customer-0', 'Customer Receivable', '4', '1', '1', '0', 'A', '0', '0', '0.00', '1', '2019-11-04 12:48:08', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('30301', 'test in 1', 'Test Income', '2', '1', '1', '0', 'I', '0', '0', '0.00', '1', '2019-05-20 05:25:43', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('303', 'Test Income', 'Income', '1', '1', '1', '0', 'I', '0', '0', '0.00', '1', '2019-05-20 05:24:33', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'test-0', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-05 11:05:58', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'The ACME Laboratories Ltd.-194', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 09:00:34', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'The White Horse Pharmaceuticals Ltd.-195', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 09:07:19', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40203', 'Travelling & Conveyance', 'Other Expenses', '2', '1', '1', '1', 'E', '0', '0', '0.00', 'admin', '2013-07-08 16:22:06', 'admin', '2015-10-15 18:45:13');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4021406', 'TV', 'Repair and Maintenance', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 19:35:07', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Unimed Unihealth Pharmaceuticals Ltd.-196', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 09:08:25', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Union Pharmaceuticals Ltd.-197', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 09:13:03', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Unique Pharmaceutical Ltd.-198', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 09:13:36', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'United Chemicals & Pharmaceuticals Ltd.-199', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 09:13:47', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010205', 'UPS', 'Office Equipment', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2015-10-15 15:50:38', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('40204', 'Utility Expenses', 'Other Expenses', '2', '1', '0', '1', 'E', '0', '0', '0.00', 'anwarul', '2013-07-11 16:20:24', 'admin', '2016-01-02 15:55:22');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020503', 'VAT on House Rent Exp', 'House Rent', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 18:49:22', 'admin', '2016-09-25 14:00:52');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('5020301', 'VAT Payable', 'Liabilities for Expenses', '3', '1', '0', '1', 'L', '0', '0', '0.00', 'admin', '2015-10-15 19:51:11', 'admin', '2016-09-28 13:23:53');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010409', 'Vehicle A/C', 'Others Assets', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'Zoherul', '2016-05-12 12:13:21', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Veritas Pharmaceuticals Ltd.-200', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 09:14:41', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Virgo Pharmaceuticals Ltd.-201', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 09:15:31', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010405', 'Voltage Stablizer', 'Others Assets', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2016-03-27 10:40:59', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('102030101', 'Walking Customer-P3NY6D1AKZQPHB7', 'Customer Receivable', '4', '1', '1', '0', 'A', '0', '0', '0.00', '1', '2019-05-20 06:55:07', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020405', 'WASA Bill', 'Utility Expenses', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2015-10-15 18:58:51', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('1010402', 'Water Purifier', 'Others Assets', '3', '1', '1', '0', 'A', '0', '0', '0.00', 'admin', '2016-01-29 11:14:11', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('4020705', 'Website Development Expenses', 'Miscellaneous Expenses', '3', '1', '1', '0', 'E', '0', '0', '0.00', 'admin', '2016-10-15 12:42:47', '', '2019-08-10 11:01:12');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'World Chemical Industry Ltd.-202', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 09:16:10', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Zenith Pharmaceuticals Ltd.-203', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 09:16:11', '', '0000-00-00 00:00:00');
INSERT INTO `acc_coa` (`HeadCode`, `HeadName`, `PHeadName`, `HeadLevel`, `IsActive`, `IsTransaction`, `IsGL`, `HeadType`, `IsBudget`, `IsDepreciation`, `DepreciationRate`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`) VALUES ('50202010', 'Ziska Pharmaceuticals Ltd.-204', 'Account Payable', '3', '1', '1', '0', 'L', '0', '0', '0.00', '1', '2019-11-04 09:17:25', '', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: acc_transaction
#

DROP TABLE IF EXISTS `acc_transaction`;

CREATE TABLE `acc_transaction` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `VNo` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Vtype` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `VDate` date DEFAULT NULL,
  `COAID` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `Narration` text COLLATE utf8_unicode_ci,
  `Debit` decimal(18,2) DEFAULT NULL,
  `Credit` decimal(18,2) DEFAULT NULL,
  `IsPosted` char(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `CreateBy` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `CreateDate` datetime DEFAULT NULL,
  `UpdateBy` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `UpdateDate` datetime DEFAULT NULL,
  `IsAppove` char(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  UNIQUE KEY `ID` (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=70 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('1', '20191104060422', 'Purchase', '2019-11-04', '10107', 'Inventory Debit For Purchase No20191104060422', '50.00', '0.00', '1', '1', '2019-11-04 06:04:22', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('2', '20191104060422', 'Purchase', '2019-11-04', '50202010', 'Purchase No.20191104060422', '0.00', '50.00', '1', '1', '2019-11-04 00:00:00', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('3', '20191104060422', 'Purchase', '2019-11-04', '402', 'Company Credit For Purchase No20191104060422', '50.00', '0.00', '1', '1', '2019-11-04 06:04:22', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('4', '20191104060422', 'Purchase', '2019-11-04', '1020101', 'Cash in Hand For Purchase No20191104060422', '0.00', '50.00', '1', '1', '2019-11-04 06:04:22', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('5', '20191104060422', 'Purchase', '2019-11-04', '50202010', 'Purchase No.20191104060422', '50.00', '0.00', '1', '1', '2019-11-04 00:00:00', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('6', '5738747829', 'INVOICE', '2019-11-04', '10107', 'Inventory credit For Invoice No5738747829', '0.00', '5.00', '1', '1', '2019-11-04 12:49:15', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('7', '5617473563', 'INVOICE', '2019-11-04', '10107', 'Inventory credit For Invoice No5617473563', '0.00', '2.50', '1', '1', '2019-11-04 12:50:32', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('8', '2421265827', 'INVOICE', '2019-11-04', '10107', 'Inventory credit For Invoice No2421265827', '0.00', '5.00', '1', '1', '2019-11-04 13:00:33', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('9', '2421265827', 'INVOICE', '2019-11-04', '102030003', 'Customer debit For Invoice No2421265827', '6.00', '0.00', '1', '1', '2019-11-04 13:00:33', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('10', '2421265827', 'INVOICE', '2019-11-04', '304', 'Customer debit For Invoice No2421265827', '0.00', '6.00', '1', '1', '2019-11-04 13:00:33', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('11', '2421265827', 'INVOICE', '2019-11-04', '102030003', 'Customer credit for Paid Amount For Invoice No2421265827', '0.00', '6.00', '1', '1', '2019-11-04 13:00:33', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('12', '2421265827', 'INVOICE', '2019-11-04', '1020101', 'Cash in Hand For Invoice No2421265827', '6.00', '0.00', '1', '1', '2019-11-04 13:00:33', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('13', '8882516716', 'INVOICE', '2019-11-04', '10107', 'Inventory credit For Invoice No8882516716', '0.00', '5.00', '1', '1', '2019-11-04 13:00:56', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('14', '8882516716', 'INVOICE', '2019-11-04', '102030003', 'Customer debit For Invoice No8882516716', '6.00', '0.00', '1', '1', '2019-11-04 13:00:56', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('15', '8882516716', 'INVOICE', '2019-11-04', '304', 'Customer debit For Invoice No8882516716', '0.00', '6.00', '1', '1', '2019-11-04 13:00:56', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('16', '8882516716', 'INVOICE', '2019-11-04', '102030003', 'Customer credit for Paid Amount For Invoice No8882516716', '0.00', '6.00', '1', '1', '2019-11-04 13:00:56', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('17', '8882516716', 'INVOICE', '2019-11-04', '1020101', 'Cash in Hand For Invoice No8882516716', '6.00', '0.00', '1', '1', '2019-11-04 13:00:56', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('18', '3846639867', 'INVOICE', '2019-11-04', '10107', 'Inventory credit For Invoice No3846639867', '0.00', '2.50', '1', '1', '2019-11-04 13:01:58', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('19', '3846639867', 'INVOICE', '2019-11-04', '102030003', 'Customer debit For Invoice No3846639867', '3.00', '0.00', '1', '1', '2019-11-04 13:01:58', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('20', '3846639867', 'INVOICE', '2019-11-04', '304', 'Customer debit For Invoice No3846639867', '0.00', '3.00', '1', '1', '2019-11-04 13:01:58', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('21', '3846639867', 'INVOICE', '2019-11-04', '102030003', 'Customer credit for Paid Amount For Invoice No3846639867', '0.00', '3.00', '1', '1', '2019-11-04 13:01:58', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('22', '3846639867', 'INVOICE', '2019-11-04', '1020101', 'Cash in Hand For Invoice No3846639867', '3.00', '0.00', '1', '1', '2019-11-04 13:01:58', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('23', '1349611216', 'INVOICE', '2019-11-04', '10107', 'Inventory credit For Invoice No1349611216', '0.00', '2.50', '1', '1', '2019-11-04 13:02:26', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('24', '1349611216', 'INVOICE', '2019-11-04', '102030003', 'Customer debit For Invoice No1349611216', '3.00', '0.00', '1', '1', '2019-11-04 13:02:26', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('25', '1349611216', 'INVOICE', '2019-11-04', '304', 'Customer debit For Invoice No1349611216', '0.00', '3.00', '1', '1', '2019-11-04 13:02:26', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('26', '1349611216', 'INVOICE', '2019-11-04', '102030003', 'Customer credit for Paid Amount For Invoice No1349611216', '0.00', '3.00', '1', '1', '2019-11-04 13:02:26', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('27', '1349611216', 'INVOICE', '2019-11-04', '1020101', 'Cash in Hand For Invoice No1349611216', '3.00', '0.00', '1', '1', '2019-11-04 13:02:26', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('28', '6778188768', 'INVOICE', '2019-11-04', '10107', 'Inventory credit For Invoice No6778188768', '0.00', '2.50', '1', '1', '2019-11-04 13:23:51', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('29', '6778188768', 'INVOICE', '2019-11-04', '102030003', 'Customer debit For Invoice No6778188768', '3.00', '0.00', '1', '1', '2019-11-04 13:23:51', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('30', '6778188768', 'INVOICE', '2019-11-04', '304', 'Customer debit For Invoice No6778188768', '0.00', '3.00', '1', '1', '2019-11-04 13:23:51', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('31', '6778188768', 'INVOICE', '2019-11-04', '102030003', 'Customer credit for Paid Amount For Invoice No6778188768', '0.00', '3.00', '1', '1', '2019-11-04 13:23:51', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('32', '6778188768', 'INVOICE', '2019-11-04', '1020101', 'Cash in Hand For Invoice No6778188768', '3.00', '0.00', '1', '1', '2019-11-04 13:23:51', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('33', '4255549598', 'INVOICE', '2019-11-04', '10107', 'Inventory credit For Invoice No4255549598', '0.00', '2.50', '1', '1', '2019-11-04 13:25:24', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('34', '4255549598', 'INVOICE', '2019-11-04', '102030003', 'Customer debit For Invoice No4255549598', '3.00', '0.00', '1', '1', '2019-11-04 13:25:24', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('35', '4255549598', 'INVOICE', '2019-11-04', '304', 'Customer debit For Invoice No4255549598', '0.00', '3.00', '1', '1', '2019-11-04 13:25:24', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('36', '4255549598', 'INVOICE', '2019-11-04', '102030003', 'Customer credit for Paid Amount For Invoice No4255549598', '0.00', '3.00', '1', '1', '2019-11-04 13:25:24', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('37', '4255549598', 'INVOICE', '2019-11-04', '1020101', 'Cash in Hand For Invoice No4255549598', '3.00', '0.00', '1', '1', '2019-11-04 13:25:24', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('38', '5764724144', 'INVOICE', '2019-11-04', '10107', 'Inventory credit For Invoice No5764724144', '0.00', '2.50', '1', '1', '2019-11-04 13:28:51', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('39', '5764724144', 'INVOICE', '2019-11-04', '102030003', 'Customer debit For Invoice No5764724144', '3.00', '0.00', '1', '1', '2019-11-04 13:28:51', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('40', '5764724144', 'INVOICE', '2019-11-04', '304', 'Customer debit For Invoice No5764724144', '0.00', '3.00', '1', '1', '2019-11-04 13:28:51', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('41', '5764724144', 'INVOICE', '2019-11-04', '102030003', 'Customer credit for Paid Amount For Invoice No5764724144', '0.00', '3.00', '1', '1', '2019-11-04 13:28:51', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('42', '5764724144', 'INVOICE', '2019-11-04', '1020101', 'Cash in Hand For Invoice No5764724144', '3.00', '0.00', '1', '1', '2019-11-04 13:28:51', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('43', '2225599822', 'INVOICE', '2019-11-04', '10107', 'Inventory credit For Invoice No2225599822', '0.00', '2.50', '1', '1', '2019-11-04 13:32:06', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('44', '2225599822', 'INVOICE', '2019-11-04', '102030003', 'Customer debit For Invoice No2225599822', '3.00', '0.00', '1', '1', '2019-11-04 13:32:06', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('45', '2225599822', 'INVOICE', '2019-11-04', '304', 'Customer debit For Invoice No2225599822', '0.00', '3.00', '1', '1', '2019-11-04 13:32:06', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('46', '2225599822', 'INVOICE', '2019-11-04', '102030003', 'Customer credit for Paid Amount For Invoice No2225599822', '0.00', '3.00', '1', '1', '2019-11-04 13:32:06', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('47', '2225599822', 'INVOICE', '2019-11-04', '1020101', 'Cash in Hand For Invoice No2225599822', '3.00', '0.00', '1', '1', '2019-11-04 13:32:06', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('48', '1289397576', 'INVOICE', '2019-11-04', '10107', 'Inventory credit For Invoice No1289397576', '0.00', '2.50', '1', '1', '2019-11-04 13:37:38', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('49', '1289397576', 'INVOICE', '2019-11-04', '102030003', 'Customer debit For Invoice No1289397576', '3.00', '0.00', '1', '1', '2019-11-04 13:37:38', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('50', '1289397576', 'INVOICE', '2019-11-04', '304', 'Customer debit For Invoice No1289397576', '0.00', '3.00', '1', '1', '2019-11-04 13:37:38', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('51', '1289397576', 'INVOICE', '2019-11-04', '102030003', 'Customer credit for Paid Amount For Invoice No1289397576', '0.00', '3.00', '1', '1', '2019-11-04 13:37:38', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('52', '1289397576', 'INVOICE', '2019-11-04', '1020101', 'Cash in Hand For Invoice No1289397576', '3.00', '0.00', '1', '1', '2019-11-04 13:37:38', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('53', '3642562739', 'INVOICE', '2019-11-04', '10107', 'Inventory credit For Invoice No3642562739', '0.00', '2.50', '1', '1', '2019-11-04 13:41:30', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('54', '3642562739', 'INVOICE', '2019-11-04', '102030003', 'Customer debit For Invoice No3642562739', '3.00', '0.00', '1', '1', '2019-11-04 13:41:30', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('55', '3642562739', 'INVOICE', '2019-11-04', '304', 'Customer debit For Invoice No3642562739', '0.00', '3.00', '1', '1', '2019-11-04 13:41:30', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('56', '3642562739', 'INVOICE', '2019-11-04', '102030003', 'Customer credit for Paid Amount For Invoice No3642562739', '0.00', '3.00', '1', '1', '2019-11-04 13:41:30', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('57', '3642562739', 'INVOICE', '2019-11-04', '1020101', 'Cash in Hand For Invoice No3642562739', '3.00', '0.00', '1', '1', '2019-11-04 13:41:30', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('58', '20191105061824', 'Purchase', '2019-11-05', '10107', 'Inventory Debit For Purchase No20191105061824', '309.00', '0.00', '1', '1', '2019-11-05 06:18:24', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('59', '20191105061824', 'Purchase', '2019-11-05', '50202010', 'Purchase No.20191105061824', '0.00', '309.00', '1', '1', '2019-11-05 00:00:00', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('60', '20191105061824', 'Purchase', '2019-11-05', '402', 'Company Credit For Purchase No20191105061824', '309.00', '0.00', '1', '1', '2019-11-05 06:18:24', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('61', '20191105061824', 'Purchase', '2019-11-05', '1020101', 'Cash in Hand For Purchase No20191105061824', '0.00', '309.00', '1', '1', '2019-11-05 06:18:24', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('62', '20191105061824', 'Purchase', '2019-11-05', '50202010', 'Purchase No.20191105061824', '309.00', '0.00', '1', '1', '2019-11-05 00:00:00', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('63', '6968189364', 'INVOICE', '2019-11-05', '10107', 'Inventory credit For Invoice No6968189364', '0.00', '5.00', '1', '1', '2019-11-05 12:05:08', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('64', '6968189364', 'INVOICE', '2019-11-05', '102030003', 'Customer debit For Invoice No6968189364', '6.00', '0.00', '1', '1', '2019-11-05 12:05:08', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('65', '6968189364', 'INVOICE', '2019-11-05', '304', 'Customer debit For Invoice No6968189364', '0.00', '6.00', '1', '1', '2019-11-05 12:05:08', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('66', '6968189364', 'INVOICE', '2019-11-05', '102030003', 'Customer credit for Paid Amount For Invoice No6968189364', '0.00', '6.00', '1', '1', '2019-11-05 12:05:08', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('67', '6968189364', 'INVOICE', '2019-11-05', '1020101', 'Cash in Hand For Invoice No6968189364', '6.00', '0.00', '1', '1', '2019-11-05 12:05:08', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('68', 'PM-1', 'PM', '2019-11-05', '50202003', 'dfasdf', '100.00', '0.00', '1', '1', '2019-11-05 13:07:09', NULL, NULL, '1');
INSERT INTO `acc_transaction` (`ID`, `VNo`, `Vtype`, `VDate`, `COAID`, `Narration`, `Debit`, `Credit`, `IsPosted`, `CreateBy`, `CreateDate`, `UpdateBy`, `UpdateDate`, `IsAppove`) VALUES ('69', 'PM-1', 'PM', '2019-11-05', '1020101', 'Cash in Hand For Voucher NoPM-1', '0.00', '100.00', '1', '1', '2019-11-05 13:07:09', NULL, NULL, '1');


#
# TABLE STRUCTURE FOR: accesslog
#

DROP TABLE IF EXISTS `accesslog`;

CREATE TABLE `accesslog` (
  `sl_no` bigint(20) NOT NULL AUTO_INCREMENT,
  `action_page` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `action_done` text COLLATE utf8_unicode_ci,
  `remarks` text COLLATE utf8_unicode_ci NOT NULL,
  `user_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `entry_date` datetime DEFAULT NULL,
  UNIQUE KEY `SerialNo` (`sl_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: accounts
#

DROP TABLE IF EXISTS `accounts`;

CREATE TABLE `accounts` (
  `account_id` varchar(20) NOT NULL,
  `account_table_name` varchar(255) NOT NULL,
  `account_name` varchar(255) NOT NULL,
  `status` int(5) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: asset_purchase
#

DROP TABLE IF EXISTS `asset_purchase`;

CREATE TABLE `asset_purchase` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `p_date` date NOT NULL,
  `supplier_id` varchar(30) NOT NULL,
  `grand_total` float NOT NULL,
  `payment_type` tinyint(4) DEFAULT NULL,
  `bank_id` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: attendance
#

DROP TABLE IF EXISTS `attendance`;

CREATE TABLE `attendance` (
  `att_id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `sign_in` varchar(30) NOT NULL,
  `sign_out` varchar(30) NOT NULL,
  `staytime` varchar(30) NOT NULL,
  PRIMARY KEY (`att_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: bank_add
#

DROP TABLE IF EXISTS `bank_add`;

CREATE TABLE `bank_add` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` varchar(50) NOT NULL,
  `bank_name` varchar(255) NOT NULL,
  `ac_name` varchar(250) DEFAULT NULL,
  `ac_number` varchar(250) DEFAULT NULL,
  `branch` varchar(250) DEFAULT NULL,
  `signature_pic` varchar(250) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `bank_add` (`id`, `bank_id`, `bank_name`, `ac_name`, `ac_number`, `branch`, `signature_pic`, `status`) VALUES ('1', '3IAF4ERDF2', 'Bangladesh Bank', 'Isahaq', '234234', 'Kawran Bazar', NULL, '1');


#
# TABLE STRUCTURE FOR: bank_summary
#

DROP TABLE IF EXISTS `bank_summary`;

CREATE TABLE `bank_summary` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` varchar(50) DEFAULT NULL,
  `description` text,
  `deposite_id` varchar(250) DEFAULT NULL,
  `date` varchar(250) DEFAULT NULL,
  `ac_type` varchar(50) DEFAULT NULL,
  `dr` decimal(12,2) DEFAULT '0.00',
  `cr` decimal(10,2) DEFAULT '0.00',
  `ammount` decimal(12,2) DEFAULT '0.00',
  `status` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: ci_sessions
#

DROP TABLE IF EXISTS `ci_sessions`;

CREATE TABLE `ci_sessions` (
  `id` varchar(128) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `data` blob NOT NULL,
  KEY `ci_sessions_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: company_information
#

DROP TABLE IF EXISTS `company_information`;

CREATE TABLE `company_information` (
  `company_id` varchar(50) NOT NULL,
  `company_name` varchar(250) NOT NULL,
  `email` varchar(50) NOT NULL,
  `address` text NOT NULL,
  `mobile` varchar(30) NOT NULL,
  `website` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `company_information` (`company_id`, `company_name`, `email`, `address`, `mobile`, `website`, `status`) VALUES ('NOILG8EGCRXXBWUEUQBM', 'bdtask Shop', 'bdtask@gmail.com', 'B-25, Mannan Plaza, 4th Floor, Khilkhet\r\nDhaka-1229, Bangladesh ', '1922296392', 'http://www.bdtask.com', '1');


#
# TABLE STRUCTURE FOR: currency_tbl
#

DROP TABLE IF EXISTS `currency_tbl`;

CREATE TABLE `currency_tbl` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `currency_name` varchar(50) NOT NULL,
  `icon` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `currency_tbl` (`id`, `currency_name`, `icon`) VALUES ('1', 'Taka', '৳');
INSERT INTO `currency_tbl` (`id`, `currency_name`, `icon`) VALUES ('2', 'Azerbaijan Manat', '₼');


#
# TABLE STRUCTURE FOR: customer_information
#

DROP TABLE IF EXISTS `customer_information`;

CREATE TABLE `customer_information` (
  `customer_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_address` varchar(255) NOT NULL,
  `customer_mobile` varchar(100) NOT NULL,
  `customer_email` varchar(100) NOT NULL,
  `status` int(2) NOT NULL,
  PRIMARY KEY (`customer_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `customer_information` (`customer_id`, `customer_name`, `customer_address`, `customer_mobile`, `customer_email`, `status`) VALUES ('1', 'Test customer', '', '', 'test@gmail.com', '1');
INSERT INTO `customer_information` (`customer_id`, `customer_name`, `customer_address`, `customer_mobile`, `customer_email`, `status`) VALUES ('2', 'ttttt', '', '', '', '1');
INSERT INTO `customer_information` (`customer_id`, `customer_name`, `customer_address`, `customer_mobile`, `customer_email`, `status`) VALUES ('3', 'rrrr', '', '', '', '1');
INSERT INTO `customer_information` (`customer_id`, `customer_name`, `customer_address`, `customer_mobile`, `customer_email`, `status`) VALUES ('4', 'jakir', '', '', 'jakir@gmail.com', '1');


#
# TABLE STRUCTURE FOR: customer_ledger
#

DROP TABLE IF EXISTS `customer_ledger`;

CREATE TABLE `customer_ledger` (
  `transaction_id` varchar(100) NOT NULL,
  `customer_id` bigint(20) NOT NULL,
  `invoice_no` bigint(20) DEFAULT NULL,
  `receipt_no` varchar(50) DEFAULT NULL,
  `amount` decimal(12,2) DEFAULT '0.00',
  `description` varchar(255) NOT NULL,
  `payment_type` varchar(255) NOT NULL,
  `cheque_no` varchar(255) NOT NULL,
  `date` varchar(50) NOT NULL,
  `status` int(2) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `d_c` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `receipt_no` (`receipt_no`),
  KEY `receipt_no_2` (`receipt_no`),
  KEY `receipt_no_3` (`receipt_no`),
  KEY `receipt_no_4` (`receipt_no`)
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=utf8;

INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('YXOFK6SJHN', '0', '0', NULL, '0.00', 'Previous adjustment with software', 'NA', 'NA', '2019-11-04', '1', '1', 'd');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('5JSXBP2S3FIMEX3', '1', '5738747829', NULL, '6.00', 'Cash Paid By Customer', '', '', '2019-11-04', '1', '2', 'c');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('5JSXBP2S3FIMEX3', '1', NULL, 'TTAQWFJNCF', '6.00', 'Medicine Received By Customer', '1', '', '2019-11-04', '1', '3', 'd');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('G8RG72SQDKLO5JD', '1', '5617473563', NULL, '3.00', 'Cash Paid By Customer', '', '', '2019-11-04', '1', '4', 'c');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('G8RG72SQDKLO5JD', '1', NULL, '2VKBM2VKPA', '3.00', 'Medicine Received By Customer', '1', '', '2019-11-04', '1', '5', 'd');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('BZOZGCRGLV', '4', '0', NULL, '0.00', 'Previous adjustment with software', 'NA', 'NA', '2019-11-04', '1', '6', 'd');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('HOMWP8AVV3JM7XQ', '4', '2421265827', NULL, '6.00', 'Cash Paid By Customer', '', '', '2019-11-04', '1', '7', 'c');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('HOMWP8AVV3JM7XQ', '4', NULL, 'KR8168MGGJ', '6.00', 'Medicine Received By Customer', '1', '', '2019-11-04', '1', '8', 'd');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('GEWLZ1VKFSGFAGJ', '4', '8882516716', NULL, '6.00', 'Cash Paid By Customer', '', '', '2019-11-04', '1', '9', 'c');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('GEWLZ1VKFSGFAGJ', '4', NULL, '2TNKUWMLUP', '6.00', 'Medicine Received By Customer', '1', '', '2019-11-04', '1', '10', 'd');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('CFG3ZL67QFNY839', '4', '3846639867', NULL, '3.00', 'Cash Paid By Customer', '', '', '2019-11-04', '1', '11', 'c');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('CFG3ZL67QFNY839', '4', NULL, 'BX3FDCMAHK', '3.00', 'Medicine Received By Customer', '1', '', '2019-11-04', '1', '12', 'd');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('KPNCIKVPMVVGG81', '4', '1349611216', NULL, '3.00', 'Cash Paid By Customer', '', '', '2019-11-04', '1', '13', 'c');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('KPNCIKVPMVVGG81', '4', NULL, 'KEGXA95A5P', '3.00', 'Medicine Received By Customer', '1', '', '2019-11-04', '1', '14', 'd');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('7VTD2OCL3Q5MD3L', '4', '6778188768', NULL, '3.00', 'Cash Paid By Customer', '', '', '2019-11-04', '1', '15', 'c');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('7VTD2OCL3Q5MD3L', '4', NULL, '8LXAL8B32C', '3.00', 'Medicine Received By Customer', '1', '', '2019-11-04', '1', '16', 'd');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('XXZ89YOREVOV9HW', '4', '4255549598', NULL, '3.00', 'Cash Paid By Customer', '', '', '2019-11-04', '1', '17', 'c');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('XXZ89YOREVOV9HW', '4', NULL, 'ZYOVW89OKC', '3.00', 'Medicine Received By Customer', '1', '', '2019-11-04', '1', '18', 'd');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('19Q61V5WAOZ13U3', '4', '5764724144', NULL, '3.00', 'Cash Paid By Customer', '', '', '2019-11-04', '1', '19', 'c');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('19Q61V5WAOZ13U3', '4', NULL, '4XIHBVNIGB', '3.00', 'Medicine Received By Customer', '1', '', '2019-11-04', '1', '20', 'd');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('IB387R3AT1ZWGVP', '4', '2225599822', NULL, '3.00', 'Cash Paid By Customer', '', '', '2019-11-04', '1', '21', 'c');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('IB387R3AT1ZWGVP', '4', NULL, 'OGGI8CH2SA', '3.00', 'Medicine Received By Customer', '1', '', '2019-11-04', '1', '22', 'd');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('8S2FMATANTJXMDU', '4', '1289397576', NULL, '3.00', 'Cash Paid By Customer', '', '', '2019-11-04', '1', '23', 'c');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('8S2FMATANTJXMDU', '4', NULL, 'NWPQ6RAU9L', '3.00', 'Medicine Received By Customer', '1', '', '2019-11-04', '1', '24', 'd');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('POAXIIU39MF47W1', '4', '3642562739', NULL, '3.00', 'Cash Paid By Customer', '', '', '2019-11-04', '1', '25', 'c');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('POAXIIU39MF47W1', '4', NULL, 'E2E65KZ84J', '3.00', 'Medicine Received By Customer', '1', '', '2019-11-04', '1', '26', 'd');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('R71NG3HCQYSDONR', '4', '6968189364', NULL, '6.00', 'Cash Paid By Customer', '', '', '2019-11-05', '1', '27', 'c');
INSERT INTO `customer_ledger` (`transaction_id`, `customer_id`, `invoice_no`, `receipt_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `id`, `d_c`) VALUES ('R71NG3HCQYSDONR', '4', NULL, 'WC5UJCYOBH', '6.00', 'Medicine Received By Customer', '1', '', '2019-11-05', '1', '28', 'd');


#
# TABLE STRUCTURE FOR: daily_banking_add
#

DROP TABLE IF EXISTS `daily_banking_add`;

CREATE TABLE `daily_banking_add` (
  `banking_id` varchar(255) NOT NULL,
  `date` varchar(50) NOT NULL,
  `bank_id` varchar(100) NOT NULL,
  `deposit_type` varchar(255) NOT NULL,
  `transaction_type` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `amount` float NOT NULL,
  `status` int(2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: daily_closing
#

DROP TABLE IF EXISTS `daily_closing`;

CREATE TABLE `daily_closing` (
  `closing_id` varchar(255) NOT NULL,
  `last_day_closing` float NOT NULL,
  `cash_in` float NOT NULL,
  `cash_out` float NOT NULL,
  `date` varchar(50) NOT NULL,
  `amount` float NOT NULL,
  `adjustment` float NOT NULL,
  `status` int(2) NOT NULL,
  PRIMARY KEY (`closing_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: designation
#

DROP TABLE IF EXISTS `designation`;

CREATE TABLE `designation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `designation` varchar(150) NOT NULL,
  `details` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: employee_history
#

DROP TABLE IF EXISTS `employee_history`;

CREATE TABLE `employee_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `first_name` varchar(50) NOT NULL,
  `last_name` varchar(50) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `phone` varchar(50) NOT NULL,
  `rate_type` int(11) NOT NULL,
  `hrate` float NOT NULL,
  `email` varchar(50) NOT NULL,
  `blood_group` varchar(10) NOT NULL,
  `address_line_1` text NOT NULL,
  `address_line_2` text NOT NULL,
  `image` text,
  `country` varchar(50) NOT NULL,
  `city` varchar(50) NOT NULL,
  `zip` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: employee_salary_payment
#

DROP TABLE IF EXISTS `employee_salary_payment`;

CREATE TABLE `employee_salary_payment` (
  `emp_sal_pay_id` int(11) NOT NULL AUTO_INCREMENT,
  `generate_id` int(11) NOT NULL,
  `employee_id` varchar(50) CHARACTER SET latin1 NOT NULL,
  `total_salary` decimal(18,2) NOT NULL DEFAULT '0.00',
  `total_working_minutes` varchar(50) CHARACTER SET latin1 NOT NULL,
  `working_period` varchar(50) CHARACTER SET latin1 NOT NULL,
  `payment_due` varchar(50) CHARACTER SET latin1 NOT NULL,
  `payment_date` varchar(50) CHARACTER SET latin1 NOT NULL,
  `paid_by` varchar(50) CHARACTER SET latin1 NOT NULL,
  `salary_month` varchar(70) DEFAULT NULL,
  PRIMARY KEY (`emp_sal_pay_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: employee_salary_setup
#

DROP TABLE IF EXISTS `employee_salary_setup`;

CREATE TABLE `employee_salary_setup` (
  `e_s_s_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` varchar(30) CHARACTER SET latin1 NOT NULL,
  `sal_type` varchar(30) NOT NULL,
  `salary_type_id` varchar(30) CHARACTER SET latin1 NOT NULL,
  `amount` decimal(12,2) NOT NULL DEFAULT '0.00',
  `create_date` date DEFAULT NULL,
  `update_date` datetime(6) DEFAULT NULL,
  `update_id` varchar(30) CHARACTER SET latin1 NOT NULL,
  `gross_salary` float NOT NULL,
  PRIMARY KEY (`e_s_s_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: expense
#

DROP TABLE IF EXISTS `expense`;

CREATE TABLE `expense` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `type` varchar(100) NOT NULL,
  `voucher_no` varchar(50) NOT NULL,
  `amount` float NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: expense_item
#

DROP TABLE IF EXISTS `expense_item`;

CREATE TABLE `expense_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `expense_item_name` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `expense_item` (`id`, `expense_item_name`) VALUES ('1', 'Gass Bill');
INSERT INTO `expense_item` (`id`, `expense_item_name`) VALUES ('2', 'Pc');
INSERT INTO `expense_item` (`id`, `expense_item_name`) VALUES ('3', 'Nasta');


#
# TABLE STRUCTURE FOR: fixed_assets
#

DROP TABLE IF EXISTS `fixed_assets`;

CREATE TABLE `fixed_assets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_code` varchar(50) NOT NULL,
  `item_name` varchar(100) NOT NULL,
  `price` float NOT NULL,
  `insert_date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: invoice
#

DROP TABLE IF EXISTS `invoice`;

CREATE TABLE `invoice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint(20) DEFAULT NULL,
  `customer_id` bigint(20) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `total_amount` decimal(12,2) NOT NULL DEFAULT '0.00',
  `invoice` bigint(20) DEFAULT NULL,
  `total_discount` decimal(10,2) DEFAULT '0.00' COMMENT 'total invoice discount',
  `invoice_discount` decimal(12,2) NOT NULL DEFAULT '0.00',
  `total_tax` decimal(10,2) DEFAULT '0.00',
  `prevous_due` decimal(10,2) NOT NULL DEFAULT '0.00',
  `sales_by` varchar(30) DEFAULT NULL,
  `invoice_details` varchar(200) DEFAULT NULL,
  `status` int(2) NOT NULL,
  `payment_type` int(11) NOT NULL DEFAULT '1',
  `bank_id` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

INSERT INTO `invoice` (`id`, `invoice_id`, `customer_id`, `date`, `total_amount`, `invoice`, `total_discount`, `invoice_discount`, `total_tax`, `prevous_due`, `sales_by`, `invoice_details`, `status`, `payment_type`, `bank_id`) VALUES ('1', '5738747829', '1', '2019-11-04', '6.00', '1000', '0.00', '0.00', '0.00', '0.00', '1', 'sdfasd', '1', '1', NULL);
INSERT INTO `invoice` (`id`, `invoice_id`, `customer_id`, `date`, `total_amount`, `invoice`, `total_discount`, `invoice_discount`, `total_tax`, `prevous_due`, `sales_by`, `invoice_details`, `status`, `payment_type`, `bank_id`) VALUES ('2', '5617473563', '1', '2019-11-04', '3.00', '1001', '0.00', '0.00', '0.00', '0.00', '1', '', '1', '1', NULL);
INSERT INTO `invoice` (`id`, `invoice_id`, `customer_id`, `date`, `total_amount`, `invoice`, `total_discount`, `invoice_discount`, `total_tax`, `prevous_due`, `sales_by`, `invoice_details`, `status`, `payment_type`, `bank_id`) VALUES ('3', '2421265827', '4', '2019-11-04', '6.00', '1002', '0.00', '0.00', '0.00', '0.00', '1', '', '1', '1', NULL);
INSERT INTO `invoice` (`id`, `invoice_id`, `customer_id`, `date`, `total_amount`, `invoice`, `total_discount`, `invoice_discount`, `total_tax`, `prevous_due`, `sales_by`, `invoice_details`, `status`, `payment_type`, `bank_id`) VALUES ('4', '8882516716', '4', '2019-11-04', '6.00', '1003', '0.00', '0.00', '0.00', '0.00', '1', '', '1', '1', NULL);
INSERT INTO `invoice` (`id`, `invoice_id`, `customer_id`, `date`, `total_amount`, `invoice`, `total_discount`, `invoice_discount`, `total_tax`, `prevous_due`, `sales_by`, `invoice_details`, `status`, `payment_type`, `bank_id`) VALUES ('5', '3846639867', '4', '2019-11-04', '3.00', '1004', '0.00', '0.00', '0.00', '0.00', '1', '', '1', '1', NULL);
INSERT INTO `invoice` (`id`, `invoice_id`, `customer_id`, `date`, `total_amount`, `invoice`, `total_discount`, `invoice_discount`, `total_tax`, `prevous_due`, `sales_by`, `invoice_details`, `status`, `payment_type`, `bank_id`) VALUES ('6', '1349611216', '4', '2019-11-04', '3.00', '1005', '0.00', '0.00', '0.00', '0.00', '1', '', '1', '1', NULL);
INSERT INTO `invoice` (`id`, `invoice_id`, `customer_id`, `date`, `total_amount`, `invoice`, `total_discount`, `invoice_discount`, `total_tax`, `prevous_due`, `sales_by`, `invoice_details`, `status`, `payment_type`, `bank_id`) VALUES ('7', '6778188768', '4', '2019-11-04', '3.00', '1006', '0.00', '0.00', '0.00', '0.00', '1', 'sadf', '1', '1', NULL);
INSERT INTO `invoice` (`id`, `invoice_id`, `customer_id`, `date`, `total_amount`, `invoice`, `total_discount`, `invoice_discount`, `total_tax`, `prevous_due`, `sales_by`, `invoice_details`, `status`, `payment_type`, `bank_id`) VALUES ('8', '4255549598', '4', '2019-11-04', '3.00', '1007', '0.00', '0.00', '0.00', '0.00', '1', 'asdf', '1', '1', NULL);
INSERT INTO `invoice` (`id`, `invoice_id`, `customer_id`, `date`, `total_amount`, `invoice`, `total_discount`, `invoice_discount`, `total_tax`, `prevous_due`, `sales_by`, `invoice_details`, `status`, `payment_type`, `bank_id`) VALUES ('9', '5764724144', '4', '2019-11-04', '3.00', '1008', '0.00', '0.00', '0.00', '0.00', '1', 'asdf', '1', '1', NULL);
INSERT INTO `invoice` (`id`, `invoice_id`, `customer_id`, `date`, `total_amount`, `invoice`, `total_discount`, `invoice_discount`, `total_tax`, `prevous_due`, `sales_by`, `invoice_details`, `status`, `payment_type`, `bank_id`) VALUES ('10', '2225599822', '4', '2019-11-04', '3.00', '1009', '0.00', '0.00', '0.00', '0.00', '1', 'sdfsdf', '1', '1', NULL);
INSERT INTO `invoice` (`id`, `invoice_id`, `customer_id`, `date`, `total_amount`, `invoice`, `total_discount`, `invoice_discount`, `total_tax`, `prevous_due`, `sales_by`, `invoice_details`, `status`, `payment_type`, `bank_id`) VALUES ('11', '1289397576', '4', '2019-11-04', '3.00', '1010', '0.00', '0.00', '0.00', '0.00', '1', '', '1', '1', NULL);
INSERT INTO `invoice` (`id`, `invoice_id`, `customer_id`, `date`, `total_amount`, `invoice`, `total_discount`, `invoice_discount`, `total_tax`, `prevous_due`, `sales_by`, `invoice_details`, `status`, `payment_type`, `bank_id`) VALUES ('12', '3642562739', '4', '2019-11-04', '3.00', '1011', '0.00', '0.00', '0.00', '0.00', '1', 'sdfsadf', '1', '1', NULL);
INSERT INTO `invoice` (`id`, `invoice_id`, `customer_id`, `date`, `total_amount`, `invoice`, `total_discount`, `invoice_discount`, `total_tax`, `prevous_due`, `sales_by`, `invoice_details`, `status`, `payment_type`, `bank_id`) VALUES ('13', '6968189364', '4', '2019-11-05', '6.00', '1012', '0.00', '0.00', '0.00', '0.00', '1', 'sdfsadf', '1', '1', NULL);


#
# TABLE STRUCTURE FOR: invoice_details
#

DROP TABLE IF EXISTS `invoice_details`;

CREATE TABLE `invoice_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_details_id` varchar(30) NOT NULL,
  `invoice_id` bigint(20) NOT NULL,
  `product_id` varchar(100) NOT NULL,
  `batch_id` varchar(30) NOT NULL,
  `cartoon` float DEFAULT NULL,
  `quantity` float NOT NULL,
  `rate` decimal(12,2) DEFAULT NULL,
  `manufacturer_rate` decimal(10,2) DEFAULT NULL,
  `total_price` decimal(12,2) DEFAULT NULL,
  `discount` decimal(12,0) DEFAULT NULL,
  `tax` decimal(10,2) DEFAULT NULL,
  `paid_amount` decimal(12,0) DEFAULT NULL,
  `due_amount` decimal(10,2) DEFAULT NULL,
  `status` int(2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `invoice_details` (`id`, `invoice_details_id`, `invoice_id`, `product_id`, `batch_id`, `cartoon`, `quantity`, `rate`, `manufacturer_rate`, `total_price`, `discount`, `tax`, `paid_amount`, `due_amount`, `status`) VALUES ('1', '867332383851112', '2225599822', '16894289299193758839', '23423', NULL, '1', '3.00', '2.50', '3.00', '0', NULL, '3', '0.00', '1');
INSERT INTO `invoice_details` (`id`, `invoice_details_id`, `invoice_id`, `product_id`, `batch_id`, `cartoon`, `quantity`, `rate`, `manufacturer_rate`, `total_price`, `discount`, `tax`, `paid_amount`, `due_amount`, `status`) VALUES ('2', '588337437379775', '1289397576', '16894289299193758839', '23423', NULL, '1', '3.00', '2.50', '3.00', '0', NULL, '3', '0.00', '1');
INSERT INTO `invoice_details` (`id`, `invoice_details_id`, `invoice_id`, `product_id`, `batch_id`, `cartoon`, `quantity`, `rate`, `manufacturer_rate`, `total_price`, `discount`, `tax`, `paid_amount`, `due_amount`, `status`) VALUES ('3', '947843776724224', '3642562739', '16894289299193758839', '23423', NULL, '1', '3.00', '2.50', '3.00', '0', NULL, '3', '0.00', '1');
INSERT INTO `invoice_details` (`id`, `invoice_details_id`, `invoice_id`, `product_id`, `batch_id`, `cartoon`, `quantity`, `rate`, `manufacturer_rate`, `total_price`, `discount`, `tax`, `paid_amount`, `due_amount`, `status`) VALUES ('4', '753454383396244', '6968189364', '16894289299193758839', '23423', NULL, '2', '3.00', '2.50', '6.00', '0', NULL, '6', '0.00', '1');


#
# TABLE STRUCTURE FOR: language
#

DROP TABLE IF EXISTS `language`;

CREATE TABLE `language` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `phrase` text NOT NULL,
  `english` text,
  `bangla` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=903 DEFAULT CHARSET=utf8;

INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('1', 'user_profile', 'User Profile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('2', 'setting', 'Web Setting', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('3', 'language', 'Language', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('4', 'manage_users', 'Manage Users', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('5', 'add_user', 'Add User', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('6', 'manage_company', 'Manage Company', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('7', 'web_settings', 'Software Settings', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('8', 'manage_accounts', 'Manage Accounts', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('9', 'create_accounts', 'Create Accounts', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('10', 'manage_bank', 'Manage Bank', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('11', 'add_new_bank', 'Add New Bank', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('12', 'settings', 'Settings', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('13', 'closing_report', 'Closing Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('14', 'closing', 'Closing', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('15', 'cheque_manager', 'Cheque Manager', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('16', 'accounts_summary', 'Accounts Summary', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('17', 'expense', 'Expense', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('18', 'income', 'Income', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('19', 'accounts', 'Accounts', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('20', 'stock_report', 'Stock Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('21', 'stock', 'Stock', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('22', 'pos_invoice', 'POS Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('23', 'manage_invoice', 'Manage Invoice ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('24', 'new_invoice', 'New Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('25', 'invoice', 'Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('26', 'manage_purchase', 'Manage Purchase', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('27', 'add_purchase', 'Add Purchase', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('28', 'purchase', 'Purchase', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('29', 'paid_customer', 'Paid Customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('30', 'manage_customer', 'Manage Customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('31', 'add_customer', 'Add Customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('32', 'customer', 'Customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('33', 'manufacturer_payment_actual', 'Manufacturer Payment Actual', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('34', 'manufacturer_sales_summary', 'Manufacturer  Sales Summary', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('35', 'manufacturer_sales_details', 'Manufacturer Sales Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('36', 'manufacturer_ledger', 'Manufacturer Ledger', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('37', 'manage_manufacturer', 'Manage Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('38', 'add_manufacturer', 'Add Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('39', 'manufacturer', 'Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('40', 'product_statement', 'Medicine Statement', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('41', 'manage_product', 'Manage Medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('42', 'add_product', 'Add Medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('43', 'product', 'Medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('44', 'manage_category', 'Manage Category', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('45', 'add_category', 'Add Category', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('46', 'category', 'Category', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('47', 'sales_report_product_wise', 'Sales Report (Medicine Wise)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('48', 'purchase_report', 'Purchase Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('49', 'sales_report', 'Sales Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('50', 'todays_report', 'Todays Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('51', 'report', 'Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('52', 'dashboard', 'Dashboard', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('53', 'online', 'Online', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('54', 'logout', 'Logout', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('56', 'total_purchase', 'Total Purchase', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('57', 'total_amount', 'Total Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('58', 'manufacturer_name', 'Manufacturer  Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('59', 'invoice_no', 'Invoice No', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('60', 'purchase_date', 'Purchase Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('61', 'todays_purchase_report', 'Todays Purchase Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('62', 'total_sales', 'Total Sales', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('63', 'customer_name', 'Customer Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('64', 'sales_date', 'Sales Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('65', 'todays_sales_report', 'Todays Sales Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('66', 'home', 'Home', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('67', 'todays_sales_and_purchase_report', 'Todays sales and purchase report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('68', 'total_ammount', 'Total Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('69', 'rate', 'Sale Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('70', 'product_model', 'Medicine Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('71', 'product_name', 'Medicine Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('72', 'search', 'Search', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('73', 'end_date', 'End Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('74', 'start_date', 'Start Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('75', 'total_purchase_report', 'Total Purchase Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('76', 'total_sales_report', 'Total Sales Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('77', 'total_seles', 'Total Sales', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('78', 'all_stock_report', 'All Stock Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('79', 'search_by_product', 'Search By Medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('80', 'date', 'Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('81', 'print', 'Print', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('82', 'stock_date', 'Stock Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('83', 'print_date', 'Print Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('84', 'sales', 'Sales', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('85', 'price', 'Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('86', 'sl', 'SL.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('87', 'add_new_category', 'Add new category', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('88', 'category_name', 'Category Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('89', 'save', 'Save', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('90', 'delete', 'Delete', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('91', 'update', 'Update', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('92', 'action', 'Action', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('93', 'manage_your_category', 'Manage your category ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('94', 'category_edit', 'Category Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('95', 'status', 'Status', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('96', 'active', 'Active', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('97', 'inactive', 'Inactive', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('98', 'save_changes', 'Save Changes', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('99', 'save_and_add_another', 'Save And Add Another', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('100', 'model', 'Medicine Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('101', 'manufacturer_price', 'Manufacturer Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('102', 'sell_price', 'Sell Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('103', 'image', 'Image', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('104', 'select_one', 'Select One', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('105', 'details', 'Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('106', 'new_product', 'New Medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('107', 'add_new_product', 'Add new medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('108', 'barcode', 'Barcode', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('109', 'qr_code', 'Qr-Code', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('110', 'product_details', 'Medicine Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('111', 'manage_your_product', 'Manage your medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('112', 'product_edit', 'Medicine Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('113', 'edit_your_product', 'Edit your medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('114', 'cancel', 'Cancel', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('115', 'incl_vat', 'Incl. Vat', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('116', 'money', 'Dollar', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('117', 'grand_total', 'Grand Total', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('118', 'quantity', 'Quantity', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('119', 'product_report', 'Medicine Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('120', 'product_sales_and_purchase_report', 'Medicine sales and purchase report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('121', 'previous_stock', 'Previous Stock', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('122', 'out', 'Out', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('123', 'in', 'In', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('124', 'to', 'To', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('125', 'previous_balance', 'Previous Balance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('126', 'customer_address', 'Customer Address', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('127', 'customer_mobile', 'Customer Mobile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('128', 'customer_email', 'Customer Email', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('129', 'add_new_customer', 'Add new customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('130', 'balance', 'Balance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('131', 'mobile', 'Mobile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('132', 'address', 'Address', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('133', 'manage_your_customer', 'Manage your customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('134', 'customer_edit', 'Customer Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('135', 'paid_customer_list', 'Paid Customer List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('136', 'ammount', 'Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('137', 'customer_ledger', 'Customer Ledger', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('138', 'manage_customer_ledger', 'Manage Customer Ledger', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('139', 'customer_information', 'Customer Information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('140', 'debit_ammount', 'Debit Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('141', 'credit_ammount', 'Credit Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('142', 'balance_ammount', 'Balance Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('143', 'receipt_no', 'Receipt NO', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('144', 'description', 'Description', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('145', 'debit', 'Debit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('146', 'credit', 'Credit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('147', 'item_information', 'Item Information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('148', 'total', 'Total', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('149', 'please_select_manufacturer', 'Please Select Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('150', 'submit', 'Submit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('151', 'submit_and_add_another', 'Submit And Add Another One', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('152', 'add_new_item', 'Add New Item', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('153', 'manage_your_purchase', 'Manage your purchase', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('154', 'purchase_edit', 'Purchase Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('155', 'purchase_ledger', 'Purchase Ledger', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('156', 'invoice_information', 'Invoice Information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('157', 'paid_ammount', 'Paid Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('158', 'discount', 'Discount / Pcs.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('159', 'save_and_paid', 'Save And Paid', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('160', 'payee_name', 'Payee Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('161', 'manage_your_invoice', 'Manage your invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('162', 'invoice_edit', 'Invoice Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('163', 'new_pos_invoice', 'New POS invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('164', 'add_new_pos_invoice', 'Add new pos invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('165', 'product_id', 'Medicine ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('166', 'paid_amount', 'Paid Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('167', 'authorised_by', 'Authorised By', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('168', 'checked_by', 'Checked By', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('169', 'received_by', 'Received By', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('170', 'prepared_by', 'Prepared By', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('171', 'memo_no', 'Memo No', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('172', 'website', 'Website', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('173', 'email', 'Email', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('174', 'invoice_details', 'Invoice Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('175', 'reset', 'Reset', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('176', 'payment_account', 'Payment Account', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('177', 'bank_name', 'Bank Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('178', 'cheque_or_pay_order_no', 'Cheque/Pay Order No', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('179', 'payment_type', 'Payment Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('180', 'payment_from', 'Payment From', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('181', 'payment_date', 'Payment Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('182', 'add_income', 'Add Income', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('183', 'cash', 'Cash', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('184', 'cheque', 'Cheque', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('185', 'pay_order', 'Pay Order', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('186', 'payment_to', 'Payment To', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('187', 'total_expense_ammount', 'Total Expense Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('188', 'transections', 'Transactions', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('189', 'accounts_name', 'Accounts Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('190', 'outflow_report', 'Expense Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('191', 'inflow_report', 'Income Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('192', 'all', 'All', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('193', 'account', 'Account', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('194', 'from', 'From', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('195', 'account_summary_report', 'Account Summary Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('196', 'search_by_date', 'Search By Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('197', 'cheque_no', 'Cheque No', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('198', 'name', 'Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('199', 'closing_account', 'Closing Account', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('200', 'close_your_account', 'Close your account', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('201', 'last_day_closing', 'Last Day Closing', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('202', 'cash_in', 'Cash In', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('203', 'cash_out', 'Cash Out', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('204', 'cash_in_hand', 'Cash In Hand', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('205', 'add_new_bank', 'Add New Bank', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('206', 'day_closing', 'Day Closing', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('207', 'account_closing_report', 'Account Closing Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('208', 'last_day_ammount', 'Last Day Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('209', 'adjustment', 'Adjustment', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('210', 'pay_type', 'Pay Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('211', 'customer_or_manufacturer', 'Customer,Manufacturer Or Others', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('212', 'transection_id', 'Transactions ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('213', 'accounts_summary_report', 'Accounts Summary Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('214', 'bank_list', 'Bank List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('215', 'bank_edit', 'Bank Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('216', 'debit_plus', 'Debit (+)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('217', 'credit_minus', 'Credit (-)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('218', 'account_name', 'Account Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('219', 'account_type', 'Account Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('220', 'account_real_name', 'Account Real Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('221', 'manage_account', 'Manage Account', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('222', 'company_name', 'Company Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('223', 'edit_your_company_information', 'Edit your company information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('224', 'company_edit', 'Company Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('225', 'admin', 'Admin', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('226', 'user', 'User', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('227', 'password', 'Password', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('228', 'last_name', 'Last Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('229', 'first_name', 'First Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('230', 'add_new_user_information', 'Add new user information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('231', 'user_type', 'User Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('232', 'user_edit', 'User Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('233', 'rtr', 'RTR', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('234', 'ltr', 'LTR', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('235', 'ltr_or_rtr', 'LTR/RTR', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('236', 'footer_text', 'Footer Text', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('237', 'favicon', 'Favicon', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('238', 'logo', 'Logo', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('239', 'update_setting', 'Update Setting', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('240', 'update_your_web_setting', 'Update your Web setting', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('241', 'login', 'Login', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('242', 'your_strong_password', 'Your strong password', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('243', 'your_unique_email', 'Your unique email', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('244', 'please_enter_your_login_information', 'Please enter your login information.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('245', 'update_profile', 'Update Profile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('246', 'your_profile', 'Your Profile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('247', 're_type_password', 'Re-Type Password', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('248', 'new_password', 'New Password', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('249', 'old_password', 'Old Password', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('250', 'new_information', 'New Information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('251', 'old_information', 'Old Information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('252', 'change_your_information', 'Change your information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('253', 'change_your_profile', 'Change your profile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('254', 'profile', 'Profile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('255', 'wrong_username_or_password', 'Wrong User Name Or Password !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('256', 'successfully_updated', 'Successfully Updated.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('257', 'blank_field_does_not_accept', 'Blank Field Does Not Accept !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('258', 'successfully_changed_password', 'Successfully changed password.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('259', 'you_are_not_authorised_person', 'You are not authorised person !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('260', 'password_and_repassword_does_not_match', 'Passwor and re-password does not match !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('261', 'new_password_at_least_six_character', 'New Password At Least 6 Character.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('262', 'you_put_wrong_email_address', 'You put wrong email address !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('263', 'cheque_ammount_asjusted', 'Cheque amount adjusted.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('264', 'successfully_payment_paid', 'Successfully Payment Paid.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('265', 'successfully_added', 'Successfully Added.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('266', 'successfully_updated_2_closing_ammount_not_changeale', 'Successfully Updated -2. Note: Closing Amount Not Changeable.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('267', 'successfully_payment_received', 'Successfully Payment Received.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('268', 'already_inserted', 'Already Inserted !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('269', 'successfully_delete', 'Successfully Delete.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('270', 'successfully_created', 'Successfully Created.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('271', 'logo_not_uploaded', 'Logo not uploaded !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('272', 'favicon_not_uploaded', 'Favicon not uploaded !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('273', 'manufacturer_mobile', 'Manufacturer  Mobile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('274', 'manufacturer_address', 'Manufacturer  Address', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('275', 'manufacturer_details', 'Manufacturer Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('276', 'add_new_manufacturer', 'Add New Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('277', 'manage_suppiler', 'Manage Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('278', 'manage_your_manufacturer', 'Manage your Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('279', 'manage_manufacturer_ledger', 'Manage Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('280', 'invoice_id', 'Invoice ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('281', 'deposite_id', 'Deposit ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('282', 'manufacturer_actual_ledger', 'Manufacturer Actual Ledger', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('283', 'manufacturer_information', 'Manufacturer Information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('284', 'event', 'Event', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('285', 'add_new_income', 'Add New Income', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('286', 'add_expese', 'Add Expense', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('287', 'add_new_expense', 'Add New Expense', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('288', 'total_income_ammount', 'Total Income Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('289', 'create_new_invoice', 'Create New Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('290', 'create_pos_invoice', 'Create POS Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('291', 'total_profit', 'Total Profit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('292', 'monthly_progress_report', 'Monthly Progress Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('293', 'total_invoice', 'Total Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('294', 'account_summary', 'Account Summary', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('295', 'total_manufacturer', 'Total manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('296', 'total_product', 'Total Medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('297', 'total_customer', 'Total Customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('298', 'manufacturer_edit', 'Manufacturer Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('299', 'add_new_invoice', 'Add New Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('300', 'add_new_purchase', 'Add new purchase', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('301', 'currency', 'Currency', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('302', 'currency_position', 'Currency Position', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('303', 'left', 'Left', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('304', 'right', 'Right', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('305', 'add_tax', 'Add Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('306', 'manage_tax', 'Manage Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('307', 'add_new_tax', 'Add new tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('308', 'enter_tax', 'Enter Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('309', 'already_exists', 'Already Exists !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('310', 'successfully_inserted', 'Successfully Inserted.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('311', 'tax', 'Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('312', 'tax_edit', 'Tax Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('313', 'product_not_added', 'Medicine not added !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('314', 'total_tax', 'Total Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('315', 'manage_your_manufacturer_details', 'Manage your Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('316', 'invoice_description', 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s                                       standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('317', 'thank_you_for_choosing_us', 'Thank you very much for choosing us.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('318', 'billing_date', 'Billing Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('319', 'billing_to', 'Billing To', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('320', 'billing_from', 'Billing From', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('321', 'you_cant_delete_this_product', 'Sorry !!  You can\'t delete this medicine.This medicine already used in calculation system!', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('322', 'old_customer', 'Old Customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('323', 'new_customer', 'New Customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('324', 'new_manufacturer', 'New Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('325', 'old_manufacturer', 'Old Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('326', 'credit_customer', 'Credit Customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('327', 'account_already_exists', 'This Account Already Exists !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('328', 'edit_income', 'Edit Income', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('329', 'you_are_not_access_this_part', 'You are not authorised person !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('330', 'account_edit', 'Account Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('331', 'due', 'Due', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('332', 'expense_edit', 'Expense Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('333', 'please_select_customer', 'Please select customer !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('334', 'profit_report', 'Profit Report (Invoice Wise)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('335', 'total_profit_report', 'Total profit report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('336', 'please_enter_valid_captcha', 'Please enter valid captcha.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('337', 'category_not_selected', 'Category not selected.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('338', 'manufacturer_not_selected', 'Manufacturer not selected.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('339', 'please_select_product', 'Please select medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('340', 'product_model_already_exist', 'Medicine model already exist !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('341', 'invoice_logo', 'Invoice Logo', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('342', 'available_quantity', 'Available Quantity', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('343', 'you_can_not_buy_greater_than_available_quantity', 'You can not select grater than availale quantity !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('344', 'customer_details', 'Customer details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('345', 'manage_customer_details', 'Manage customer details.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('346', 'box_size', 'Box size', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('347', 'expire_date', 'Expiry  date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('348', 'product_location', 'Medicine  Shelf', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('349', 'generic_name', 'Generic name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('350', 'payment_method', 'Payment Method', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('351', 'card_no', 'Card no', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('352', 'medicine', 'Medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('353', 'medicine_search', 'Medicine Search', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('354', 'what_you_search', 'Enter what you search', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('355', 'company', 'Company', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('356', 'customer_search', 'Customer search', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('357', 'invoice_search', 'Invoice search', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('358', 'purchase_search', 'Purchase search', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('359', 'daily_closing_report', 'Daily closing report.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('360', 'closing_search_report', 'Closing Search Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('361', 'category_list', 'Category List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('362', 'company_list', 'Company List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('363', 'customers_list', 'Customer List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('364', 'credit_customer_list', 'Credit Customer List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('365', 'previous_balance_adjustment', 'Previous Balance Adjustment', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('366', 'invoice_list', 'Invoice List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('367', 'add_pos_invoice', 'Add POS Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('368', 'add_invoice', 'Add Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('369', 'product_list', 'Medicine List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('370', 'purchases_list', 'Purchase List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('371', 'purchase_list', 'Purchase List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('372', 'stock_list', 'Stock List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('373', 'all_report', 'All Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('374', 'daily_sales_report', 'Daily sales Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('375', 'product_wise_sales_report', 'Medicine Wise Sales Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('376', 'bank_update', 'Bank Update', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('377', 'account_list', 'Account List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('378', 'manufacturer_list', 'Manufacturer  List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('379', 'manufacturer_search_item', 'Manufacturer  Search Item', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('380', 'user_list', 'User List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('381', 'user_search_item', 'User Search Item', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('382', 'change_password', 'Change Password', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('383', 'admin_login_area', 'Admin Login Area', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('384', 'accounts_inflow_form', 'Account Inflow Form', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('385', 'accounts_outflow_form', 'Accounts Outflow Form', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('386', 'accounts_tax_form', 'Accounts Tax Form', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('387', 'accounts_manage_tax', 'Accounts Manage Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('388', 'accounts_tax_edit', 'Accounts Tax Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('389', 'accounts_summary_data', 'Accounts Summary Data', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('390', 'accounts_details_data', 'Accounts Details Data', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('391', 'datewise_summary_data', 'Datewise Summary Data', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('392', 'accounts_cheque_manager', 'Account Cheque Manager', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('393', 'accounts_edit_data', 'Accounts Edit Data', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('394', 'print_barcode', 'Print Barcode', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('395', 'print_qrcode', 'Print Qrcode', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('396', 'add_new_account', 'Add New Account', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('397', 'table_edit', 'Table Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('398', 'secret_key', 'Secret Key', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('399', 'site_key', 'Site Key', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('400', 'captcha', 'Captcha', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('401', 'please_add_walking_customer_for_default_customer', 'Please add walking customer for default customer. ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('402', 'barcode_qrcode_scan_here', 'Barcode Or QRcode scan here', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('403', 'manage_your_credit_customer', 'Manage your credit customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('404', 'unit', 'Unit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('405', 'total_discount', 'Total Discount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('406', 'meter_m', 'Meter (M)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('407', 'piece_pc', 'Piece (Pc)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('408', 'kilogram_kg', 'Kilogram (Kg)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('409', 'import_product_csv', 'Import Medicine (CSV)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('410', 'close', 'Close', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('411', 'csv_file_informaion', 'File Information (CSV)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('412', 'download_example_file', 'Download Example File', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('413', 'upload_csv_file', 'Upload CSV File', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('414', 'manufacturer_id', 'Manufacturer ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('415', 'category_id', 'Category ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('416', 'are_you_sure_to_delete', 'Are you sure,want to delete ?', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('417', 'stock_report_manufacturer_wise', 'Stock Report (Manufacturer Wise)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('418', 'stock_report_product_wise', 'Stock Report (Medicine Wise)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('419', 'select_manufacturer', 'Select Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('420', 'select_product', 'Select Medicine ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('421', 'phone', 'Phone', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('422', 'in_quantity', 'In Quantity', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('423', 'out_quantity', 'Sold QTY', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('424', 'in_taka', 'In Taka', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('425', 'out_taka', 'Out Taka', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('426', 'data_synchronizer', 'Data Synchronizer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('427', 'synchronize', 'Synchronize', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('428', 'backup_restore', 'Backup And Restore', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('429', 'synchronizer_setting', 'Synchronizer Setting', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('430', 'backup_and_restore', 'Backup And Restore', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('431', 'hostname', 'Host Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('432', 'username', 'User Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('433', 'ftp_port', 'FTP Port', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('434', 'ftp_debug', 'FTP Debug', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('435', 'project_root', 'Project Root', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('436', 'internet_connection', 'Internet connection', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('437', 'ok', 'Ok', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('438', 'not_available', 'Not available', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('439', 'outgoing_file', 'Outgoing File', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('440', 'available', 'Available', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('441', 'incoming_file', 'Incoming file', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('442', 'data_upload_to_server', 'Data upload to server', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('443', 'download_data_from_server', 'Download data from server', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('444', 'data_import_to_database', 'Data import to database', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('445', 'please_wait', 'Please Wait', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('446', 'ooops_something_went_wrong', 'Ooops something went wrong', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('447', 'file_information', 'File Information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('448', 'size', 'Size', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('449', 'backup_date', 'Backup date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('450', 'backup_now', 'Backup Now', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('451', 'are_you_sure', 'Are you sure ?', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('452', 'download', 'Downlaod', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('453', 'database_backup', 'Database Backup', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('454', 'backup_successfully', 'Backup Successfully', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('455', 'please_try_again', 'Please Try Again', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('456', 'restore_successfully', 'Restore successfully', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('457', 'download_successfully', 'Download Successfully', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('458', 'delete_successfully', 'Delete Successfully', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('459', 'ftp_setting', 'FTP Setting', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('460', 'save_successfully', 'Save successfully', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('461', 'upload_successfully', 'Upload successfully.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('462', 'unable_to_upload_file_please_check_configuration', 'unable to upload file please check configuration.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('463', 'please_configure_synchronizer_settings', 'Please Configure Synchronizer Settings ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('464', 'unable_to_download_file_please_check_configuration', 'Unable To Download File,Please Check Configuration.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('465', 'data_import_first', 'Data Import First', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('466', 'data_import_successfully', 'Data Import Successfully', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('467', 'unable_to_import_data_please_check_config_or_sql_file', 'Unable to import data please check config or sql file.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('468', 'restore_now', 'Restore Now', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('469', 'out_of_stock', 'Out Of Stock', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('470', 'others', 'Others', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('471', 'shelf', 'Shelf', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('472', 'discount_type', 'Discount Type ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('473', 'discount_percentage', 'Discount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('474', 'fixed_dis', 'Fixed Dis', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('475', 'full_paid', 'Full Paid', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('476', 'available_qnty', 'Ava.Qty', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('477', 'stock_ctn', 'Stock/Qnt', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('478', 'sale_price', 'Sale Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('479', 'manufacturer_rate', 'Manufacturer  Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('480', 'please_upload_image_type', 'Sorry!!! Please Upload jpg,jpeg,png,gif typeimage', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('481', 'ml', 'Milli liter(ml)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('482', 'mg', 'Milli Gram(mg)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('483', 'you_can_not_buy_greater_than_available_qnty', 'You can not sale more than available quantity ! please purchase this Product', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('484', 'due_amount', 'Due Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('485', 'return_invoice', 'Return Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('486', 'sold_qty', 'Sold Qty', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('487', 'ret_quantity', 'Return QTY', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('488', 'deduction', 'Deduction', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('489', 'return', 'Return', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('490', 'note', 'Return Reasone', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('491', 'usablilties', 'Return Usability', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('492', 'adjs_with_stck', 'Adjust With Stock', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('493', 'return_to_manufacturer', 'Return To Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('494', 'wastage', 'Wastage', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('495', 'to_deduction', 'Total Deduction', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('496', 'nt_return', 'Net Return', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('497', 'return_id', 'Return Id', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('498', 'return_details', 'Return Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('499', 'add_return', 'Add Return', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('500', 'return_list', 'Return List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('501', 'stock_return_list', 'Stock Return List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('502', 'wastage_return_list', 'Wastage Return List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('503', 'check_return', 'Check Return', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('504', 'quantity_must_be_fillup', 'Return Quantity Must be Fill Up', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('505', 'expeire_date', 'Expiry  date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('506', 'batch_id', 'Batch ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('507', 'manufacturer_return_list', 'Manufacturer  Return List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('508', 'c_r_slist', 'Customer Return List ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('509', 'manufacturer_return', 'Manufacturer  Return List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('510', 'wastage_list', 'Wastage List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('511', 'in_qnty', 'In Quantity', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('512', 'out_qnty', 'Sold QTY', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('513', 'stock_sale', 'Stock Sell Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('514', 'add_product_csv', 'Import Medicine (CSV)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('515', 'purchase_id', 'Purchase ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('516', 'add_payment', 'Add Payment', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('517', 'add_new_payment', 'Add new Payment', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('518', 'transaction', 'Transaction', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('519', 'manage_transaction', 'Manage Transaction', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('520', 'choose_transaction', 'Choose Transaction', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('521', 'receipt', 'Receipt', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('522', 'payment', 'Payment', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('523', 'transaction_categry', 'Transaction Category', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('524', 'transaction_mood', 'Transaction Mood', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('525', 'payment_amount', 'Payment Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('526', 'receipt_amount', 'Receipt Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('527', 'daily_summary', 'Daily Summary', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('528', 'daily_cash_flow', 'Daily  Cashflow', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('529', 'custom_report', 'Custom Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('530', 'root_account', 'Root Account', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('531', 'office', 'Office', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('532', 'loan', 'Loan', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('533', 'successfully_saved', 'Successfully Saved', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('534', 'bank', 'Bank', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('535', 'bank_transaction', 'Bank Transaction', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('536', 'office_loan', 'Office Loan', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('537', 'add_person', 'Add Person', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('538', 'manage_loan', 'Manage Person', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('539', 'add_loan', 'Add Loan', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('540', 'ac_name', 'Account Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('541', 'ac_no', 'Account No', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('542', 'branch', 'Branch', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('543', 'signature_pic', 'Signature ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('544', 'withdraw_deposite_id', 'Withdraw Deposit ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('545', 'select_report', 'Select Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('546', 'per_qty', 'Purchase Qty', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('547', 'stock_report_batch_wise', 'Stock Report(Batch Wise)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('548', 'box', 'Box', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('549', 'gram', 'Gram', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('550', 'profit_report_manufacturer_wise', 'Profit/Loss Report(Manufacturer)', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('551', 'calculate', 'Calculate', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('552', 'profit_report_product_wise', 'Profit/Loss  Report Product Wise', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('553', 'view_report', 'View Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('554', 'report_for', 'Report For', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('555', 'total_sale_qty', 'Total Sale QTY', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('556', 'total_purchase_pric', 'Total purchase Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('557', 'total_sale', 'Total Sale', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('558', 'net_profit', 'Net Profit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('559', 'loss', 'Loss', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('560', 'product_type', 'Medicine Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('561', 'add_type', 'Add Medicine Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('562', 'add_new_type', 'Add New Medicine  Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('563', 'type', 'Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('564', 'type_name', 'Type Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('565', 'manage_type', 'Manage Medicine Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('566', 'type_id', 'Type Id', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('567', 'type_edit', 'Edit Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('568', 'profitloss', 'profit/Loss', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('569', 'manufacturer_wise', 'Manufacturer Wise', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('570', 'product_wise', 'Medicine Wise', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('571', 'medicine_info', 'Medicine Information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('572', 'choose_another_invno', 'Choose Another Invoice No !!', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('573', 'return_manufacturers', 'Return Manufacturers', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('574', 'return_manufacturer', 'Return Manufacturers', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('575', 'please_input_correct_invoice_no', 'Please Input Correct Invoice No', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('576', 'stock_purchase_price', 'Stock Purchase Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('577', 'manufacturer_returns', 'Manufacturer  Return ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('578', 'invoice_discount', 'Invoice Discount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('579', 'qty', 'Qty', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('580', 'discounts', 'Discount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('581', 'sub_total', 'Sub Total', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('582', 'paid', 'Paid', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('583', 'change', 'Change', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('584', 'purchase_price', 'Purchase Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('585', 'expiry', 'Expiry', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('586', 'batch', 'Batch', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('587', 'role_permission', 'Role Permission', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('588', 'user_assign_role', 'Assign  User Role', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('589', 'permission', 'Permission', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('590', 'personal_loan', 'Personal Loan', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('591', 'role_name', 'Role Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('592', 'create', 'Create', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('593', 'read', 'Read', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('594', 'add_role', 'Add Role', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('595', 'You do not have permission to access. Please contact with administrator.', 'You do not have permission to access. Please contact with administrator.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('596', 'role_permission_added_successfully', 'Role Permission Added successfully.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('597', 'role_list', 'Role List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('598', 'role_permission_updated_successfully', 'Role Permission Updated Successfully.', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('599', 'add_phrase', 'Add Phrase', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('600', 'language_home', 'Language Home', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('601', 'phrase_edit', 'Phrase Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('602', 'no_role_selected', 'No Role Selected', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('603', 'category_added_successfully', 'Category added successfully', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('604', 'category_already_exist', 'Category already exist', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('605', 'select_manufacturer', 'Select Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('607', 'select_tax', 'Select Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('608', 'must_input_numbers', 'Must input numbers', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('609', 'please_check_your_price', 'Please Check Your Price', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('610', 'your_profit_is', 'Your Profit is', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('611', 'failed', 'Failed', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('612', 'you_have_reached_the_limit_of_adding', 'You have reached the limit of adding', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('613', 'inputs', 'inputs', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('614', 'expiry_date_should_be_greater_than_puchase_date', 'Expiry Date should be greater than Puchase Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('615', 'expiry_date_should_be_greater_than_puchase_date', 'Expiry Date should be greater than Puchase Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('616', 'product_name', 'Medicine Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('617', 'total_quantity', 'Total Quantity', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('618', 'rates', 'Rate', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('619', 'total_amount', 'Total Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('621', 'receipt_detail', 'Receipt Detail', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('622', 'amount', 'Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('623', 'save_and_add_another_one', 'Save and add another one', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('624', 'checque_number', 'Checque Number', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('625', 'edit_receipt', 'Edit Receipt', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('626', 'receipt_list', 'Receipt List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('627', 'search_by_customer_name', 'Search By Customer Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('628', 'actions', 'Actions', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('629', 'no_data_found', 'No Data Found', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('630', 'edit', 'Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('631', 'product_not_found', 'Medicine  not found', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('632', 'request_failed_please_check_your_code_and_try_again', 'Request Failed, Please check your code and try again', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('633', 'You_can_not_return_more_than_sold_quantity', 'You Can Not Return More than Sold quantity', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('634', 'you_can_not_return_less_than_1', 'You Can Not Return Less than 1', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('635', 'transection_details', 'Transection Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('636', 'transection_details_datewise', 'Transection  Details Datewise', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('637', 'transection_id', 'Transactions ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('638', 'select_option', 'Select Option', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('639', 'loan_list', 'Loan List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('640', 'todays_details', 'Todays Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('641', 'transaction_details', 'Transaction Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('642', 'person_id', 'Person ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('643', 'total_transection', 'Total Transection', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('644', 'transaction_id', 'Transaction ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('645', 'transection_report', 'Transection Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('646', 'add_transection', 'Add Transection', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('647', 'manage_transection', 'Manage Transection', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('648', 'select_id', 'Select ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('649', 'choose_transection', 'Choose Transection', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('650', 'update_transection', 'Update Transection', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('651', 'manufacturer_all', 'Manufacturer All', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('652', 'select_all', 'Select All', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('653', 'all', 'All', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('654', 'max_rate', 'Max Rate', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('655', 'min_rate', 'Min Rate', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('656', 'average_rate', 'Average Rate', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('657', 'date_expired_please_choose_another.', 'Date Expired!! Please Choose another', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('658', 'your_medicine_is_date_expiry_Please_choose_another', 'Your Medicine is Date Expiry !! Please Choose another', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('659', 'meno', 'MEMO', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('660', 'out_of_stock_and_date_expired_medicine', 'Out of Stock and Date Expired Medicine', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('661', 'edit_profile', 'Edit Profile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('662', 'deposit_detail', 'Deposit detail', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('663', 'new_deposit', 'New Deposit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('664', 'edit_deposit', 'Edit Deposit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('665', 'select_customer', 'Select Customer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('666', 'draw', 'Draw', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('667', 'deposit', 'Deposit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('668', 'select_type', 'Select Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('669', 'transaction_type', 'Transaction Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('670', 'cash', 'Cash', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('671', 'select_bank', 'Select Bank', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('672', 'drawing', 'Drawing', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('673', 'expenses', 'Expenses', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('674', 'banking', 'Banking', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('675', 'daily_closing', 'Daily Closing', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('676', 'title', 'Title', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('677', 'error_get_data_from_ajax', 'Error get data from ajax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('678', 'toggle_navigation', 'Toggle Navigation', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('679', 'this_product_not_found', 'This Medicine  Not Found !', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('680', 'search_by_date_from', 'Search By Date: From', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('681', 'manufacturer_sales_report', 'Manufacturer Sales Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('682', 'transection', 'Transection', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('683', 'transection_mood', 'Transection Mood', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('684', 'transection_categry', 'Transection Categry', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('685', 'export_csv', 'Export CSV', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('686', 'select manufacturer', 'Select Manufacturer', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('687', 'customer_return', 'Customer Return', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('688', 'return_form', 'Return Form', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('689', 'data_not_found', 'Data Not Found', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('690', 'export_csv', 'Export CSV', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('691', 'manage_person', 'Manage Person', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('692', 'backup', 'Back Up', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('693', 'total_balance', 'Total Balance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('694', 'product_id_model_manufacturer_id_can_not_null', 'Medicine Id & Medicine Type & Manufacturer Id Can not be Blank', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('695', 'product_name_can_not_be_null', 'Medicine  Name can Not be Blank', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('696', 'product_model_can_not_be_null', 'Medicine  Model Can Not be Blank', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('697', 'sms', 'SMS', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('698', 'sms_configure', 'Sms Configuration', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('699', 'url', 'Url', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('700', 'sender_id', 'Sender ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('701', 'api_key', 'Api Key', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('702', 'barcode_or_qrcode', 'Barcode Or QRcode ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('703', 'currency_name', 'Currency Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('704', 'add_currency', 'Add Currency', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('705', 'currency_icon', 'Currency Icon', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('706', 'currency_list', 'Currency List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('707', 'import', 'Import', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('708', 'c_o_a', 'Chart Of Account', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('709', 'supplier_payment', 'Supplier Payment', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('710', 'customer_receive', 'Customer Receive', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('711', 'debit_voucher', 'Debit Voucher', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('712', 'credit_voucher', 'Credit voucher', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('713', 'voucher_approval', 'Voucher Approval', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('714', 'contra_voucher', 'Contra Voucher', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('715', 'journal_voucher', 'Journal Voucher', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('716', 'voucher_report', 'Voucher Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('717', 'cash_book', 'Cash Book', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('718', 'inventory_ledger', 'Inventory Ledger', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('719', 'bank_book', 'Bank Book', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('720', 'general_ledger', 'General Ledger', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('721', 'trial_balance', 'Trial Balance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('722', 'profit_loss_report', 'Profit Loss Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('723', 'cash_flow', 'Cash Flow', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('724', 'coa_print', 'COA Print', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('725', 'manufacturer_payment', 'Manufacturer Payment', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('726', 'add_more', 'Add More', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('727', 'code', 'Code', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('728', 'remark', 'Transaction Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('729', 'voucher_no', 'Voucher NO', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('730', 'accounts_tree_view', 'Accounts Tree view', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('731', 'find', 'Find', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('732', 'voucher_type', 'Voucher Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('733', 'particulars', 'Particulars', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('734', 'cash_flow_statement', 'Cash Flow Statement', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('735', 'amount_in_dollar', 'Amount In Dollar', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('736', 'opening_cash_and_equivalent', 'Opening Cash and Equivalent', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('737', 'with_details', 'With Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('738', 'transaction_head', 'Transaction Head', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('739', 'gl_head', 'General Ledger Head', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('740', 'no_report', 'No Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('741', 'pre_balance', 'Pre Balance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('742', 'current_balance', 'Current Balance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('743', 'from_date', 'From Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('744', 'to_date', 'To Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('745', 'profit_loss', 'Profit Loss Statement', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('746', 'add_expense_item', 'Add Expense Item', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('747', 'manage_expense_item', 'Manage Expense Item', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('748', 'add_expense', 'Add Expense', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('749', 'manage_expense', 'Manage Expense', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('750', 'expense_statement', 'Expense Statement', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('751', 'expense_type', 'Expense Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('752', 'expense_item_name', 'Expense Item Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('753', 'opening_balance', 'Opening Balance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('754', 'tax_settings', 'Tax Settings', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('755', 'add_incometax', 'Add Income Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('756', 'manage_income_tax', 'Manage Income tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('757', 'tax_report', 'Tax Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('758', 'invoice_wise_tax_report', 'Invoice Wise Tax Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('759', 'number_of_tax', 'Number of Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('760', 'default_value', 'Default Value', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('761', 'reg_no', 'Registration No', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('762', 'tax_name', 'Tax Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('763', 'service_id', 'Service Id', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('764', 'service', 'Service', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('765', 'add_service', 'Add Service', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('766', 'manage_service', 'Manage Service', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('767', 'service_invoice', 'Service Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('768', 'manage_service_invoice', 'Manage Service Invoice', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('769', 'service_name', 'Service Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('770', 'charge', 'Charge', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('771', 'add', 'Add', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('772', 'previous', 'Previous', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('773', 'net_total', 'Net Total', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('774', 'hanging_over', 'Estimated Time Of Departure', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('775', 'service_discount', 'Service Discount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('776', 'hrm', 'HRM', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('777', 'add_designation', 'Add Designation', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('778', 'manage_designation', 'Manage Designation', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('779', 'add_employee', 'Add Employee', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('780', 'manage_employee', 'Manage Employee', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('781', 'attendance', 'Attendance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('782', 'add_attendance', 'Add Attendance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('783', 'manage_attendance', 'Manage Attendance', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('784', 'attendance_report', 'Attendance Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('785', 'payroll', 'Payroll', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('786', 'add_benefits', 'Add Benefits', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('787', 'manage_benefits', 'Manage Benefits', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('788', 'add_salary_setup', 'Add Salary Setup', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('789', 'manage_salary_setup', 'Manage Salary Setup', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('790', 'salary_generate', 'Salary Generate', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('791', 'manage_salary_generate', 'Manage Salary Generate', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('792', 'salary_payment', 'Salary Payment', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('793', 'designation', 'Designation', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('794', 'rate_type', 'Rate Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('795', 'hour_rate_or_salary', 'Hourly Rate/Salary', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('796', 'blood_group', 'Blood Group', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('797', 'address_line_1', 'Address Line 1', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('798', 'address_line_2', 'Address Line 2', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('799', 'picture', 'Picture', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('800', 'country', 'Country', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('801', 'city', 'City', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('802', 'zip', 'Zip code', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('803', 'single_checkin', 'Single Check In', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('804', 'bulk_checkin', 'Bulk Check In', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('805', 'checkin', 'Check In', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('806', 'employee_name', 'Employee Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('807', 'check_in', 'Check In', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('808', 'checkout', 'Check Out', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('809', 'confirm_clock', 'Confirm Clock', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('810', 'stay', 'Stay', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('811', 'download_sample_file', 'Download Sample File', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('812', 'employee', 'Employee', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('813', 'sign_in', 'Check In', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('814', 'sign_out', 'Check  Out', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('815', 'staytime', 'Stay Time', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('816', 'benefits_list', 'Benefit List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('817', 'benefits', 'Benefits', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('818', 'benefit_type', 'Benefit Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('819', 'salary_benefits', 'Salary Benefits', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('820', 'salary_benefits_type', 'Salary Benefits Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('821', 'hourly', 'Hourly', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('822', 'salary', 'Salary', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('823', 'timezone', 'Time Zone', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('824', 'request', 'Request', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('825', 'datewise_report', 'Date Wise Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('826', 'work_hour', 'Work Hours', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('827', 'employee_wise_report', 'Employee Wise Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('828', 'date_in_time_report', 'In Time Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('829', 'successfully_checkout', 'Successfully Checked Out', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('830', 'setup_tax', 'Setup Tax', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('831', 'start_amount', 'Start Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('832', 'end_amount', 'End Amount', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('833', 'tax_rate', 'Tax Rate', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('834', 'setup', 'Setup', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('835', 'income_tax_updateform', 'Income Tax Update Form', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('836', 'salary_type', 'Salary Type', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('837', 'addition', 'Addition', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('838', 'gross_salary', 'Gross Salary', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('839', 'set', 'Set', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('840', 'salary_month', 'Salary Month', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('841', 'generate', 'Generate ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('842', 'total_salary', 'Total Salary', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('843', 'total_working_minutes', 'Total Working Hours', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('844', 'working_period', 'Total Working Days', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('845', 'paid_by', 'Paid By', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('846', 'pay_now', 'Pay Now ?', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('847', 'confirm', 'Confirm', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('848', 'generate_by', 'Generate By', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('849', 'gui_pos', 'GUI POS', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('850', 'add_fixed_assets', 'Add Fixed Assets', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('851', 'fixed_assets_list', 'Fixed Asset List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('852', 'fixed_assets_purchase', 'Purchase Fixed Assets', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('853', 'fixed_assets_purchase_manage', 'Fixed Assets Purchase List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('854', 'fixed_assets', 'Fixed Assets', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('855', 'item_code', 'Item code', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('856', 'item_name', 'Item Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('857', 'opening_assets', 'Assets Qty', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('858', 'edit_fixed_asset', 'Edit Fixed Assets', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('859', 'save_change', 'Save Change', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('860', 'in_word', 'In Word', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('861', 'purchase_pad_print', 'Purchase Pad Print', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('862', 'fixed_assets_purchase_details', 'Fixed Assets Purchase Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('863', 'manage_language', 'Manage Language', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('864', 'person_edit', 'Person Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('865', 'person_ledger', 'Person Ledger', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('866', 'medicine_name', 'Medicine Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('867', 'unit_list', 'Unit List', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('868', 'add_unit', 'Add Unit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('869', 'edit_unit', 'Edit Unit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('870', 'unit_name', 'Unit Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('871', 'unit_not_selected', 'Unit did not Selected', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('872', 'supplier', 'Supplier', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('873', 'add_supplier', 'Add Supplier', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('874', 'manage_supplier', 'Manage Supplier', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('875', 'supplier_ledger', 'Supplier Ledger', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('876', 'supplier_sales_details', 'Supplier Sales Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('877', 'purchase_detail', 'Purchase details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('878', 'purchase_information', 'Purchase Information', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('879', 'account_head', 'Account Head', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('880', 'transaction_date', 'Transaction Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('881', 'approved', 'Approve', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('882', 'date_wise_report', 'Date Wise Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('883', 'time_wise_report', 'Time Wise Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('884', 'report_date', 'Report Date', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('885', 's_time', 'Start Time', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('886', 'e_time', 'End Time', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('887', 'basic', 'Basic', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('888', 'supplier_name', 'Supplier Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('889', 'supplier_mobile', 'Supplier Mobile', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('890', 'supplier_address', 'Supplier Address', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('891', 'supplier_details', 'Supplier Details', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('892', 'select_supplier', 'Select Supplier', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('893', 'accounts_report', 'Accounts Report', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('894', 'account_code', 'Account Code', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('895', 'human_resource_management', 'Human Resource ', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('896', 'menu_name', 'Menu Name', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('897', 'head_of_account', 'Account Head', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('898', 'successfully_approved', 'Successfully Approved', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('899', 'supplier_edit', 'Supplier Edit', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('900', 'supplier_id', 'Supplier ID', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('901', 'strength', 'Strength', NULL);
INSERT INTO `language` (`id`, `phrase`, `english`, `bangla`) VALUES ('902', 'out_of_date', 'Out Of Date', NULL);


#
# TABLE STRUCTURE FOR: manufacturer_information
#

DROP TABLE IF EXISTS `manufacturer_information`;

CREATE TABLE `manufacturer_information` (
  `manufacturer_id` int(11) NOT NULL AUTO_INCREMENT,
  `manufacturer_name` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `mobile` varchar(100) NOT NULL,
  `details` varchar(255) NOT NULL,
  `status` int(2) NOT NULL,
  PRIMARY KEY (`manufacturer_id`)
) ENGINE=MyISAM AUTO_INCREMENT=206 DEFAULT CHARSET=utf8;

INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('2', 'Name of the Manufacturer', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('3', 'ACI HealthCare Limited', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('4', 'Acmunio International Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('5', 'Active Fine Chemicals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('6', 'Ad-din Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('7', 'Advanced Chemical Industries Limited', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('8', 'Advent Pharma Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('9', 'Al-Madina Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('10', 'Albion Laboratories Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('11', 'Alco Pharma Limited', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('12', 'Alkad Laboratories', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('13', 'Allied Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('14', 'Ambee Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('15', 'Amico Laboratories Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('16', 'Amulet Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('17', 'APC Pharma Limited', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('18', 'Apex Pharma Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('19', 'Apollo Pharmaceutical Laboratories Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('20', 'Aristopharma Limited', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('21', 'Aristopharma Limited, Gazipur', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('22', 'Asiatic Laboratories Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('23', 'Astra Biopharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('24', 'Aztec Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('25', 'Bangladesh Antibiotic Industries Limited', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('26', 'Beacon Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('27', 'Belsen Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('28', 'Bengal Drugs & Chemical Works Pharm. Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('29', 'Bengal Remedies Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('30', 'Benham Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('31', 'Beximco Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('32', 'Beximco Pharmaceuticals Ltd., Kaliakoir', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('33', 'Biogen Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('34', 'Biopharma Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('35', 'Bios Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('36', 'Bridge Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('37', 'Bristol Pharma Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('38', 'Centeon Pharma Limited', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('39', 'Central Pharmaceutical Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('40', 'Chemist Laboratories Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('41', 'Cipla Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('42', 'Concord Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('43', 'Cosmic Pharma Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('44', 'Cosmo Pharma Laboratories Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('45', 'Decent Pharma Laboratories Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('46', 'Delta Chemicals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('47', 'Delta Pharma Limited', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('48', 'Desh Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('49', 'Doctor Tims Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('50', 'Doctor\'s Chemicals Works Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('51', 'Drug International Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('52', 'Drug International Ltd. Unit-2', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('53', 'EDCL (Bogra)', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('54', 'EDCL (Dhaka)', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('55', 'Edruc Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('56', 'EMCS Pharma Limited', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('57', 'Eon Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('58', 'Eskayef Pharmaceuticals Ltd. Mirpur.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('59', 'Eskayef Pharmaceuticals Ltd., Narayanganj', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('60', 'Eskayef Pharmaceuticals Ltd., Tongi,Gazipur', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('61', 'Ethical Drug Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('62', 'Euro Pharma Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('63', 'Everest Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('64', 'FnF Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('65', 'G. A. Company Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('66', 'General Pharmaceuticals Ltd, Unit-2', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('67', 'General Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('68', 'Gentry Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('69', 'Genvio Pharma Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('70', 'Get Well Limited', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('71', 'Global Capsules Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('72', 'Global Capsules Ltd., Gelatin Division', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('73', 'Global Heavy Chemicals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('74', 'Globe Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('75', 'Globex Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('76', 'Gonoshasthaya Antibiotic Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('77', 'Gonoshasthaya Basic Chemical Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('78', 'Gonoshasthaya Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('79', 'Goodman Pharmaceuticals Ltd', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('80', 'Greenland Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('81', 'Guardian Healthcare Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('82', 'Hallmark Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('83', 'Healthcare Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('84', 'Hope Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('85', 'Hudson Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('86', 'Ibn Sina Pharmaceutical Ind. Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('87', 'Incepta Chemicals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('88', 'Incepta Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('89', 'Incepta Pharmaceuticals Ltd. (Dhamrai Unit)', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('90', 'Incepta Vaccine Limited', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('91', 'Indo-Bangla Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('92', 'Institute of Public Health', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('93', 'Islam Oxygen (Pvt) Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('94', 'Jalalabad Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('95', 'Jayson Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('96', 'JMI Industrial Gas Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('97', 'JMI Syringes & Medical Devices Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('98', 'Julphar Bangladesh Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('99', 'Kemiko Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('100', 'Kumudini Pharma Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('101', 'Labaid Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('102', 'Leon Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('103', 'Libra Pharmaceuticls Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('104', 'Linde Bangladesh Limited', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('105', 'Maks Drugs Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('106', 'Marker Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('107', 'Marksman Pharmaceutical Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('108', 'Medicon Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('109', 'Medimet Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('110', 'MedRx Life Science Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('111', 'Millat Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('112', 'Modern Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('113', 'Momotaz Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('114', 'Monicopharma Limited', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('115', 'Monomedi Bangladesh Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('116', 'MSF Pharmaceuticals Ltd.,', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('117', 'MST Pharma and Healthcare Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('118', 'Mundipharma (Bangladesh) Pvt. Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('119', 'Naafco Pharma Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('120', 'National Laboratories Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('121', 'Navana Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('122', 'Newtec Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('123', 'Nip Chemicals And Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('124', 'Nipa Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('125', 'NIPRO JMI Company Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('126', 'NIPRO JMI Pharma Limited', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('127', 'Novartis  (Bangladesh) Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('128', 'Novelta Bestway Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('129', 'Novo Healthcare and Pharma Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('130', 'Novo Healthcare and Pharma Ltd. (Unit-2)', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('131', 'Novus Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('132', 'Nuvista Pharma Ltd', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('133', 'One Pharma Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('134', 'Opso Saline Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('135', 'Opsonin Bulk Drugs Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('136', 'Opsonin Pharma Limited', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('137', 'Orbit Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('138', 'Organic Health Care', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('139', 'Orion Infusion Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('140', 'Orion Pharma Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('141', 'Oyster Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('142', 'Pacific Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('143', 'Peoples Pharma Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('144', 'Pharmacil Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('145', 'Pharmadesh Laboratories Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('146', 'Pharmasia Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('147', 'Pharmatek Chemicals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('148', 'Pharmik Laboratories Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('149', 'Phoenix Chemicals Laboratory (BD) Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('150', 'Popular Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('151', 'Premier Pharmaceuticals', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('152', 'Prime Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('153', 'Quality Pharmaceuticals (Pvt) Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('154', 'Radiant Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('155', 'Rahman Chemicals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('156', 'Rampart-Power Bangladesh Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('157', 'Rangs Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('158', 'Reckitt Benckiser Bangladesh Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('159', 'Reliance Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('160', 'Reman Drug Laboratories Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('161', 'Remo Chemical Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('162', 'Renata Limited', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('163', 'Renata Limited, Gazipur', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('164', 'Renata Oncology Limited', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('165', 'Rephco Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('166', 'RN Pharmaceuticals', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('167', 'S. N. Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('168', 'Salton Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('169', 'Sanofi Bangladesh Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('170', 'Save Pharmaceutical', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('171', 'Seba Laboratories Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('172', 'Seema Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('173', 'Sharif Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('174', 'Silco Pharmaceuticlas Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('175', 'Silva Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('176', 'SMC Enterprise Limited', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('177', 'Sodical Chemical Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('178', 'Somatec Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('179', 'Spectra Oxygen Limited', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('180', 'Square Cephalosporins Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('181', 'Square Formulations Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('182', 'Square Pharmaceuticals Ltd. (Chemical Division)', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('183', 'Square Pharmaceuticals Ltd. Gazipur', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('184', 'Square Pharmaceuticals Ltd. Pabna', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('185', 'Standard Laboratories Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('186', 'Sun Pharmaceutical (Bangladesh) Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('187', 'Sunman-Birdem Pharma Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('188', 'Super Power Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('189', 'Supreme Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('190', 'Team Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('191', 'Techno Drugs (Unit-3)', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('192', 'Techno Drugs Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('193', 'Techno Drugs Ltd., Unit-2', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('194', 'The ACME Laboratories Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('195', 'The White Horse Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('196', 'Unimed Unihealth Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('197', 'Union Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('198', 'Unique Pharmaceutical Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('199', 'United Chemicals & Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('200', 'Veritas Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('201', 'Virgo Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('202', 'World Chemical Industry Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('203', 'Zenith Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('204', 'Ziska Pharmaceuticals Ltd.', '', '', '', '1');
INSERT INTO `manufacturer_information` (`manufacturer_id`, `manufacturer_name`, `address`, `mobile`, `details`, `status`) VALUES ('205', 'test', '', '', '', '1');


#
# TABLE STRUCTURE FOR: manufacturer_ledger
#

DROP TABLE IF EXISTS `manufacturer_ledger`;

CREATE TABLE `manufacturer_ledger` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transaction_id` varchar(100) NOT NULL,
  `manufacturer_id` bigint(20) NOT NULL,
  `chalan_no` varchar(100) DEFAULT NULL,
  `deposit_no` varchar(50) DEFAULT NULL,
  `amount` decimal(12,2) NOT NULL DEFAULT '0.00',
  `description` varchar(255) NOT NULL,
  `payment_type` varchar(255) NOT NULL,
  `cheque_no` varchar(255) NOT NULL,
  `date` varchar(50) NOT NULL,
  `status` int(2) NOT NULL,
  `d_c` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `receipt_no` (`deposit_no`),
  KEY `receipt_no_2` (`deposit_no`),
  KEY `receipt_no_3` (`deposit_no`),
  KEY `receipt_no_4` (`deposit_no`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `manufacturer_ledger` (`id`, `transaction_id`, `manufacturer_id`, `chalan_no`, `deposit_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `d_c`) VALUES ('1', '20191104060422', '22', '12312', NULL, '50.00', 'Purchase From Manufacturer. sdfasd', '', '', '2019-11-04', '1', 'c');
INSERT INTO `manufacturer_ledger` (`id`, `transaction_id`, `manufacturer_id`, `chalan_no`, `deposit_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `d_c`) VALUES ('2', '20191104060422', '22', '12312', NULL, '50.00', 'Purchase From Manufacturer. sdfasd', '', '', '2019-11-04', '1', 'd');
INSERT INTO `manufacturer_ledger` (`id`, `transaction_id`, `manufacturer_id`, `chalan_no`, `deposit_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `d_c`) VALUES ('3', '20191105061824', '121', '234234', NULL, '309.00', 'Purchase From Manufacturer. sdfsd', '', '', '2019-11-05', '1', 'c');
INSERT INTO `manufacturer_ledger` (`id`, `transaction_id`, `manufacturer_id`, `chalan_no`, `deposit_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `d_c`) VALUES ('4', '20191105061824', '121', '234234', NULL, '309.00', 'Purchase From Manufacturer. sdfsd', '', '', '2019-11-05', '1', 'd');
INSERT INTO `manufacturer_ledger` (`id`, `transaction_id`, `manufacturer_id`, `chalan_no`, `deposit_no`, `amount`, `description`, `payment_type`, `cheque_no`, `date`, `status`, `d_c`) VALUES ('5', 'PM-1', '6', NULL, 'PM-1', '100.00', 'Paid From Accounts', '1', '', '2019-11-05', '1', 'd');


#
# TABLE STRUCTURE FOR: module
#

DROP TABLE IF EXISTS `module`;

CREATE TABLE `module` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `description` text,
  `image` varchar(255) NOT NULL,
  `directory` varchar(100) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

INSERT INTO `module` (`id`, `name`, `description`, `image`, `directory`, `status`) VALUES ('1', 'Invoice', '', '', 'invoice', '1');
INSERT INTO `module` (`id`, `name`, `description`, `image`, `directory`, `status`) VALUES ('2', 'Customer', '', '', 'customer', '1');
INSERT INTO `module` (`id`, `name`, `description`, `image`, `directory`, `status`) VALUES ('3', 'Medicine', '', '', 'medicine', '1');
INSERT INTO `module` (`id`, `name`, `description`, `image`, `directory`, `status`) VALUES ('4', 'Manufacturer', '', '', 'manufacturer', '1');
INSERT INTO `module` (`id`, `name`, `description`, `image`, `directory`, `status`) VALUES ('5', 'Purchase', '', '', 'purchase', '1');
INSERT INTO `module` (`id`, `name`, `description`, `image`, `directory`, `status`) VALUES ('6', 'Stock', '', '', 'stock', '1');
INSERT INTO `module` (`id`, `name`, `description`, `image`, `directory`, `status`) VALUES ('7', 'Return', '', '', 'return', '1');
INSERT INTO `module` (`id`, `name`, `description`, `image`, `directory`, `status`) VALUES ('8', 'Report', '', '', 'report', '1');
INSERT INTO `module` (`id`, `name`, `description`, `image`, `directory`, `status`) VALUES ('9', 'Accounts', '', '', 'accounts', '1');
INSERT INTO `module` (`id`, `name`, `description`, `image`, `directory`, `status`) VALUES ('10', 'Bank', '', '', 'bank', '1');
INSERT INTO `module` (`id`, `name`, `description`, `image`, `directory`, `status`) VALUES ('11', 'Tax', '', '', 'tax', '1');
INSERT INTO `module` (`id`, `name`, `description`, `image`, `directory`, `status`) VALUES ('12', 'Human Resource', '', '', 'human_resource_info', '1');
INSERT INTO `module` (`id`, `name`, `description`, `image`, `directory`, `status`) VALUES ('13', 'Supplier', '', '', 'supplier', '1');
INSERT INTO `module` (`id`, `name`, `description`, `image`, `directory`, `status`) VALUES ('14', 'Service', '', '', 'service', '1');
INSERT INTO `module` (`id`, `name`, `description`, `image`, `directory`, `status`) VALUES ('15', 'Search', '', '', 'search', '1');
INSERT INTO `module` (`id`, `name`, `description`, `image`, `directory`, `status`) VALUES ('16', 'Settings', '', '', 'settings', '1');


#
# TABLE STRUCTURE FOR: payment_method
#

DROP TABLE IF EXISTS `payment_method`;

CREATE TABLE `payment_method` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_type` varchar(250) DEFAULT NULL,
  `card_no` varchar(250) DEFAULT NULL,
  `bank_name` varchar(100) DEFAULT NULL,
  `price` float DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: payroll_tax_setup
#

DROP TABLE IF EXISTS `payroll_tax_setup`;

CREATE TABLE `payroll_tax_setup` (
  `tax_setup_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `start_amount` decimal(12,2) NOT NULL DEFAULT '0.00',
  `end_amount` decimal(12,2) NOT NULL DEFAULT '0.00',
  `rate` decimal(12,2) NOT NULL DEFAULT '0.00',
  `status` varchar(30) CHARACTER SET latin1 NOT NULL,
  PRIMARY KEY (`tax_setup_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: person_information
#

DROP TABLE IF EXISTS `person_information`;

CREATE TABLE `person_information` (
  `person_id` varchar(50) NOT NULL,
  `person_name` varchar(50) NOT NULL,
  `person_phone` varchar(50) NOT NULL,
  `person_address` text NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`person_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: person_ledger
#

DROP TABLE IF EXISTS `person_ledger`;

CREATE TABLE `person_ledger` (
  `transaction_id` varchar(50) NOT NULL,
  `person_id` varchar(50) NOT NULL,
  `date` varchar(50) NOT NULL,
  `debit` decimal(12,2) NOT NULL DEFAULT '0.00',
  `credit` decimal(10,2) NOT NULL DEFAULT '0.00',
  `details` text NOT NULL,
  `status` int(11) NOT NULL COMMENT '1=no paid,2=paid',
  `id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: personal_loan
#

DROP TABLE IF EXISTS `personal_loan`;

CREATE TABLE `personal_loan` (
  `per_loan_id` int(11) NOT NULL AUTO_INCREMENT,
  `transaction_id` varchar(30) NOT NULL,
  `person_id` varchar(30) NOT NULL,
  `debit` varchar(20) NOT NULL,
  `credit` float NOT NULL,
  `date` varchar(30) NOT NULL,
  `details` varchar(100) NOT NULL,
  `status` int(11) NOT NULL COMMENT '1=no paid,2=paid',
  PRIMARY KEY (`per_loan_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: pesonal_loan_information
#

DROP TABLE IF EXISTS `pesonal_loan_information`;

CREATE TABLE `pesonal_loan_information` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` varchar(50) NOT NULL,
  `person_name` varchar(50) NOT NULL,
  `person_phone` varchar(30) NOT NULL,
  `person_address` text NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: product_category
#

DROP TABLE IF EXISTS `product_category`;

CREATE TABLE `product_category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `category_name` varchar(255) DEFAULT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=129 DEFAULT CHARSET=utf8;

INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('2', 'category', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('3', 'Tablet', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('4', 'Capsule', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('5', 'Syringe', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('6', 'Powder For Suspension', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('7', 'Suspension', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('8', 'Syrup', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('9', 'Paediatric Drops', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('10', 'Oral Saline', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('11', 'Ointment', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('12', 'Lotion', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('13', 'Cream', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('14', 'Gel', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('15', 'Suppository', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('16', 'Eye Drops', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('17', 'Injection', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('18', 'Dispersible Tablet', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('19', 'Pellets', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('20', 'IV Infusion', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('21', 'Oral Paste', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('22', 'Powder', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('23', 'Ors Tablet', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('24', 'IV/IM Injection', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('25', 'Inhalation Solution', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('26', 'Aerosol Inhalation', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('27', 'Nasal Spray', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('28', 'Eye, Ear & Nasal Drops', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('29', 'Bolus', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('30', 'Water Soluble Powder', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('31', 'Cozycap', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('32', 'Inhalation Aerosol', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('33', 'Oral Drops', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('34', 'Cr Tablet', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('35', 'IM Injection', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('36', 'IV Injection', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('37', 'Orodispersible Tablet', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('38', 'Solution', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('39', 'Eye and Ear Drops', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('40', 'Topical Solution', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('41', 'Hand Rub', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('42', 'Gargle & Mouth Wash', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('43', 'Sr Tablet', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('44', 'Scalp Lotion', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('45', 'Vaginal Tablet', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('46', 'Eye Ointment', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('47', 'Raw Materials', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('48', 'Oral Solution', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('49', 'Dr Tablet', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('50', 'Mouth Wash', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('51', 'Inhalation Capsule', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('52', 'Granules For Suspension', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('53', 'Oral Powder', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('54', 'Spray', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('55', 'Chewable Tablet', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('56', 'Xr Tablet', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('57', 'Oral Gel', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('58', 'Er Tablet', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('59', 'Nasal Drops', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('60', 'Inhaler', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('61', 'Nebuliser Solution', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('62', 'Sr Capsule', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('63', 'Liquid', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('64', 'Pellets For Suspension', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('65', 'Linctus', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('66', 'Sachet', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('67', 'Elixir', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('68', 'Emulsion', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('69', 'Sached Powder', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('70', 'Ear Drop', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('71', 'Ophthalmic Emulsion', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('72', 'Eye Gel', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('73', 'Solution For Injection', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('74', 'Shampoo', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('75', 'Eye & Nasal Drops', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('76', 'Odt Tablet', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('77', 'Solution For Infusion', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('78', 'Soft Gelatin Capsule', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('79', 'Resperitory Solution', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('80', 'Rectal Ointment', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('81', 'Irrigation Solution', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('82', 'Vaginal Cream', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('83', 'Emulgel', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('84', 'Respirator Suspension', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('85', 'Mouth Dissolving Tablet', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('86', 'Oral Emulsion', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('87', 'Oral Soluble Film', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('88', 'Rapid Tablet', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('89', 'Powder for Pedriatric Drop', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('90', 'Mouth Wash Antiseptic', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('91', 'Dialysis Solution', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('92', 'Per Rectal', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('93', 'Pr Tablet', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('94', 'Dr Granules For Suspension', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('95', 'Vaginal Gel', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('96', 'Gummy Tablet', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('97', 'Vaccine', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('98', 'Blood bag', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('99', 'Gas', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('100', 'Tincture', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('101', 'Scrub', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('102', 'Pvc Bag', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('103', 'Powder for Solution', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('104', 'Blood Tubing Set', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('105', 'Needle for Syringe', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('106', 'Butterfly', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('107', 'Powder For Oral Solution', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('108', 'Er Capsule', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('109', 'Eye Cleanser Solution', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('110', 'Oral Liquid', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('111', 'Eye and Ear Ointment', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('112', 'Vaginal Pessary', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('113', 'Oral Dental Gel', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('114', 'Topical Suspension', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('115', 'Cr Capsule', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('116', 'Gum', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('117', 'Md Tablet', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('118', 'Viscoelastic Solution', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('119', 'Inhalation Liquid', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('120', 'Vaginal Suppository', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('121', 'Mups Tablet', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('122', 'Drops', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('123', 'Effervescent Granules', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('124', 'Scalp Ointment', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('125', 'M R Capsule', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('126', 'Sprinkle Capsule', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('127', 'Repacking', '1');
INSERT INTO `product_category` (`category_id`, `category_name`, `status`) VALUES ('128', 'A Category', '1');


#
# TABLE STRUCTURE FOR: product_information
#

DROP TABLE IF EXISTS `product_information`;

CREATE TABLE `product_information` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` varchar(30) NOT NULL,
  `category_id` varchar(50) NOT NULL,
  `product_name` varchar(50) NOT NULL,
  `generic_name` varchar(250) NOT NULL,
  `strength` varchar(250) NOT NULL,
  `box_size` varchar(30) NOT NULL,
  `product_location` varchar(50) NOT NULL,
  `price` varchar(20) NOT NULL,
  `tax` varchar(20) DEFAULT NULL,
  `product_model` varchar(50) DEFAULT NULL,
  `manufacturer_id` bigint(20) NOT NULL,
  `manufacturer_price` decimal(10,2) DEFAULT NULL,
  `unit` varchar(50) DEFAULT NULL,
  `product_details` varchar(250) DEFAULT NULL,
  `image` text NOT NULL,
  `status` int(11) NOT NULL,
  `tax0` text,
  `tax1` text,
  `tax2` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28782 DEFAULT CHARSET=latin1;

INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1', '48496329814781514934', '3', 'Nimocon 500', 'Azithromycin', '500 mg', '', '', '0', '', '', '3', NULL, '', 'Csv Uploaded Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('2', '84328232756241462869', '3', 'Adbon', 'Calcium + Vitamin D3', '500 mg + 200 IU', '', '', '0', '', '', '3', NULL, '', 'Csv Uploaded Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('3', '69328687632613388455', '3', 'Neutin 600', 'Gabapentin', '600 mg', '', '', '0', '', '', '3', NULL, '', 'Csv Uploaded Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('4', '57114571335949428172', '4', 'Acidex 20', 'Omeprazole', '20 mg', '', '', '0', '', '', '3', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('5', '26186312317854536731', '3', 'Opental 50', 'Tramadol Hydrochloride', '50 mg', '', '', '0', '', '', '3', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('6', '63439253233166581665', '5', 'Disposible Syringe 10 ml', 'Disposable Syringe', '10 ml', '', '', '0', '', '', '4', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('7', '59357716294636839511', '5', 'CADY AD Syringe', 'Disposable Syringe', '.5 ml', '', '', '0', '', '', '4', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('8', '38596431379946132483', '5', 'BECKY 3 ml AD & RPF Syringe', 'Disposable Syringe', '3 ml', '', '', '0', '', '', '4', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('9', '34399996135223815698', '5', 'BECKY 5 ml AD & RPF Syringe', 'Disposable Syringe', '5 ml', '', '', '0', '', '', '4', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('10', '29619773544718889458', '3', 'Atofine 20', 'Atorvastatin', '20 mg', '', '', '0', '', '', '5', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('11', '43828132961372268131', '3', 'Atofine 10', 'Atorvastatin', '10 mg', '', '', '0', '', '', '5', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('12', '47144235468123294335', '6', 'Azifine', 'Azithromycin', '200 mg/5 ml', '', '', '0', '', '', '5', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('13', '91212545432374973357', '3', 'Azifine 500', 'Azithromycin', '500 mg', '', '', '0', '', '', '5', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('14', '22286593493164456617', '6', 'Cefatop', 'Cefixime', '100 mg/5 ml', '', '', '0', '', '', '5', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('15', '14831868439943419313', '4', 'Cefatop 200', 'Cefixime', '200 mg', '', '', '0', '', '', '5', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('16', '33898923391788321469', '6', 'Cefufine', 'Cefuroxime', '125 mg/5 ml', '', '', '0', '', '', '5', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('17', '16941826847862913737', '3', 'Cefufine 500', 'Cefuroxime', '500 mg', '', '', '0', '', '', '5', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('18', '65193399471975331564', '3', 'Cefufine 250', 'Cefuroxime', '250 mg', '', '', '0', '', '', '5', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('19', '75413313348787429167', '3', 'Maxtrol 20', 'Esomeprazole', '20 mg', '', '', '0', '', '', '5', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('20', '63673461887888423773', '3', 'Rosufine 10', 'Rosuvastatin', '10 mg', '', '', '0', '', '', '5', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('21', '79359466377899957125', '3', 'Glorinta', 'Ticagrelor', '90 mg', '', '', '0', '', '', '5', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('22', '14248978235147357971', '3', 'Fleco', 'Aceclofenac', '100 mg', '', '', '0', '', '', '6', '2.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('23', '48792642582169768739', '3', 'Aldaben  DS  400', 'Albendazole', '400 mg', '', '', '0', '', '', '6', '4.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('24', '87963867224756313867', '3', 'Aldaben    200', 'Albendazole', '200 mg', '', '', '0', '', '', '6', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('25', '94888328975267155788', '7', 'Aldaben', 'Albendazole', '200 mg/5 ml', '', '', '0', '', '', '6', '15.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('26', '35654131647837671615', '3', 'Duomeal', 'Aluminium Hydroxide + Magnesium Hydroxide', '250 mg + 400 mg', '', '', '0', '', '', '6', '0.53', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('27', '19199667638674577192', '7', 'Duomeal', 'Aluminium Oxide + Magnesium Hydroxide', '175 mg + 225 mg/5 ml', '', '', '0', '', '', '6', '40.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('28', '36913347328313271187', '4', 'Mucovan', 'Ambroxol', '75 mg', '', '', '0', '', '', '6', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('29', '42335772455195128964', '8', 'Mucovan', 'Ambroxol', '15 mg/5 ml', '', '', '0', '', '', '6', '40.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('30', '35895626423156732913', '3', 'Nopidin 5', 'Amlodipine', '5 mg', '', '', '0', '', '', '6', '3.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('31', '84251386412729418867', '3', 'Nopirol', 'Amlodipine + Atenolol', '5 mg + 25 mg', '', '', '0', '', '', '6', '4.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('32', '58715645511662364135', '4', 'J Mox    250', 'Amoxicillin', '250 mg', '', '', '0', '', '', '6', '2.86', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('33', '77765758377638577349', '6', 'J Mox', 'Amoxicillin', '125 mg/5 ml', '', '', '0', '', '', '6', '45.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('34', '58422592567359662493', '9', 'J Mox', 'Amoxicillin', '125 mg/1.25 ml', '', '', '0', '', '', '6', '28.32', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('35', '72165929697477774573', '4', 'J Mox    500', 'Amoxicillin', '500 mg', '', '', '0', '', '', '6', '5.71', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('36', '24243675938539856772', '10', 'New Orsa-A', 'Anhydrous Glucose + Potassium Chloride + Sodium Chloride + Trisodium Citrate', '6.75 gm + 750 mg + 1.3 gm + 1.45 gm', '', '', '0', '', '', '6', '4.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('37', '29343732719827757325', '4', 'Ad - All', 'Ascorbic Acid + Elemental Iron + Folic Acid + Nicotinamide + Pyridoxine Hydrochloride + Riboflavin + Vitamin B1 + Zinc', '50 mg + 47 mg + 500 mcg + 10 mg + 1 mg + 2 mg + 2 mg + 22.5 mg', '', '', '0', '', '', '6', '3.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('38', '49466126889594543226', '3', 'Aslic 75', 'Aspirin', '75 mg', '', '', '0', '', '', '6', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('39', '69198163944992321512', '3', 'Clogrel Plus', 'Aspirin + Clopidogrel', '75 mg + 75 mg', '', '', '0', '', '', '6', '11.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('40', '58534894997136551442', '3', 'Atonul 50', 'Atenolol', '50 mg', '', '', '0', '', '', '6', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('41', '59831424456534594144', '3', 'Vastor 10', 'Atorvastatin', '10 mg', '', '', '0', '', '', '6', '10.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('42', '38625661955783264395', '3', 'Vinzam', 'Azithromycin', '500 mg', '', '', '0', '', '', '6', '30.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('43', '46673934691988754526', '6', 'Vinzam', 'Azithromycin', '200 mg/5 ml', '', '', '0', '', '', '6', '82.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('44', '21524466272317846385', '3', 'Relofen 10', 'Baclofen', '10 mg', '', '', '0', '', '', '6', '8.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('45', '41818272863637826293', '11', 'Jess Whitfield', 'Benzoic Acid + Salicylic Acid', '60 mg + 30 mg/gm', '', '', '0', '', '', '6', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('46', '19127988864538981755', '12', 'Jescabilotion    25%', 'Benzyl Benzoate', '1.25 gm/5 ml', '', '', '0', '', '', '6', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('47', '68646571826838135391', '13', 'Metobet', 'Betamethasone', '100 mg/100 gm', '', '', '0', '', '', '6', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('48', '62782376648854453551', '3', 'Adrest', 'Bromazepam', '3 mg', '', '', '0', '', '', '6', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('49', '75885438119456312372', '8', 'Mucoxin', 'Bromhexine Hydrochloride', '4 mg/5 ml', '', '', '0', '', '', '6', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('50', '99963181222135671514', '3', 'Feva   PLUS', 'Caffeine + Paracetamol', '65 mg + 500 mg', '', '', '0', '', '', '6', '1.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('51', '54642276349331665493', '3', 'Calcium   A&D', 'Calcium + Vitamin D3', '500 mg + 200 IU', '', '', '0', '', '', '6', '3.30', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('52', '14668513492541794887', '3', 'Calcium A', 'Calcium Carbonate', '1250 mg', '', '', '0', '', '', '6', '3.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('53', '99435558582474329952', '3', 'Avidol 6.25', 'Carvedilol', '6.25 mg', '', '', '0', '', '', '6', '3.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('54', '25132796451651447571', '6', 'Cefixime A', 'Cefixime', '100 mg/5 ml', '', '', '0', '', '', '6', '180.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('55', '67669652788298179542', '4', 'Cefixime A   200', 'Cefixime', '200 mg', '', '', '0', '', '', '6', '30.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('56', '44128442717243216794', '6', 'Adrox', 'Cefuroxime', '250 mg/5 ml', '', '', '0', '', '', '6', '181.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('57', '25144873565477526758', '4', 'Jedine    250', 'Cephradine', '250 mg', '', '', '0', '', '', '6', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('58', '88159894943747979149', '4', 'Jedine    500', 'Cephradine', '500 mg', '', '', '0', '', '', '6', '12.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('59', '93279953964474461331', '6', 'Jedine', 'Cephradine', '125 mg/5 ml', '', '', '0', '', '', '6', '80.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('60', '25714777216523722321', '9', 'Jedine', 'Cephradine', '125 mg/1.25 ml', '', '', '0', '', '', '6', '50.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('61', '49119387641636912579', '3', 'Cirizin    10', 'Cetirizine Dihydrochloride', '10 mg', '', '', '0', '', '', '6', '2.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('62', '21785224198155711247', '8', 'Cirizin', 'Cetirizine Dihydrochloride', '5 mg/5 ml', '', '', '0', '', '', '6', '22.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('63', '92388389276565658514', '8', 'Alerjess', 'Chlorpheniramine Maleate', '2 mg/5 ml', '', '', '0', '', '', '6', '20.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('64', '64191648449864997117', '3', 'Alerjess', 'Chlorpheniramine Maleate', '4 mg', '', '', '0', '', '', '6', '0.20', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('65', '62687996874428798157', '3', 'Ciproxen    250', 'Ciprofloxacin', '250 mg', '', '', '0', '', '', '6', '7.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('66', '29485269899581215793', '3', 'Ciproxen    500', 'Ciprofloxacin', '500 mg', '', '', '0', '', '', '6', '14.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('67', '63861493685924857416', '6', 'Ciproxen', 'Ciprofloxacin', '250 mg/5 ml', '', '', '0', '', '', '6', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('68', '32622196549288765128', '13', 'Aclosol', 'Clobetasol Propionate', '50 mg/100 gm', '', '', '0', '', '', '6', '45.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('69', '95176444649596438946', '13', 'Amobet', 'Clobetasone Butyrate', '50 mg/100 gm', '', '', '0', '', '', '6', '30.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('70', '86316513887783268638', '3', 'Clozepam    0.5', 'Clonazepam', '.5 mg', '', '', '0', '', '', '6', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('71', '27456261828468629875', '3', 'Clogrel', 'Clopidogrel', '75 mg', '', '', '0', '', '', '6', '9.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('72', '48327646194351242835', '13', 'Loderm', 'Clotrimazole', '10 mg/gm', '', '', '0', '', '', '6', '23.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('73', '51637987762995865828', '3', 'Combomin', 'Cyanocobalamin + Pyridoxine Hydrochloride + Vitamin B1', '200 mcg + 200 mg + 100 mg', '', '', '0', '', '', '6', '4.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('74', '88523738641866275439', '3', 'Adlorin    5', 'Desloratadine', '5 mg', '', '', '0', '', '', '6', '2.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('75', '91182295227444875939', '8', 'Metodex', 'Dextromethorphan Hydrobromide', '10 mg/5 ml', '', '', '0', '', '', '6', '30.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('76', '55142434856853687692', '10', 'O R S A', 'Dextrose Anhydrous + Potassium Chloride + Sodium Chloride + Trisodium Citrate', '10 gm + 750 gm + 1.75 gm + 1.45 gm/500 ml', '', '', '0', '', '', '6', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('77', '52665787578972154538', '4', 'Jefenac  TR  100', 'Diclofenac Sodium', '100 mg', '', '', '0', '', '', '6', '3.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('78', '44935678714995796963', '3', 'Neofenac    50', 'Diclofenac Sodium', '50 mg', '', '', '0', '', '', '112', '0.84', '', 'Csv Uploaded Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('79', '76746655326269934878', '14', 'Neofenac', 'Diclofenac Sodium', '1 gm/100 gm', '', '', '0', '', '', '6', '12.90', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('80', '81636464937237637341', '15', 'Neofenac 50', 'Diclofenac Sodium', '50 mg', '', '', '0', '', '', '6', '12.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('81', '11111236477632391463', '15', 'Neofenac 12.5', 'Diclofenac Sodium', '12.5 mg', '', '', '0', '', '', '6', '7.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('82', '63756781562353228857', '3', 'Gutset', 'Domperidone', '10 mg', '', '', '0', '', '', '6', '2.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('83', '81949613566228887665', '9', 'Gutset', 'Domperidone', '5 mg/ml', '', '', '0', '', '', '6', '20.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('84', '86763471767756491267', '7', 'Gutset', 'Domperidone', '5 mg/5 ml', '', '', '0', '', '', '6', '35.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('85', '98672541184752246961', '13', 'Zolecon', 'Econazole Nitrate', '1 gm/100 gm', '', '', '0', '', '', '6', '25.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('86', '36589659428819413849', '13', 'Conatrim', 'Econazole Nitrate + Triamcinolone Acetonide', '1 gm + 100 mg/100 gm', '', '', '0', '', '', '6', '34.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('87', '74121441494332121121', '4', 'Redplus  Extra', 'Elemental Iron + Folic Acid + Nicotinamide + Pyridoxine Hydrochloride + Riboflavin + Vitamin B1 + Zinc', '47 mg + 500 mcg + 20 mg + 2 mg + 2 mg + 5 mg + 22.5 mg', '', '', '0', '', '', '6', '3.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('88', '63774983475343333266', '6', 'Erythromycin  A', 'Erythromycin', '250 mg/5 ml', '', '', '0', '', '', '6', '60.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('89', '71124236835692325662', '4', 'Somazole    20', 'Esomeprazole', '20 mg', '', '', '0', '', '', '6', '5.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('90', '29714995816747276423', '4', 'Somazole 40', 'Esomeprazole', '40 mg', '', '', '0', '', '', '6', '8.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('91', '75351962731636713317', '3', 'Aroxia', 'Etoricoxib', '60 mg', '', '', '0', '', '', '6', '6.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('92', '74348838542665247337', '3', 'Aroxia', 'Etoricoxib', '90 mg', '', '', '0', '', '', '6', '8.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('93', '36965775421899625434', '3', 'Aroxia', 'Etoricoxib', '120 mg', '', '', '0', '', '', '6', '10.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('94', '88149454913779836674', '4', 'Folimer', 'Ferrous Fumarate + Folic Acid', '200 mg + 200 mcg', '', '', '0', '', '', '6', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('95', '45537369831877163448', '8', 'Jefrin', 'Ferrous Sulphate', '200 mg/5 ml', '', '', '0', '', '', '6', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('96', '36791424558499253988', '4', 'Red Plus', 'Ferrous Sulphate + Folic Acid + Zinc', '150 mg + 500 mcg + 22.5 mg', '', '', '0', '', '', '6', '3.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('97', '85548434542292812513', '3', 'Xofast 60', 'Fexofenadine Hydrochloride', '60 mg', '', '', '0', '', '', '6', '3.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('98', '91966449137196733316', '3', 'Xofast 120', 'Fexofenadine Hydrochloride', '120 mg', '', '', '0', '', '', '6', '6.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('99', '62391465138844834916', '7', 'Xofast', 'Fexofenadine Hydrochloride', '30 mg/5 ml', '', '', '0', '', '', '6', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('100', '46337144438918993194', '4', 'Oxacol', 'Flucloxacillin', '500 mg', '', '', '0', '', '', '6', '9.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('101', '85815327988515511238', '4', 'Trigal', 'Fluconazole', '50 mg', '', '', '0', '', '', '6', '7.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('102', '54621834373416164696', '4', 'Trigal', 'Fluconazole', '150 mg', '', '', '0', '', '', '6', '18.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('103', '85169145929882225192', '3', 'Folate', 'Folic Acid', '5 mg', '', '', '0', '', '', '6', '0.30', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('104', '26337382988129579214', '3', 'Frunal', 'Frusemide + Spironolactone', '20 mg + 50 mg', '', '', '0', '', '', '6', '6.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('105', '83866823361271274881', '3', 'Sugred', 'Gliclazide', '80 mg', '', '', '0', '', '', '6', '6.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('106', '62466922743179117318', '3', 'Glaryl 1', 'Glimepiride', '1 mg', '', '', '0', '', '', '6', '2.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('107', '86979769488363414188', '3', 'Glaryl 2', 'Glimepiride', '2 mg', '', '', '0', '', '', '6', '4.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('108', '88134576371266975713', '3', 'Adapen    10', 'Hyoscine Butyl Bromide', '10 mg', '', '', '0', '', '', '6', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('109', '74312748898978836431', '3', 'Lacor', 'Ketorolac Tromethamine', '10 mg', '', '', '0', '', '', '6', '9.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('110', '86683999158998464519', '3', 'Cevozin    5', 'Levocetirizine Hydrochloride', '5 mg', '', '', '0', '', '', '6', '2.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('111', '64869389878833663825', '3', 'Quiva 500 mg', 'Levofloxacin', '500 mg', '', '', '0', '', '', '6', '13.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('112', '17353189595744268977', '3', 'Cladin', 'Loratadine', '10 mg', '', '', '0', '', '', '6', '2.25', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('113', '36563969698319199876', '3', 'Carlos 50', 'Losartan Potassium', '50 mg', '', '', '0', '', '', '6', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('114', '15581564813164782458', '7', 'Helben', 'Mebendazole', '100 mg/5 ml', '', '', '0', '', '', '6', '14.80', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('115', '12988389823998178144', '3', 'Meczin', 'Meclizine Hydrochloride', '50 mg', '', '', '0', '', '', '6', '2.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('116', '57929614291273875215', '3', 'Guamin', 'Metformin Hydrochloride', '850 mg', '', '', '0', '', '', '6', '3.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('117', '35858947296172598438', '3', 'D-Met 500', 'Metformin Hydrochloride', '500 mg', '', '', '0', '', '', '6', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('118', '59982815448447577358', '3', 'Prolol', 'Metoprolol Tartrate', '50 mg', '', '', '0', '', '', '6', '1.30', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('119', '99885329399253384661', '3', 'Metra    400', 'Metronidazole', '400 mg', '', '', '0', '', '', '6', '1.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('120', '43723125723289884954', '7', 'Metra', 'Metronidazole', '200 mg/5 ml', '', '', '0', '', '', '6', '24.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('121', '79827578264311516163', '13', 'Mitigal', 'Miconazole', '20 mg/gm', '', '', '0', '', '', '6', '30.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('122', '14172758748338916851', '11', 'Bactokill', 'Mupirocin', '100 mg/5 gm', '', '', '0', '', '', '6', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('123', '19396475836861192991', '3', 'Ultranax 500', 'Naproxen', '500 mg', '', '', '0', '', '', '6', '8.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('124', '13375529159954793846', '4', 'B Plex', 'Nicotinamide + Pyridoxine Hydrochloride + Riboflavin + Vitamin B1', '20 mg + 2 mg + 2 mg + 5 mg', '', '', '0', '', '', '6', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('125', '29141138446733552897', '3', 'B Plex', 'Nicotinamide + Pyridoxine Hydrochloride + Riboflavin + Vitamin B1', '20 mg + 2 mg + 2 mg + 5 mg', '', '', '0', '', '', '6', '0.46', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('126', '72637458557799563932', '8', 'B Plex', 'Nicotinamide + Pyridoxine Hydrochloride + Riboflavin + Vitamin B1', '20 mg + 2 mg + 2 mg + 5 mg/5 ml', '', '', '0', '', '', '6', '20.84', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('127', '97312333561586183868', '3', 'B-Z', 'Nicotinamide + Pyridoxine Hydrochloride + Riboflavin + Vitamin B1 + Zinc', '20 mg + 2 mg + 2.75 mg + 5 mg + 10 mg', '', '', '0', '', '', '6', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('128', '13319755561252428384', '6', 'Proxa-A', 'Nitazoxanide', '100 mg/5 ml', '', '', '0', '', '', '6', '35.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('129', '49819934712269967781', '3', 'Proxa-A', 'Nitazoxanide', '500 mg', '', '', '0', '', '', '6', '9.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('130', '99553277435319211561', '4', 'Omrazole    20', 'Omeprazole', '20 mg', '', '', '0', '', '', '6', '4.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('131', '86185238334946786939', '4', 'Omrazol 40', 'Omeprazole', '40 mg', '', '', '0', '', '', '6', '7.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('132', '38419372569457354677', '3', 'Nixpan 20', 'Pantoprazole', '20 mg', '', '', '0', '', '', '6', '3.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('133', '54417184911821446829', '3', 'Nixpan 40', 'Pantoprazole', '40 mg', '', '', '0', '', '', '6', '5.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('134', '97977672639584796293', '9', 'B Plex', 'Pantothenic acid + Pyridoxine Hydrochloride + Riboflavin + Vitamin A + Vitamin B1 + Vitamin C + Vitamin D', '500 mg + 100 mg + 100 mg + 5 Lac IU + 160 mg + 5 gm + 1 gm/100 ml', '', '', '0', '', '', '6', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('135', '96951824869748554712', '7', 'Feva', 'Paracetamol', '120 mg/5 ml', '', '', '0', '', '', '6', '18.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('136', '82243829554512721377', '3', 'Feva', 'Paracetamol', '500 mg', '', '', '0', '', '', '6', '0.75', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('137', '25988657696394658822', '9', 'Feva', 'Paracetamol', '80 mg/ml', '', '', '0', '', '', '6', '12.27', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('138', '32614192949211381274', '15', 'Feva 250', 'Paracetamol', '250 mg', '', '', '0', '', '', '6', '5.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('139', '59647438252723928687', '15', 'Feva 125', 'Paracetamol', '125 mg', '', '', '0', '', '', '6', '4.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('140', '86244581923619915233', '3', 'Pizobet 15', 'Pioglitazone', '15 mg', '', '', '0', '', '', '6', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('141', '82844125789999743181', '3', 'Cartace 2.5', 'Ramipril', '2.5 mg', '', '', '0', '', '', '6', '4.60', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('142', '85441396618388987612', '3', 'Ranitack    150', 'Ranitidine', '150 mg', '', '', '0', '', '', '6', '1.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('143', '99756628484952544624', '3', 'Ribomin', 'Riboflavin', '5 mg', '', '', '0', '', '', '6', '0.23', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('144', '72537212693616425911', '8', 'Ventosol', 'Salbutamol', '2 mg/5 ml', '', '', '0', '', '', '6', '20.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('145', '36452329229737848472', '3', 'Calonil', 'Sucralose', '8 mg', '', '', '0', '', '', '6', '1.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('146', '94966819683176912215', '7', 'Co-Try', 'Sulphamethoxazole + Trimethoprim', '200 mg + 40 mg/5 ml', '', '', '0', '', '', '6', '21.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('147', '24287553813264388459', '3', 'Co-Try', 'Sulphamethoxazole + Trimethoprim', '800 mg + 160 mg', '', '', '0', '', '', '6', '2.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('148', '72518211894786664976', '3', 'Onevit', 'Thiamine Hydrochloride', '100 mg', '', '', '0', '', '', '6', '0.74', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('149', '18693825724464553562', '3', 'Tium', 'Tiemonium Methylsulphate', '50 mg', '', '', '0', '', '', '6', '3.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('150', '69284222544371691312', '4', 'Ultradol', 'Tramadol Hydrochloride', '50 mg', '', '', '0', '', '', '6', '7.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('151', '76531971662324862677', '15', 'Ultradol', 'Tramadol Hydrochloride', '100 mg', '', '', '0', '', '', '6', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('152', '76618286896274517722', '3', 'Toperol', 'Vitamin E', '200 mg', '', '', '0', '', '', '6', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('153', '64177312261812536885', '8', 'J Zinc    10mg/5ml', 'Zinc', '10 mg/5 ml', '', '', '0', '', '', '6', '30.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('154', '64777391244892186961', '3', 'Celofen', 'Aceclofenac', '100 mg', '', '', '0', '', '', '7', '4.01', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('155', '19193395947421663217', '4', 'Soritec 25 mg', 'Acitretin', '25 mg', '', '', '0', '', '', '7', '85.26', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('156', '28587124638915644345', '4', 'Soritec 10 mg', 'Acitretin', '10 mg', '', '', '0', '', '', '7', '45.14', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('157', '34364552719174698882', '14', 'Adgar 0.3%', 'Adapalene', '3 mg/gm', '', '', '0', '', '', '7', '80.24', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('158', '47426166344562281335', '14', 'Adgar 0.1%', 'Adapalene', '100 mg/100 gm', '', '', '0', '', '', '7', '60.18', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('159', '37245959356642794779', '16', 'Cytonic', 'Adenosine + Cytochrome C + Nicotinamide + Sodium Succinate', '200 mg + 50 mg + 1 gm + 60 mg/100 ml', '', '', '0', '', '', '7', '120.36', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('160', '65274218927811397994', '17', 'Xylone-A', 'Adrenaline + Lidocaine Hydrochloride', '5 mcg + 20 mg/ml', '', '', '0', '', '', '7', '3.75', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('161', '13476797346777376789', '3', 'Sintel    200', 'Albendazole', '200 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('162', '44678853146586514673', '3', 'Sintel    400', 'Albendazole', '400 mg', '', '', '0', '', '', '7', '5.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('163', '32498439553682145858', '7', 'Sintel', 'Albendazole', '200 mg/5 ml', '', '', '0', '', '', '7', '20.06', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('164', '23911336594397933145', '18', 'Sintel DT', 'Albendazole', '400 mg', '', '', '0', '', '', '7', '6.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('165', '19374986753944947768', '16', 'Acicaft', 'Alcaftadine', '250 mg/100 ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('166', '16414837946173983631', '3', 'Alen D', 'Alendronic Acid + Vitamin D3', '70 mg + 2800 IU', '', '', '0', '', '', '7', '25.17', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('167', '79985738911992178827', '3', 'Prelab', 'Allystrenol', '5 mg', '', '', '0', '', '', '7', '8.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('168', '32565222553147136857', '3', 'Duxit', 'Almitrine Bismesylate + Raubasine', '30 mg + 10 mg', '', '', '0', '', '', '7', '10.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('169', '18988824823672348176', '3', 'Xiety 0.25', 'Alprazolam', '.25 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('170', '11472793487748123793', '3', 'Xiety 0.50', 'Alprazolam', '.5 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('171', '88185183238569365476', '3', 'Avlocid', 'Aluminium Hydroxide + Magnesium Hydroxide', '250 mg + 400 mg', '', '', '0', '', '', '7', '0.64', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('172', '95485538562821212653', '3', 'Avlocid Plus', 'Aluminium Hydroxide + Magnesium Hydroxide + Simethicone', '400 mg + 400 mg + 30 mg', '', '', '0', '', '', '7', '0.73', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('173', '64291659429881529148', '7', 'Avlocid', 'Aluminium Oxide + Magnesium Hydroxide', '175 mg + 225 mg/5 ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('174', '61343371976212126681', '7', 'Avlocid', 'Aluminium Oxide + Magnesium Hydroxide + Simethicone', '200 mg + 400 mg + 30 mg/5 ml', '', '', '0', '', '', '7', '75.23', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('175', '19783526526175327311', '4', 'Amantril', 'Amantadine Hydrochloride', '100 mg', '', '', '0', '', '', '7', '10.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('176', '36622477777179172396', '9', 'Myrox S', 'Ambroxol', '6 mg/ml', '', '', '0', '', '', '7', '30.09', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('177', '44382363676233613881', '8', 'Myrox', 'Ambroxol', '15 mg/5 ml', '', '', '0', '', '', '7', '40.12', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('178', '67961264689955481359', '4', 'Ambroxol  SR', 'Ambroxol', '75 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('179', '72614169813435785141', '4', 'Myrox SR', 'Ambroxol', '75 mg', '', '', '0', '', '', '7', '5.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('180', '48336881798473466599', '19', 'Ambroxol HCl   Pellets', 'Ambroxol Hydrochloride', '30%', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('181', '42192265453153397557', '17', 'Kacin    100', 'Amikacin', '100 mg/2 ml', '', '', '0', '', '', '7', '16.11', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('182', '66151629753752136673', '17', 'Kacin    500', 'Amikacin', '500 mg/2 ml', '', '', '0', '', '', '7', '48.32', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('183', '15232151288847931454', '3', 'Kaltide', 'Amiloride Hydrochloride + Hydrochlorothiazide', '5 mg + 50 mg', '', '', '0', '', '', '7', '2.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('184', '35574246961151132585', '20', 'Repotyn 5%', 'Amino Acids (Essential)', '5%', '', '', '0', '', '', '7', '352.38', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('185', '51934869797983688782', '20', 'Repotyn Max IV Infusion', 'Amino Acids (Essential) + Glucose & Electrolytes', '7 % + 10 %', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('186', '52888239127351564289', '17', 'Minocap', 'Aminocaproic Acid', '1 gm/5ml', '', '', '0', '', '', '7', '25.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('187', '74965874943315594952', '3', 'Amidron 100', 'Amiodarone Hydrochloride', '100 mg', '', '', '0', '', '', '7', '5.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('188', '56864978295972879721', '3', 'Amidron 200', 'Amiodarone Hydrochloride', '200 mg', '', '', '0', '', '', '7', '10.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('189', '34531947526424389568', '17', 'Amidron IV Injection', 'Amiodarone Hydrochloride', '50 mg/ml', '', '', '0', '', '', '7', '80.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('190', '25372394744147873499', '21', 'Amlex 5%', 'Amlexanox', '50 mg/1 gm', '', '', '0', '', '', '7', '75.23', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('191', '82942638731972992128', '3', 'Cab    5', 'Amlodipine', '5 mg', '', '', '0', '', '', '7', '5.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('192', '69336732659917214417', '3', 'Tenocab    5/25', 'Amlodipine + Atenolol', '5 mg + 25 mg', '', '', '0', '', '', '7', '5.27', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('193', '58834228462116482142', '3', 'Tenocab    5/50', 'Amlodipine + Atenolol', '5 mg + 50 mg', '', '', '0', '', '', '7', '6.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('194', '25297936367998899766', '3', 'Cardual 5/10', 'Amlodipine + Atorvastatin', '5 mg + 10 mg', '', '', '0', '', '', '7', '11.07', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('195', '93471277382948671413', '4', 'Cacetor    5/10', 'Amlodipine + Benazepril Hydrochloride', '5 mg + 10 mg', '', '', '0', '', '', '7', '6.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('196', '95463857437718993674', '4', 'Cacetor    2.5/10', 'Amlodipine + Benazepril Hydrochloride', '2.5 mg + 10 mg', '', '', '0', '', '', '7', '4.03', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('197', '78967924297993898827', '4', 'Cacetor    5/20', 'Amlodipine + Benazepril Hydrochloride', '5 mg + 20 mg', '', '', '0', '', '', '7', '8.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('198', '12994916325855783595', '3', 'Abecab 5/20', 'Amlodipine + Olmesartan Medoxomil', '5 mg + 20 mg', '', '', '0', '', '', '7', '8.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('199', '91575554153596445565', '3', 'Abecab 5/40', 'Amlodipine + Olmesartan Medoxomil', '5 mg + 40 mg', '', '', '0', '', '', '7', '15.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('200', '64662576721594585939', '3', 'Arbitel AM 5/80', 'Amlodipine + Telmisartan', '5 mg + 80 mg', '', '', '0', '', '', '7', '18.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('201', '45968589858598743824', '3', 'Arbitel AM 5/40', 'Amlodipine + Telmisartan', '5 mg + 40 mg', '', '', '0', '', '', '7', '12.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('202', '18461297324514987643', '3', 'Arbocom 5/80', 'Amlodipine + Valsartan', '5 mg + 80 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('203', '87615396287795972466', '3', 'Arbocom 5/160', 'Amlodipine + Valsartan', '5 mg + 160 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('204', '18285753616925888722', '4', 'Avlomox    250', 'Amoxicillin', '250 mg', '', '', '0', '', '', '7', '3.45', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('205', '46827455949171552154', '9', 'Avlomox', 'Amoxicillin', '125 mg/1.25 ml', '', '', '0', '', '', '7', '30.29', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('206', '65611787489541514339', '4', 'Avlomox    500', 'Amoxicillin', '500 mg', '', '', '0', '', '', '7', '6.12', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('207', '45821413773747923344', '6', 'Avlomox  DS', 'Amoxicillin', '250 mg/5 ml', '', '', '0', '', '', '7', '49.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('208', '88398848386637864219', '17', 'Avlomox    250', 'Amoxicillin', '250 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('209', '36618133693189719577', '17', 'Avlomox    500', 'Amoxicillin', '500 mg', '', '', '0', '', '', '7', '32.10', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('210', '76136779653134556568', '6', 'Avlomox', 'Amoxicillin', '125 mg/5 ml', '', '', '0', '', '', '7', '46.32', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('211', '97471518481172967166', '22', 'Acemox    30%', 'Amoxicillin', '30%', '', '', '0', '', '', '7', '267.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('212', '57714565988232396222', '17', 'Acimox Vet', 'Amoxicillin', '1 gm', '', '', '0', '', '', '7', '56.06', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('213', '94477858257738133715', '17', 'Acimox DS Vet', 'Amoxicillin', '2 gm/vial', '', '', '0', '', '', '7', '100.38', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('214', '85381465598974612837', '17', 'Acipillin', 'Ampicillin', '2 gm', '', '', '0', '', '', '7', '50.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('215', '84861771792618676583', '23', 'ACI_ORS Effervescent', 'Anhydrous Glucose + Citric Acid + Potassium Chloride + Sodium Bicarbonate + Sodium Chloride', '1.62 gm + 384 mg + 186 mg + 336 mg + 117 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('216', '16579611414255831274', '10', 'ACI ORS', 'Anhydrous Glucose + Potassium Chloride + Sodium Chloride + Trisodium Citrate', '6.75 gm + 750 mg + 1.3 gm + 1.45 gm', '', '', '0', '', '', '7', '4.60', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('217', '29731432973834331264', '3', 'Arinia 5', 'Aripiprazole', '5 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('218', '13528835455848687365', '3', 'Arinia 10', 'Aripiprazole', '10 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('219', '25495192699885353268', '3', 'Arinia 15', 'Aripiprazole', '15 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('220', '39527847642824812131', '3', 'Armoda 150', 'Armodafinil', '150 mg', '', '', '0', '', '', '7', '15.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('221', '52555139946782752187', '3', 'Armoda 250', 'Armodafinil', '250 mg', '', '', '0', '', '', '7', '25.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('222', '36473616268421652365', '3', 'Coavlon', 'Artemether + Lumefantrine', '20 mg + 120 mg', '', '', '0', '', '', '7', '20.14', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('223', '53387955841949466539', '3', 'Revital   GOLD', 'Ascorbic Acid + Biotin + Boron + Calcium + Chromium + Copper + Cyanocobalamin + Elemental Iron + Folic Acid + Iodine + Lutein + Magnesium + Manganese + Molybdenum + Niacin + Nickel + Pantothenic acid + Phosphorous + Pottassium + Pyridoxine Hydrochlor', '60 mg + 30 mcg + 150 mcg + 162 mg + 120 mcg + 2 mg + 6 mcg + 18 mg + 400 mcg + 150 mcg + 250 mcg + 1', '', '', '0', '', '', '7', '6.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('224', '73116576323969443298', '3', 'Revital   SILVER', 'Ascorbic Acid + Biotin + Boron + Calcium Carbonate + Chromium + Copper + Cyanocobalamin + Diabasic Calcium Phosphate + Elemental Iron + Folic Acid + Iodine + Lutein + Magnesium + Manganese + Molybdenum + Niacin + Nickel + Pantothenic acid + Potassium', '60 mg + 30 mcg + 150 mcg + 52.49 mg + 120 mcg + 2 mg + 6 mcg + 478.695 mg + 18 mg + 400 mcg + 150 mc', '', '', '0', '', '', '7', '6.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('225', '76521737812785167459', '8', 'Revital Syrup', 'Ascorbic Acid + Biotin + Calcium + Choline Bitartrate + Chromium + Cyanocobalamin + Inositol + Iodine + Magnesium + Manganese + Pantothenic acid + Para-Amino-Benzoic Acid + Pottassium + Riboflavin + Selenium + Vitamin A + Vitamin B1 + Vitamin D3 + Vi', '1350 mg + 650 mcg + 550 mg + 200 mg + 70 mcg + 60 mcg + 200 mg + 500 mcg + 150 mg + 15 mg + 70 mg +', '', '', '0', '', '', '7', '175.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('226', '91889745785326622615', '8', 'Heptaseas', 'Ascorbic Acid + Cod Liver Oil + Nicotinamide + Pyridoxine Hydrochloride + Riboflavin + Vitamin A + Vitamin B1 + Vitamin D3 + Vitamin E', '17.5 mg + 100 mg + 9 mg + .35 mg + .85 mg + 2000 IU + .7 mg + 200 IU + 1.5 mg/5 ml', '', '', '0', '', '', '7', '85.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('227', '76747453753272119529', '4', 'Tioxil', 'Ascorbic Acid + Copper + Lutein + Vitamin E + Zinc', '60 mg + 2 mg + 6 mg + 30 mg + 15 mg', '', '', '0', '', '', '7', '10.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('228', '63271117415199221579', '3', 'Revigor', 'Ascorbic Acid + Copper + Manganese + Selenium + Vitamin A + Vitamin E + Vitamin K + Zinc', '200 mg + 1 mg + 3 mg + 70 mcg + 2000 IU + 50 IU + 75 mcg + 15 mg', '', '', '0', '', '', '7', '5.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('229', '55447944713911835592', '3', 'Aciprin  CV  75', 'Aspirin', '75 mg', '', '', '0', '', '', '7', '0.39', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('230', '79849588731413757317', '3', 'Clorel A', 'Aspirin + Clopidogrel', '75 mg + 75 mg', '', '', '0', '', '', '7', '12.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('231', '25865763148713346625', '3', 'Tenoren    100', 'Atenolol', '100 mg', '', '', '0', '', '', '7', '1.38', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('232', '61181761594468586575', '3', 'Tenoren    50', 'Atenolol', '50 mg', '', '', '0', '', '', '7', '0.77', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('233', '23747272774269614695', '3', 'Tenoren    25', 'Atenolol', '25 mg', '', '', '0', '', '', '7', '0.45', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('234', '65299735997698259671', '3', 'Tenoren   PLUS 50/25', 'Atenolol + Chlorthalidone', '50 mg + 25 mg', '', '', '0', '', '', '7', '3.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('235', '41373477257746937883', '4', 'Telopin  SR', 'Atenolol + Nifedipine', '50 mg + 20 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('236', '42541413819912389796', '3', 'Atasin    10', 'Atorvastatin', '10 mg', '', '', '0', '', '', '7', '10.07', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('237', '31282783838927556672', '3', 'Atasin    20', 'Atorvastatin', '20 mg', '', '', '0', '', '', '7', '18.12', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('238', '94583953744285112188', '3', 'Atasin 40', 'Atorvastatin', '40 mg', '', '', '0', '', '', '7', '24.16', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('239', '77957624331313819169', '3', 'Atasin 80', 'Atorvastatin', '80 mg', '', '', '0', '', '', '7', '40.12', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('240', '95552573182639172953', '3', 'Corzil-40', 'Azilsartan Medoxomil', '40 mg', '', '', '0', '', '', '7', '12.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('241', '81415658362837118251', '4', 'Odazyth    250', 'Azithromycin', '250 mg', '', '', '0', '', '', '7', '25.08', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('242', '92913946349211725859', '6', 'Odazyth', 'Azithromycin', '200 mg/5 ml', '', '', '0', '', '', '7', '85.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('243', '42757177143914621215', '3', 'Odazyth    500', 'Azithromycin', '500 mg', '', '', '0', '', '', '7', '35.11', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('244', '34261156633185949789', '17', 'Odazyth  IV', 'Azithromycin', '500 mg', '', '', '0', '', '', '7', '251.69', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('245', '16143112688746982335', '16', 'Odazyth', 'Azithromycin', '1 gm/100 ml', '', '', '0', '', '', '7', '110.74', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('246', '54268784167397364319', '3', 'Odazyth 250', 'Azithromycin', '250 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('247', '34931744318298631174', '6', 'Odazyth SR', 'Azithromycin', '2 gm', '', '', '0', '', '', '7', '250.75', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('248', '92568892664813314244', '24', 'Reonam 1gm', 'Aztreonam', '1 gm/vial', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('249', '65286362182245328846', '17', 'Reonam 500mg', 'Aztreonam', '500 mg/vial', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('250', '39339335145597618492', '17', 'Reonam 2gm', 'Aztreonam', '2 gm/vial', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('251', '48958414163685258535', '22', 'Neocitrin', 'Bacitracin Zinc + Neomycin Sulphate', '250 IU + 5 mg/gm', '', '', '0', '', '', '7', '10.37', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('252', '93481881773319819262', '11', 'Neocitrin', 'Bacitracin Zinc + Neomycin Sulphate', '500 IU + 5 mg/gm', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('253', '54839773469966571356', '3', 'Liorel 10', 'Baclofen', '10 mg', '', '', '0', '', '', '7', '8.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('254', '99592537619996712449', '3', 'Liorel 25', 'Baclofen', '25 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('255', '32724191491941383991', '3', 'Liorel 5', 'Baclofen', '5 mg', '', '', '0', '', '', '7', '4.53', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('256', '73975548275492649563', '3', 'Buterol    10', 'Bambuterol Hydrochloride', '10 mg', '', '', '0', '', '', '7', '1.51', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('257', '45885714661711448767', '8', 'Buterol', 'Bambuterol Hydrochloride', '5 mg/5 ml', '', '', '0', '', '', '7', '35.24', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('258', '97778236134663968189', '3', 'Buterol    20', 'Bambuterol Hydrochloride', '20 mg', '', '', '0', '', '', '7', '3.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('259', '44123846272564364817', '25', 'Steradin HFA', 'Beclomethasone Dipropionate', '100 mcg', '', '', '0', '', '', '7', '271.84', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('260', '12574666948743336995', '26', 'Steradin HFA', 'Beclomethasone Dipropionate', '250 mcg/Metered Inhalation', '', '', '0', '', '', '7', '352.38', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('261', '63471392829433984139', '27', 'Steradin', 'Beclomethasone Dipropionate', '11 mg/22 gm', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('262', '56293494351547755885', '11', 'topiclin', 'Benzoic Acid + Salicylic Acid', '60 mg + 30 mg/gm', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('263', '44568428964714456556', '12', 'Sebasol', 'Benzyl Benzoate', '1.25 gm/5 ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('264', '13758169283616379155', '17', 'Strepto-P', 'Benzylpenicillin + Procaine Penicillin + Streptomycin', '5 Lac IU + 15 Lac IU + 2.5 gm/vial', '', '', '0', '', '', '7', '83.38', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('265', '51677733787242166921', '17', 'Strepto-P 0.5', 'Benzylpenicillin + Procaine Penicillin + Streptomycin', '4 Lac IU + 20 Lac IU + .5 gm', '', '', '0', '', '', '7', '20.54', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('266', '59525573172865328237', '3', 'Tasti', 'Betacarotene + Vitamin C + Vitamin E', '6 mg + 200 mg + 50 mg', '', '', '0', '', '', '7', '2.52', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('267', '58198978652868221671', '12', 'Ecsota Scalp Lotion', 'Betamethasone + Salicylic Acid', '.05 gm + 2 gm/100 ml', '', '', '0', '', '', '7', '150.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('268', '19385433998328649396', '28', 'Betan', 'Betamethasone Sodium Phosphate + Neomycin Sulphate', '100 mg + 500 mg/100 ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('269', '94865454469575644775', '3', 'Revital Teen B', 'Biotin + Calcium + Chromium + Copper + Folic Acid + Iron + Magnesium + Manganese + Niacin + Pantothenic acid + Riboflavin + Selenium + Thiamine + Vitamin A + Vitamin B12 + Vitamin B6 + Vitamin C + Vitamin D + Vitamin E + Vitamin K + Zinc', '300 mcg + 200 mg + 120 mcg + 2 mg + 400 mcg + 9 mg + 100 mg + 2 mg + 30 mg + 10 mg + 4.2 mg + 20 mcg', '', '', '0', '', '', '7', '6.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('270', '95259982717552517857', '3', 'Revital Teen G', 'Biotin + Calcium + Chromium + Copper + Folic Acid + Iron + Magnesium + Manganese + Niacin + Pantothenic acid + Riboflavin + Selenium + Thiamine + Vitamin A + Vitamin B12 + Vitamin B6 + Vitamin C + Vitamin D + Vitamin E + Vitamin K + Zinc', '300 mcg + 300 mg + 120 mcg + 2 mg + 400 mcg + 18 mg + 50 mg + 2 mg + 30 mg + 10 mg + 2.6 mg + 20 mcg', '', '', '0', '', '', '7', '6.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('271', '23953375229192569666', '29', 'Acimix Supper-B', 'Biotin + Cobalt + Copper + Cyanocobalamin + DL-Methionine + Elemental Iron + Folic Acid + Iodine + L-Lysine HCl + Manganese + Nicotinamide + Pantothenic acid + Pyridoxine Hydrochloride + Riboflavin + Selenium + Vitamin A + Vitamin B1 + Vitamin D3 + V', '4 gm + .016 gm + .4 gm + .48 mg + 4 gm + 2.4 gm + .032 gm + .016 gm + 2.4 gm + 2.4 gm + 1.6 gm + .5', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('272', '25551694187141879291', '29', 'Acimix Supper-BR', 'Biotin + Cobalt + Copper + Cyanocobalamin + DL-Methionine + Elemental Iron + Folic Acid + Iodine + L-Lysine HCl + Manganese + Nicotinamide + Pantothenic acid + Pyridoxine Hydrochloride + Riboflavin + Selenium + Vitamin A + Vitamin B1 + Vitamin D3 + V', '6 gm + .02 gm + .4 gm + .48 mg + 2 gm + 1.6 gm + .032 gm + .016 gm + 1.2 gm + 2.4 gm + 1.4 gm + .6 g', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('273', '12513724613723857335', '29', 'Acimix Supper-GS', 'Biotin + Cobalt + Copper + Cyanocobalamin + DL-Methionine + Elemental Iron + Folic Acid + Iodine + L-Lysine HCl + Manganese + Nicotinamide + Pantothenic acid + Pyridoxine Hydrochloride + Riboflavin + Selenium + Vitamin A + Vitamin B1 + Vitamin D3 + V', '2 mg + .016 gm + .032 gm + .4 mg + 2 gm + 1.28 gm + .02 gm + .032 gm + 1.2 gm + 2.56 gm + 1 gm + .48', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('274', '59112566151154773696', '29', 'Acimix Supper-L', 'Biotin + Cobalt + Copper + Cyanocobalamin + DL-Methionine + Elemental Iron + Folic Acid + Iodine + L-Lysine HCl + Manganese + Nicotinamide + Pantothenic acid + Pyridoxine Hydrochloride + Riboflavin + Selenium + Vitamin A + Vitamin B1 + Vitamin D3 + V', '2 mg + .016 gm + .032 gm + .4 mg + 2 gm + 1.28 gm + .02 gm + .032 gm + 1.2 gm + 2.56 gm + 1 gm + .48', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('275', '36347655998869715293', '3', 'Probis 5', 'Bisoprolol Hemifumarate', '5 mg', '', '', '0', '', '', '7', '10.03', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('276', '22671565685362199597', '3', 'Probis 2.5', 'Bisoprolol Hemifumarate', '2.5 mg', '', '', '0', '', '', '7', '6.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('277', '63117369715694797731', '3', 'Probis Plus 2.5/6.25', 'Bisoprolol Hemifumarate + Hydrochlorothiazide', '2.5 mg + 6.25 mg', '', '', '0', '', '', '7', '6.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('278', '37643376273853829441', '3', 'Probis Plus 5/6.25', 'Bisoprolol Hemifumarate + Hydrochlorothiazide', '5 mg + 6.25 mg', '', '', '0', '', '', '7', '10.03', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('279', '32522886527568189742', '17', 'Calcivit   PLUS', 'Boric Acid + Calcium Gluconate + Dextrose Anhydrous + Magnesium Hypophosphite', '4.2 gm + 20.8 gm + 22 gm + 5 gm/100 ml', '', '', '0', '', '', '7', '99.80', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('280', '88139993635521283981', '3', 'Acical M', 'Boron + Calcium + Copper + Magnesium + Manganese + Vitamin D + Zinc', '250 mcg + 600 mg + 1 mg + 40 mg + 1.8 mg + 200 IU + 7 mg', '', '', '0', '', '', '7', '7.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('281', '63671531833447999188', '3', 'Acical-MX Effervescent Tablet', 'Boron + Calcium + Copper + Magnesium + Manganese + Vitamin D3 + Zinc', '250 mcg + 600 mg + 1 mg + 40 mg + 1.8 mg + 5 mcg + 7.5 mg', '', '', '0', '', '', '7', '20.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('282', '63298776629875811616', '3', 'Zepam', 'Bromazepam', '3 mg', '', '', '0', '', '', '7', '5.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('283', '82833722666612286861', '16', 'Rotarac', 'Bromfenac', '90 mg/100 ml', '', '', '0', '', '', '7', '98.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('284', '63674688152377653467', '16', 'Rotarac LS', 'Bromfenac', '700 mcg/ml', '', '', '0', '', '', '7', '90.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('285', '91157752516725846484', '30', 'Tylo Doxi Plus', 'Bromhexine Hydrochloride + Doxycycline + Tylosin Tartrate', '2 gm + 20 gm + 10 gm/100 gm', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('286', '15472995182583591613', '27', 'Budenide', 'Budesonide', '1 mg/ml', '', '', '0', '', '', '7', '250.75', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('287', '18669147227912382718', '31', 'Oxycort 6/100 Acucap', 'Budesonide + Formoterol Fumarate', '100 mcg + 6 mcg', '', '', '0', '', '', '7', '6.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('288', '57159515965942341237', '31', 'Oxycort 6/200 Acucap', 'Budesonide + Formoterol Fumarate', '200 mcg + 6 mcg', '', '', '0', '', '', '7', '8.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('289', '55955127776864156189', '31', 'Oxycort 12/400 Acucap', 'Budesonide + Formoterol Fumarate', '400 mcg + 12 mcg', '', '', '0', '', '', '7', '12.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('290', '54815544192749559768', '32', 'Oxycort 160/4.5 HFA', 'Budesonide + Formoterol Fumarate', '160 mcg + 4.5 mcg/Puff', '', '', '0', '', '', '7', '802.41', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('291', '98519625938727219232', '32', 'Oxycort 80/4.5 HFA', 'Budesonide + Formoterol Fumarate', '80 mcg + 4.5 mcg/Puff', '', '', '0', '', '', '7', '601.80', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('292', '67298866977564731612', '3', 'Conart', 'Bumetanide', '1 mg', '', '', '0', '', '', '7', '5.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('293', '54257182758348137329', '17', 'Conart', 'Bumetanide', '2 mg/4 ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('294', '13727211185372764656', '17', 'Pivacain    0.25%', 'Bupivacaine', '2.5 mg/1ml', '', '', '0', '', '', '7', '45.31', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('295', '14322193312727923826', '17', 'Pivacain    0.5%', 'Bupivacaine', '5 mg/ ml', '', '', '0', '', '', '7', '60.41', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('296', '35949963269462229234', '17', 'Pivacain D', 'Bupivacaine + Dextrose', '20 mg + 320 mg/4 ml', '', '', '0', '', '', '7', '30.20', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('297', '56565662612125985645', '3', 'Acron', 'Buprenorphine', '200 mcg', '', '', '0', '', '', '7', '10.07', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('298', '13378214643539468268', '3', 'Kofnix SR', 'Butamirate Citrate', '50 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('299', '43223399341553696455', '8', 'Kofnix', 'Butamirate Citrate', '150 mg/100 ml', '', '', '0', '', '', '7', '80.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('300', '76758741274214592349', '33', 'kofnix pd paediatric drops', 'Butamirate Citrate', '500 mg/100 ml', '', '', '0', '', '', '7', '50.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('301', '43726464979679246348', '17', 'Catopan  VET', 'Butaphosphan + Cyanocobalamin', '10 gm + 5 mg/100 ml', '', '', '0', '', '', '7', '50.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('302', '45362695438725659597', '17', 'Caloren  IV', 'Calcitriol', '1 mcg/ml', '', '', '0', '', '', '7', '150.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('303', '76363769235567465818', '3', 'Cora-D F/C Tablet', 'Calcium (Coral Calcium) + Vitamin D3', '500 mg + 200 IU', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('304', '16436399243122314525', '3', 'Cora-DX', 'Calcium + Cholecalciferol (Vit. D3)', '600 mg + 400 IU', '', '', '0', '', '', '7', '17.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('305', '37912597294264813858', '3', 'Acical D', 'Calcium + Vitamin D3', '500 mg + 200 IU', '', '', '0', '', '', '7', '7.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('306', '76928481347273625864', '3', 'Remophos 667mg', 'Calcium Acetate', '667 mg', '', '', '0', '', '', '7', '6.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('307', '35279376217392999584', '3', 'Acical    500', 'Calcium Carbonate', '1250 mg', '', '', '0', '', '', '7', '4.01', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('308', '84646689385564368365', '3', 'Acical Jr. Chewable Tablet', 'Calcium Carbonate', '625 mg', '', '', '0', '', '', '7', '3.01', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('309', '52917583554775382359', '3', 'Acical-C', 'Calcium Carbonate + Calcium Lactate Gluconate + Vitamin C', '327 mg + 1 gm + 500 mg', '', '', '0', '', '', '7', '11.03', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('310', '55343635233442846866', '3', 'Acical-CX Effervescent', 'Calcium Carbonate + Calcium Lactate Gluconate + Vitamin C + Vitamin D', '327 mg + 1 gm + 500 mg + 400 IU', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('311', '74469675496586514451', '3', 'Rotacal', 'Calcium Orotate', '400 mg', '', '', '0', '', '', '7', '8.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('312', '71681847297437957325', '3', 'Rotacal Max', 'Calcium Orotate', '740 mg', '', '', '0', '', '', '7', '12.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('313', '76992976952515561273', '3', 'Anaglin', 'Canagliflozin', '100 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('314', '13859882953531418466', '3', 'Ceplep    200', 'Carbamazepine', '200 mg', '', '', '0', '', '', '7', '4.03', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('315', '29416951111849991454', '3', 'Tridopa 150', 'Carbidopa + Entacapone + Levodopa', '37.5 mg + 200 mg + 150 mg', '', '', '0', '', '', '7', '30.09', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('316', '26926898413915555833', '3', 'Tridopa 100', 'Carbidopa + Entacapone + Levodopa', '25 mg + 200 mg + 100 mg', '', '', '0', '', '', '7', '25.08', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('317', '16938279463791496877', '3', 'Tridopa 50', 'Carbidopa + Entacapone + Levodopa', '12.5 mg + 200 mg + 50 mg', '', '', '0', '', '', '7', '15.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('318', '24186592654829491411', '3', 'Tridopa 200', 'Carbidopa + Entacapone + Levodopa', '50 mg + 200 mg + 200 mg', '', '', '0', '', '', '7', '40.12', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('319', '72643599671746293518', '34', 'Cinemet CR', 'Carbidopa + Levodopa', '50 mg + 200 mg', '', '', '0', '', '', '7', '12.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('320', '21672344821449877436', '34', 'Cinemet CR Half', 'Carbidopa + Levodopa', '25 mg + 100 mg', '', '', '0', '', '', '7', '10.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('321', '45396485644294238592', '8', 'Castin', 'Carbocisteine', '250 mg/5 ml', '', '', '0', '', '', '7', '25.00', '', 'Csv Uploaded Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('322', '42773795972284317852', '4', 'Castin', 'Carbocisteine', '375 mg', '', '', '0', '', '', '7', '2.52', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('323', '38773976329252978152', '16', 'Lubrimax', 'Carboxymethylcellulose Sodium', '10 mg/ml', '', '', '0', '', '', '7', '275.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('324', '32136862282594926631', '3', 'Karvedil    25', 'Carvedilol', '25 mg', '', '', '0', '', '', '7', '8.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('325', '62147227113389916267', '3', 'Karvedil    12.5', 'Carvedilol', '12.5 mg', '', '', '0', '', '', '7', '3.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('326', '14899917599751876112', '3', 'Karvedil    6.25', 'Carvedilol', '6.25 mg', '', '', '0', '', '', '7', '3.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('327', '81361546248289389318', '4', 'Abaclor 250', 'Cefaclor', '250 mg', '', '', '0', '', '', '7', '21.14', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('328', '58847441637546925795', '4', 'Abaclor 500', 'Cefaclor', '500 mg', '', '', '0', '', '', '7', '40.27', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('329', '35742758734193436392', '6', 'Abaclor', 'Cefaclor', '125 mg/5 ml', '', '', '0', '', '', '7', '201.35', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('330', '77779457125912377271', '9', 'Abaclor', 'Cefaclor', '125 mg/1.25 ml', '', '', '0', '', '', '7', '125.85', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('331', '13743782665841857481', '3', 'Abaclor 375 ER', 'Cefaclor', '375 mg', '', '', '0', '', '', '7', '30.09', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('332', '26267923172778825454', '4', 'Cedril    500', 'Cefadroxil', '500 mg', '', '', '0', '', '', '7', '12.09', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('333', '85944345761251558541', '6', 'Cedril', 'Cefadroxil', '125 mg/5 ml', '', '', '0', '', '', '7', '70.47', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('334', '32948341574242358224', '3', 'Ceftoren', 'Cefditoren', '200 mg', '', '', '0', '', '', '7', '150.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('335', '44714778847825785267', '3', 'CEFTOREN 400 FC TABLET', 'Cefditoren', '400 mg', '', '', '0', '', '', '7', '250.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('336', '76481634912627536652', '24', 'Pime-4    2g', 'Cefepime', '2 gm/vial', '', '', '0', '', '', '7', '1107.47', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('337', '67318866767255471736', '24', 'Pime-4    1g', 'Cefepime', '1 gm/vial', '', '', '0', '', '', '7', '553.73', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('338', '31736945479497477873', '24', 'Pime-4    500', 'Cefepime', '500 mg/vial', '', '', '0', '', '', '7', '302.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('339', '98879852526493763423', '4', 'Cefim-3    200', 'Cefixime', '200 mg', '', '', '0', '', '', '7', '35.11', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('340', '73953542545792563361', '6', 'Cefim', 'Cefixime', '100 mg/5 ml', '', '', '0', '', '', '7', '130.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('341', '77981851799327317854', '4', 'Cefim-3 DS', 'Cefixime', '400 mg', '', '', '0', '', '', '7', '50.34', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('342', '52117772352873664821', '6', 'Cefim-3', 'Cefixime', '200 mg/5 ml', '', '', '0', '', '', '7', '300.90', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('343', '91127125913478372438', '3', 'Cefim-3', 'Cefixime', '200 mg', '', '', '0', '', '', '7', '30.09', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('344', '41625775762788963964', '3', 'Cefim-3 DS', 'Cefixime', '400 mg', '', '', '0', '', '', '7', '50.15', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('345', '36547523319449286138', '9', 'Cefim-3 PD', 'Cefixime', '2.5 gm/100 ml', '', '', '0', '', '', '7', '100.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('346', '13874547726994438336', '24', 'Cefot 1 Gm', 'Cefotaxime', '1 gm/vial', '', '', '0', '', '', '7', '132.40', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('347', '47237869921835381461', '24', 'Cefot 2 gm', 'Cefotaxime', '2 gm/vial', '', '', '0', '', '', '7', '250.75', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('348', '17718312757661789831', '24', 'Cefot 250', 'Cefotaxime', '250 mg/vial', '', '', '0', '', '', '7', '50.15', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('349', '36361365496837942862', '24', 'Cefot 500', 'Cefotaxime', '500 mg/vial', '', '', '0', '', '', '7', '76.23', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('350', '18516822887787735814', '17', 'Foxitane    1 gm', 'Cefoxitin', '1 gm/vial', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('351', '61871896637743245329', '17', 'Foxitane    2 gm', 'Cefoxitin', '2 gm/vial', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('352', '49921791368168826692', '17', 'Pirome', 'Cefpirome', '1 gm/vial', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('353', '24513279183574776553', '17', 'Pirome', 'Cefpirome', '2 gm/vial', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('354', '28165146354255842641', '3', 'Cefdox    200', 'Cefpodoxime', '200 mg', '', '', '0', '', '', '7', '37.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('355', '61692949471676429135', '6', 'Cefdox', 'Cefpodoxime', '40 mg/5 ml', '', '', '0', '', '', '37', NULL, '', 'Csv Uploaded Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('356', '43158864286818365236', '4', 'Cefdox    100', 'Cefpodoxime', '100 mg', '', '', '0', '', '', '7', '22.13', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('357', '53429413353345376797', '6', 'Cefdox  DS', 'Cefpodoxime', '80 mg/5 ml', '', '', '0', '', '', '7', '176.19', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('358', '34699579483482655859', '9', 'Cefdox', 'Cefpodoxime', '20 mg/ml', '', '', '0', '', '', '7', '60.41', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('359', '28287929482244595495', '3', 'Combocef 100', 'Cefpodoxime + Clavulanic Acid', '100 mg + 62.5 mg', '', '', '0', '', '', '7', '30.09', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('360', '56426173862558264593', '3', 'Combocef 200', 'Cefpodoxime + Clavulanic Acid', '200 mg + 125 mg', '', '', '0', '', '', '7', '50.15', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('361', '44481489679718775272', '3', 'Cefzil 250', 'Cefprozil', '250 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('362', '46579881928855937648', '3', 'Cefzil 500', 'Cefprozil', '500 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('363', '15544176182565591323', '6', 'Cefzil', 'Cefprozil', '250 mg/5 ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('364', '93687471824179265829', '24', 'Zitum    1g', 'Ceftazidime', '1 gm/vial', '', '', '0', '', '', '7', '226.53', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('365', '72943475197833645477', '24', 'Zitum    500 mg', 'Ceftazidime', '500 mg/vial', '', '', '0', '', '', '7', '115.78', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('366', '33219681637474231459', '24', 'Zitum    250 mg', 'Ceftazidime', '250 mg/vial', '', '', '0', '', '', '7', '70.47', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('367', '81589627811569929536', '4', 'Cefteria 400 mg', 'Ceftibuten', '400 mg', '', '', '0', '', '', '7', '120.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('368', '92211327345551484145', '6', 'Cefteria', 'Ceftibuten', '1.8 gm/100 ml', '', '', '0', '', '', '7', '481.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('369', '16623745433474354938', '35', 'Aciphin  IM  1 gm', 'Ceftriaxone', '1 gm', '', '', '0', '', '', '7', '191.29', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('370', '34855347162115656982', '36', 'Aciphin  IV  500 mg', 'Ceftriaxone', '500 mg', '', '', '0', '', '', '7', '130.39', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('371', '64729931849726728382', '35', 'Aciphin  IM  500 mg', 'Ceftriaxone', '500 mg', '', '', '0', '', '', '7', '130.39', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('372', '54692733125855797355', '36', 'Aciphin  IV  250 mg', 'Ceftriaxone', '250 mg', '', '', '0', '', '', '7', '100.30', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('373', '33526225952465243137', '36', 'Aciphin  IV  1 gm', 'Ceftriaxone', '1 gm', '', '', '0', '', '', '7', '191.29', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('374', '44767688879793885465', '35', 'Aciphin  IM  250 mg', 'Ceftriaxone', '250 mg', '', '', '0', '', '', '7', '100.30', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('375', '76596265263334334592', '36', 'Aciphin  IV  2 gm', 'Ceftriaxone', '2 gm', '', '', '0', '', '', '7', '302.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('376', '42931424841854676287', '17', 'Acicef-3 Vet 2gm', 'Ceftriaxone', '2 gm/vial', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('377', '71866557245114513536', '6', 'Cerox A', 'Cefuroxime', '125 mg/5 ml', '', '', '0', '', '', '7', '199.35', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('378', '26246852562816282189', '3', 'Cerox A   250', 'Cefuroxime', '250 mg', '', '', '0', '', '', '7', '25.17', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('379', '94549295265975483296', '3', 'Cerox A   125', 'Cefuroxime', '125 mg', '', '', '0', '', '', '7', '15.11', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('380', '99794454485364952732', '3', 'Cerox A   500', 'Cefuroxime', '500 mg', '', '', '0', '', '', '7', '45.31', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('381', '91427225487678467474', '24', 'Cerox A   750', 'Cefuroxime', '750 mg/vial', '', '', '0', '', '', '7', '126.12', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('382', '89874927658593355714', '24', 'Cerox A   250', 'Cefuroxime', '250 mg/vial', '', '', '0', '', '', '7', '55.38', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('383', '16396798547284635154', '24', 'Cerox-A IV Inj', 'Cefuroxime', '1.5 gm/vial', '', '', '0', '', '', '7', '201.35', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('384', '67348268456293942988', '6', 'Cerox-A DS', 'Cefuroxime', '250 mg/5 ml', '', '', '0', '', '', '7', '250.75', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('385', '96626666733798844832', '3', 'Cerox CV 125', 'Cefuroxime + Clavulanic Acid', '125 mg + 31.25 mg', '', '', '0', '', '', '7', '21.06', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('386', '36933418921521641879', '3', 'Cerox CV 250', 'Cefuroxime + Clavulanic Acid', '250 mg + 62.5 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('387', '85211513169187519229', '3', 'Cerox CV 500', 'Cefuroxime + Clavulanic Acid', '500 mg + 125 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('388', '64236153866391124592', '6', 'Cerox CV', 'Cefuroxime + Clavulanic Acid', '125 mg + 31.25 mg/5 ml', '', '', '0', '', '', '7', '250.75', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('389', '88469425111653432356', '4', 'Acicox    100', 'Celecoxib', '100 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('390', '87682346948628639122', '4', 'Avloxin    250', 'Cephalexin', '250 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('391', '36871371428557219652', '6', 'Avloxin', 'Cephalexin', '125 mg/5 ml', '', '', '0', '', '', '7', '69.47', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('392', '82529829197799444848', '4', 'Avloxin    500', 'Cephalexin', '500 mg', '', '', '0', '', '', '7', '10.57', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('393', '94785145686317815669', '4', 'Avlosef    250', 'Cephradine', '250 mg', '', '', '0', '', '', '7', '8.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('394', '34984997166991631219', '6', 'Avlosef', 'Cephradine', '125 mg/5 ml', '', '', '0', '', '', '7', '90.27', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('395', '63613892263799862463', '24', 'Avlosef    1 gm', 'Cephradine', '1 gm/vial', '', '', '0', '', '', '7', '95.29', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('396', '39425538684171193668', '24', 'Avlosef    500 mg', 'Cephradine', '500 mg/vial', '', '', '0', '', '', '7', '65.20', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('397', '28375968469145556311', '6', 'Avlosef  DS  250', 'Cephradine', '250 mg/5 ml', '', '', '0', '', '', '7', '80.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('398', '31397525293334867745', '9', 'Avlosef', 'Cephradine', '125 mg/1.25 ml', '', '', '0', '', '', '7', '65.20', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('399', '55233411217742382629', '4', 'Avlosef    500', 'Cephradine', '500 mg', '', '', '0', '', '', '7', '15.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('400', '31778242714628517249', '8', 'Acitrin', 'Cetirizine Dihydrochloride', '5 mg/5 ml', '', '', '0', '', '', '7', '30.09', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('401', '52556686727842971927', '3', 'Acitrin    10', 'Cetirizine Dihydrochloride', '10 mg', '', '', '0', '', '', '7', '3.01', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('402', '28963532249811858679', '9', 'Acitrin', 'Cetirizine Dihydrochloride', '2.5 mg/ml', '', '', '0', '', '', '7', '25.08', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('403', '25453966856241895197', '37', 'Acitrin', 'Cetirizine Dihydrochloride', '10 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('404', '92642627558989144615', '38', 'Savlon', 'Cetrimide + Chlorhexidine Gluconate', '15 gm + 1.5 gm/100 ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('405', '81547749444382911764', '38', 'Savlon', 'Cetrimide + Chlorhexidine Gluconate', '3 gm + 300 mg/100 ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('406', '55577138277119143468', '13', 'Savlon', 'Cetrimide + Chlorhexidine Hydrochloride', '500 mg + 100 mg/100 gm', '', '', '0', '', '', '7', '50.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('407', '19934684491696894236', '39', 'Icol   E/E', 'Chloramphenicol', '5 mg/ml', '', '', '0', '', '', '7', '34.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('408', '18791673757396736399', '40', 'Hexicord', 'Chlorhexidine', '4 gm/100 ml', '', '', '0', '', '', '7', '30.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('409', '14585844844359114863', '38', 'Hexiscrub', 'Chlorhexidine Gluconate', '4 gm/100 ml', '', '', '0', '', '', '7', '300.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('410', '38554594658479252152', '41', 'Hexisol', 'Chlorhexidine Gluconate', '500 mg/100 ml', '', '', '0', '', '', '7', '215.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('411', '35256273871647972615', '13', 'Hexitane', 'Chlorhexidine Gluconate', '1%', '', '', '0', '', '', '7', '90.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('412', '67568972383618846522', '42', 'Oralon', 'Chlorhexidine Gluconate', '200 mg/100 ml', '', '', '0', '', '', '7', '50.15', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('413', '98494479512819486226', '14', 'Oralon', 'Chlorhexidine Gluconate', '1%', '', '', '0', '', '', '7', '55.17', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('414', '32513643856932974985', '3', 'Avloquin', 'Chloroquine Phosphate', '250 mg', '', '', '0', '', '', '7', '1.22', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('415', '54762981661377347743', '8', 'Avloquin', 'Chloroquine Phosphate', '80 mg/5 ml', '', '', '0', '', '', '7', '14.91', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('416', '43843561741145483815', '3', 'Acira', 'Chlorpheniramine Maleate', '4 mg', '', '', '0', '', '', '7', '0.30', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('417', '56388981196674344282', '8', 'Acira', 'Chlorpheniramine Maleate', '2 mg/5 ml', '', '', '0', '', '', '7', '14.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('418', '34856429817938327799', '16', 'Denicol', 'Chlorpheniramine Maleate + Dexamethasone', '500 mg + 100 mg/100 ml', '', '', '0', '', '', '7', '68.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('419', '23472965828526587477', '4', 'D3 20000', 'Cholecalciferol (Vit. D3)', '20000 IU', '', '', '0', '', '', '7', '20.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('420', '36971321563882569437', '4', 'D3 40000', 'Cholecalciferol (Vit. D3)', '40000 IU', '', '', '0', '', '', '7', '35.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('421', '15436864461562781914', '3', 'D3 2000', 'Cholecalciferol (Vit. D3)', '2000 IU', '', '', '0', '', '', '7', '2.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('422', '95623634679897898873', '3', 'Hozom (Vet)', 'Choline Bitartrate + Cobalt Sulfate + Cyanocobalamin + Ferrous Sulphate + Thiamine Mononitrate', '9.1 mg + 50 mg + .02 mg + 100 mg + 25 mg', '', '', '0', '', '', '7', '2.26', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('423', '21934417574399967985', '29', 'Hozom DS (Vet)', 'Choline Bitartrate + Cobalt Sulfate + Cyanocobalamin + Ferrous Sulphate + Thiamine Mononitrate (B1)', '18.2 mg + 100 mg + 40 mcg + 200 mg + 50 mg', '', '', '0', '', '', '7', '5.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('424', '82413923255881935817', '3', 'Cartilex', 'Chondroitin + Glucosamine', '200 mg + 250 mg', '', '', '0', '', '', '7', '8.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('425', '15294117581476797195', '24', 'Iminem', 'Cilastatin + Imipenem', '500 mg + 500 mg', '', '', '0', '', '', '7', '1203.12', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('426', '59892568444827851984', '17', 'Iminem 250 IV', 'Cilastatin + Imipenem', '250 mg + 250 mg/vial', '', '', '0', '', '', '7', '650.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('427', '43783169469356542794', '3', 'Inclaud', 'Cilostazol', '100 mg', '', '', '0', '', '', '7', '10.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('428', '72277735763685343829', '3', 'Tyrodin 30', 'Cinacalcet', '30 mg', '', '', '0', '', '', '7', '45.31', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('429', '61785884853251593365', '3', 'Tyrodin 60', 'Cinacalcet', '60 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('430', '13798729768238929663', '3', 'Tyrodin 90', 'Cinacalcet', '90 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('431', '79479683939864928676', '3', 'Artigo', 'Cinnarizine + Dimenhydrinate', '20 mg + 40 mg', '', '', '0', '', '', '7', '2.01', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('432', '92274373972866814452', '16', 'Floxabid', 'Ciprofloxacin', '300 mg/100 ml', '', '', '0', '', '', '7', '40.12', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('433', '29812136526474475992', '3', 'Floxabid    250', 'Ciprofloxacin', '250 mg', '', '', '0', '', '', '7', '8.56', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('434', '12634155441754665742', '3', 'Floxabid    500', 'Ciprofloxacin', '500 mg', '', '', '0', '', '', '7', '15.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('435', '74815481564483914319', '3', 'Floxabid    750', 'Ciprofloxacin', '750 mg', '', '', '0', '', '', '7', '18.12', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('436', '95231221645878956189', '6', 'Floxabid', 'Ciprofloxacin', '250 mg/5 ml', '', '', '0', '', '', '7', '100.30', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('437', '99962266239251641168', '43', 'Floxabid  SR  1 gm', 'Ciprofloxacin', '1 gm', '', '', '0', '', '', '7', '20.13', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('438', '95155768462663493985', '20', 'Floxabid IV', 'Ciprofloxacin', '200 mg/100 ml', '', '', '0', '', '', '7', '146.44', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('439', '27185597917619282867', '29', 'Acivet Cipro', 'Ciprofloxacin', '1 gm', '', '', '0', '', '', '7', '19.80', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('440', '43224183452116799213', '22', 'Acivet Cipro 20%', 'Ciprofloxacin', '200 gm/Kg', '', '', '0', '', '', '7', '45.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('441', '17115295476513159714', '17', 'Acivet Cipro', 'Ciprofloxacin', '5 gm/100 ml', '', '', '0', '', '', '7', '35.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('442', '99837573669581852837', '38', 'Acivet-Cipro Oral Solution', 'Ciprofloxacin', '10 gm/100 ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('443', '34355142776738967712', '16', 'Floxadex', 'Ciprofloxacin + Dexamethasone', '300 mg + 100 mg/100 ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('444', '82344684753634663346', '12', 'Daclin', 'Clindamycin', '10 mg/ml', '', '', '0', '', '', '7', '125.38', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('445', '48951129953395365992', '4', 'Daclin 150', 'Clindamycin', '150 mg', '', '', '0', '', '', '7', '8.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('446', '22995391536998818616', '4', 'Daclin', 'Clindamycin', '300 mg', '', '', '0', '', '', '7', '15.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('447', '18128868239773278878', '14', 'Daclin-T', 'Clindamycin Phosphate + Tretinoin', '1.2 gm + .025 gm/100 gm', '', '', '0', '', '', '7', '150.45', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('448', '13315718389967671771', '3', 'Sedzam    10', 'Clobazam', '10 mg', '', '', '0', '', '', '7', '2.82', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('449', '59576213429983938861', '13', 'Clovate', 'Clobetasol Propionate', '50 mg/100 gm', '', '', '0', '', '', '7', '58.17', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('450', '13238192455475771911', '11', 'Clovate', 'Clobetasol Propionate', '50 mg/100 gm', '', '', '0', '', '', '7', '68.20', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('451', '91963777796551314971', '44', 'Clovate Solution', 'Clobetasol Propionate', '50 mg/100 ml', '', '', '0', '', '', '7', '200.60', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('452', '58786121896673619455', '13', 'Clovate N', 'Clobetasol Propionate + Neomycin Sulphate + Nystatin', '50 mg + 500 mg + 100 Lac IU/100 gm', '', '', '0', '', '', '7', '65.20', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('453', '45847877868235691836', '11', 'Clovate N', 'Clobetasol Propionate + Neomycin Sulphate + Nystatin', '50 mg + 500 mg + 100 Lac IU/100 gm', '', '', '0', '', '', '7', '70.21', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('454', '63865136865228212692', '9', 'Clonium', 'Clonazepam', '2.5 mg/ml', '', '', '0', '', '', '7', '130.88', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('455', '28362624839953619361', '3', 'Clonium    0.5', 'Clonazepam', '.5 mg', '', '', '0', '', '', '7', '6.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('456', '87589866745894229966', '3', 'Clonium    2', 'Clonazepam', '2 mg', '', '', '0', '', '', '7', '10.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('457', '68761321211135785671', '3', 'Clonium 1', 'Clonazepam', '1 mg', '', '', '0', '', '', '7', '8.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('458', '83519923148636211375', '3', 'Clorel    75', 'Clopidogrel', '75 mg', '', '', '0', '', '', '7', '12.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('459', '26446829147442346748', '38', 'Dermasim', 'Clotrimazole', '10 mg/gm', '', '', '0', '', '', '7', '68.20', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('460', '51343661672368388964', '45', 'Dermasim  VT  500', 'Clotrimazole', '500 mg', '', '', '0', '', '', '7', '60.41', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('461', '89466746853876399611', '13', 'Dermasim 1%', 'Clotrimazole', '10 mg/gm', '', '', '0', '', '', '7', '35.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('462', '23947438344818764131', '45', 'Dermasim  VT  200', 'Clotrimazole', '200 mg', '', '', '0', '', '', '7', '20.14', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('463', '29597785225569625478', '46', 'Dermasim    1%', 'Clotrimazole', '10 mg/gm', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('464', '87797754934985963697', '22', 'Aqu Para (Vet)', 'Copper Sulphate', '100 gm/100 gm', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('465', '39841127378492128471', '12', 'Permisol Max', 'Crotamiton + Permethrin', '10 gm + 5 gm/100 ml', '', '', '0', '', '', '7', '100.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('466', '82859797573868846884', '4', 'Polyron   PLUS', 'Cyanocobalamin + Elemental Iron + Folic Acid', '25 mg + 100 mg + 1 mg', '', '', '0', '', '', '7', '2.77', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('467', '86548675536471282275', '8', 'Polyron   PLUS', 'Cyanocobalamin + Elemental Iron + Folic Acid', '25 mg + 100 mg + 1 mg/5 ml', '', '', '0', '', '', '7', '55.38', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('468', '29462254418923689898', '3', 'Povital', 'Cyanocobalamin + Pyridoxine Hydrochloride + Vitamin B1', '200 mcg + 200 mg + 100 mg', '', '', '0', '', '', '7', '8.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('469', '35341446352168522121', '17', 'Povital', 'Cyanocobalamin + Pyridoxine Hydrochloride + Vitamin B1', '1 mg + 100 mg + 100 mg/3 ml', '', '', '0', '', '', '7', '25.17', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('470', '45478568432894986576', '17', 'Acitol B12', 'Cyanocobalamin + Toldimfos Sodium', '5 mg + 20 gm/100 ml', '', '', '0', '', '', '7', '50.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('471', '57912639356976545762', '3', 'Glycema 5', 'Dapagliflozin', '5 mg', '', '', '0', '', '', '7', '16.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('472', '23581329336765735757', '3', 'Glycema 10', 'Dapagliflozin', '10 mg', '', '', '0', '', '', '7', '30.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('473', '71244355542664595473', '3', 'Daxetin 30', 'Dapoxetine', '30 mg', '', '', '0', '', '', '7', '30.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('474', '63722175395891827422', '3', 'Daxetin 60', 'Dapoxetine', '60 mg', '', '', '0', '', '', '7', '50.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('475', '23495544973163453264', '3', 'Defzort', 'Deflazacort', '6 mg', '', '', '0', '', '', '7', '8.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('476', '75878958413194875238', '3', 'Defzort 24', 'Deflazacort', '24 mg', '', '', '0', '', '', '7', '30.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('477', '94918167696149447884', '3', 'Deslorin', 'Desloratadine', '5 mg', '', '', '0', '', '', '7', '2.51', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('478', '43177954869237761862', '8', 'Deslorin', 'Desloratadine', '2.5 mg/5 ml', '', '', '0', '', '', '7', '25.17', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('479', '27897827455197654651', '3', 'Ceptiva', 'Desogestrel + Ethinylestradiol', '150 mcg + 30 mcg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('480', '13557635275879969389', '14', 'Desotop', 'Desonide', '.05 gm/100 gm', '', '', '0', '', '', '7', '50.34', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('481', '29394426786321951861', '39', 'Acicot', 'Dexamethasone', '1 mg/ml', '', '', '0', '', '', '7', '65.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('482', '18943922973746264899', '3', 'Dexcor', 'Dexamethasone', '.5 mg', '', '', '0', '', '', '7', '1.10', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('483', '64217458139211384524', '17', 'Dexacor', 'Dexamethasone Sodium Phosphate', '5 mg/ml', '', '', '0', '', '', '7', '13.09', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('484', '72943195697863995994', '3', 'Flamex    200', 'Ibuprofen', '200 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Uploaded Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('485', '28439913227644413584', '3', 'Flamex    300', 'Dexibuprofen (S Ibuprofen)', '300 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('486', '23131622518139397682', '3', 'Flamex  DX  400', 'Dexibuprofen (S Ibuprofen)', '400 mg', '', '', '0', '', '', '7', '5.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('487', '75324856913982353694', '3', 'Ketron D', 'Dexketoprofen', '25 mg', '', '', '0', '', '', '7', '4.03', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('488', '54567791311344397869', '10', 'ACI ORS Fruity', 'Dextrose Anhydrous + Fructose + Potassium Chloride + Sodium Bicarbonate + Sodium Chloride + Sucrose', '4.09 gm + 70 mg + 380 mg + 420 mg + 440 mg + 8.07 gm/250 ml', '', '', '0', '', '', '7', '65.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('489', '11654528814648227823', '22', 'Acilyte', 'Dextrose Anhydrous + Potassium Chloride + Sodium Bicarbonate + Sodium Chloride + Vitamin A', '10 gm + 5 gm + 50 gm + 26.6 gm + 200 IU', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('490', '41821532212325567448', '10', 'Rehydrat ORS', 'Dextrose Anhydrous + Potassium Chloride + Sodium Chloride + Trisodium Citrate', '10 gm + 750 gm + 1.75 gm + 1.45 gm/500 ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('491', '25865951677176248957', '3', 'Cartilex D', 'Diacerein + Glucosamine Sulphate', '50 mg + 750 mg', '', '', '0', '', '', '7', '12.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('492', '72797525286934982153', '35', 'Mobifen   PLUS', 'Diclofenac + Lidocaine Hydrochloride', '75 mg + 20 mg/2 ml', '', '', '0', '', '', '7', '9.57', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('493', '86421494225648581682', '15', 'Mobiefn    12.5', 'Diclofenac Sodium', '12.5 mg', '', '', '0', '', '', '7', '9.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('494', '13323659294445136888', '3', 'Mobifen    25', 'Diclofenac Sodium', '25 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('495', '36795128737318733364', '16', 'Mobifen', 'Diclofenac Sodium', '1 mg/ml', '', '', '0', '', '', '7', '75.51', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('496', '77324993441762794661', '3', 'Mobifen    50', 'Diclofenac Sodium', '50 mg', '', '', '0', '', '', '7', '0.88', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('497', '21223519188189211393', '15', 'Mobifen    50', 'Diclofenac Sodium', '50 mg', '', '', '0', '', '', '7', '15.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('498', '71879319424568773744', '4', 'Mobifen  SR  100', 'Diclofenac Sodium', '100 mg', '', '', '0', '', '', '7', '3.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('499', '14336245934463916788', '47', 'Diclofenac Sodium', 'Diclofenac Sodium', '100%', '', '', '0', '', '', '123', NULL, '', 'Csv Uploaded Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('500', '81378694613719829977', '4', 'Mobifen  SR  75', 'Diclofenac Sodium', '75 mg', '', '', '0', '', '', '7', '2.52', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('501', '48371191584984195786', '15', 'Mobifen 25', 'Diclofenac Sodium', '25 mg', '', '', '0', '', '', '7', '12.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('502', '27222346188289539754', '3', 'Diverin 10', 'Dicycloverine Hydrochloride', '10 mg', '', '', '0', '', '', '7', '2.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('503', '86842854921528831248', '8', 'Diverin', 'Dicycloverine Hydrochloride', '10 mg/5 ml', '', '', '0', '', '', '7', '30.20', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('504', '19561462134731868893', '3', 'Diverin', 'Dicycloverine Hydrochloride', '20 mg', '', '', '0', '', '', '7', '3.52', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('505', '99758727141231195756', '3', 'Dicarmin    100', 'Diethylcarbamazine Citrate', '100 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('506', '76815813686878162155', '3', 'Daflon    500', 'Diosmin + Hesperidin', '450 mg + 50 mg', '', '', '0', '', '', '7', '12.34', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('507', '93275449297729533491', '8', 'Didra', 'Diphenhydramine Hydrochloride', '10 mg/5 ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('508', '24191174531293979692', '17', 'Dobumin', 'Dobutamine', '250 mg/20 ml', '', '', '0', '', '', '7', '251.69', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('509', '69679772651148296642', '7', 'Vave', 'Domperidone', '5 mg/5 ml', '', '', '0', '', '', '7', '35.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('510', '82319223262166796219', '9', 'Vave', 'Domperidone', '5 mg/ml', '', '', '0', '', '', '7', '25.08', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('511', '95555764176354357141', '3', 'Vave', 'Domperidone', '10 mg', '', '', '0', '', '', '7', '2.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('512', '33987135487473248281', '18', 'Vave', 'Domperidone', '10 mg', '', '', '0', '', '', '7', '5.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('513', '63228381469655322763', '17', 'Cardopa', 'Dopamine Hydrochloride', '200 mg/5 ml', '', '', '0', '', '', '7', '45.31', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('514', '54877284562752448634', '17', 'Dorinem IV', 'Doripenem', '500 mg/vial', '', '', '0', '', '', '7', '2006.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('515', '97297874956229735145', '3', 'Doximar', 'Doxophylline', '400 mg', '', '', '0', '', '', '7', '8.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('516', '42127281666177624442', '3', 'Doximar 200', 'Doxophylline', '200 mg', '', '', '0', '', '', '7', '6.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('517', '49829554422588825332', '8', 'Doximar', 'Doxophylline', '100 mg/5 ml', '', '', '0', '', '', '7', '100.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('518', '65712426924667929936', '4', 'Impedox    100', 'Doxycycline', '100 mg', '', '', '0', '', '', '7', '2.17', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('519', '87972397816447746251', '3', 'Doxamil', 'Doxylamine Succinate', '25 mg', '', '', '0', '', '', '7', '2.01', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('520', '94613937627759875746', '3', 'Drovin    40', 'Drotaverine Hydrochloride', '40 mg', '', '', '0', '', '', '7', '1.77', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('521', '92235969383166269943', '17', 'Drovin', 'Drotaverine Hydrochloride', '40 mg/2 ml', '', '', '0', '', '', '7', '10.07', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('522', '17754249459749682479', '3', 'Loxetine 20', 'Duloxetine', '20 mg', '', '', '0', '', '', '7', '7.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('523', '17258491942215457845', '3', 'Loxetine 30', 'Duloxetine', '30 mg', '', '', '0', '', '', '7', '10.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('524', '68775754285441943698', '3', 'Ebasten', 'Ebastine', '10 mg', '', '', '0', '', '', '7', '10.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('525', '81568917527575124694', '8', 'Ebasten', 'Ebastine', '5 mg/5 ml', '', '', '0', '', '', '7', '80.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('526', '81623569397192991544', '45', 'Ecoren  VT  150', 'Econazole Nitrate', '150 mg', '', '', '0', '', '', '7', '24.16', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('527', '49329927773714447298', '13', 'Ecoren', 'Econazole Nitrate', '1 gm/100 gm', '', '', '0', '', '', '7', '30.20', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('528', '33857871937123743897', '13', 'Ecoren T', 'Econazole Nitrate + Triamcinolone Acetonide', '1 gm + 100 mg/100 gm', '', '', '0', '', '', '7', '41.27', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('529', '94349129972342769967', '17', 'Irosuc Injection', 'Elemental Iron', '100 mg/5 ml', '', '', '0', '', '', '7', '350.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('530', '29138149769852219597', '4', 'Mylovit Z', 'Elemental Iron + Folic Acid + Nicotinamide + Pyridoxine Hydrochloride + Riboflavin + Vitamin B1 + Vitamin C + Zinc', '47 mg + 500 mcg + 10 mg + 1 mg + 2 mg + 2 mg + 50 mg + 22.5 mg', '', '', '0', '', '', '7', '3.52', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('531', '58353451342865334181', '4', 'Carbofol Z', 'Elemental Iron + Folic Acid + Zinc', '50 mg + 500 mcg + 22.5 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('532', '99628687435577726179', '8', 'Livita', 'Elemental Iron + Nicotinamide + Pyridoxine Hydrochloride + Riboflavin + Vitamin B1 + Zinc', '50 mg + 20 mg + 2 mg + 2 mg + 5 mg + 10 mg/5 ml', '', '', '0', '', '', '7', '50.34', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('533', '61936961983399436913', '38', 'G-Enro', 'Enrofloxacin', '100 mg/ml', '', '', '0', '', '', '7', '200.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('534', '89174366973719348436', '3', 'Teviral    1', 'Entecavir', '1 mg', '', '', '0', '', '', '7', '100.30', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('535', '32844415431745247661', '3', 'Teviral    0.5', 'Entecavir', '.5 mg', '', '', '0', '', '', '7', '48.32', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('536', '87782727133325666555', '48', 'Teviral Syrup', 'Entecavir', '5 mg/100 ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('537', '48452657687938351525', '17', 'Vasodrin', 'Ephedrine Hydrochloride', '25 mg/5 ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('538', '12996876697721423746', '9', 'Erythin', 'Erythromycin', '50 mg/1.25 ml', '', '', '0', '', '', '7', '60.41', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('539', '47666536718612721365', '6', 'Erythin', 'Erythromycin', '125 mg/5 ml', '', '', '0', '', '', '7', '61.47', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('540', '63233785685244262242', '3', 'Erythin    500', 'Erythromycin', '500 mg', '', '', '0', '', '', '7', '8.06', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('541', '39682761794265521479', '17', 'Recogen 2000IU', 'Erythropoietin', '2000 IU/.5 ml', '', '', '0', '', '', '7', '1000.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('542', '47955818844271314131', '17', 'Recogen 3000IU', 'Erythropoietin', '3000 IU/.75 ml', '', '', '0', '', '', '7', '1300.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('543', '34277421625143577669', '17', 'Recogen 5000IU', 'Erythropoietin', '5000 IU/.5 ml', '', '', '0', '', '', '7', '2000.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('544', '51949152288198437487', '17', 'Recogen 10000IU', 'Erythropoietin', '10000 IU/ml', '', '', '0', '', '', '7', '3900.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('545', '85293533279873759528', '3', 'Citalam 5', 'Escitalopram', '5 mg', '', '', '0', '', '', '7', '7.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('546', '86871473686956764822', '3', 'Citalam 10', 'Escitalopram', '10 mg', '', '', '0', '', '', '7', '12.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('547', '91692681587315928671', '3', 'Esomep    40', 'Esomeprazole', '40 mg', '', '', '0', '', '', '7', '8.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('548', '57672273513826518478', '3', 'Esomep    20', 'Esomeprazole', '20 mg', '', '', '0', '', '', '7', '5.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('549', '16289539547989388517', '4', 'Esomep 20', 'Esomeprazole', '20 mg', '', '', '0', '', '', '7', '7.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('550', '77276456535713775627', '4', 'Esomep 40', 'Esomeprazole', '40 mg', '', '', '0', '', '', '7', '9.03', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('551', '57654983556976539577', '17', 'Esomep', 'Esomeprazole', '40 mg/vial', '', '', '0', '', '', '7', '90.27', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('552', '41833247881764235521', '49', 'Anaflex Max 500', 'Esomeprazole + Naproxen', '20 mg + 500 mg', '', '', '0', '', '', '7', '10.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('553', '33546567183889999147', '49', 'Anaflex Max 375', 'Esomeprazole + Naproxen', '20 mg + 375 mg', '', '', '0', '', '', '7', '8.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('554', '89718638647247334162', '3', 'Mini-28', 'Ethinylestradiol + Levo Norgestrel', '30 mcg + 150 mcg', '', '', '0', '', '', '7', '1.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('555', '37859748865221465374', '8', 'Serontin', 'Ethosuximide', '5 gm/100 ml', '', '', '0', '', '', '7', '130.39', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('556', '46224638916338944673', '14', 'Clean Gel Hand Wash', 'Ethyl Alcohol + Isopropyl Alcohol', '66 ml + 3.5 ml/100 ml', '', '', '0', '', '', '7', '75.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('557', '51375365161563143627', '3', 'Coxia    90', 'Etoricoxib', '90 mg', '', '', '0', '', '', '7', '12.09', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('558', '71684242527411261314', '3', 'Coxia    60', 'Etoricoxib', '60 mg', '', '', '0', '', '', '7', '7.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('559', '22291916471181778352', '3', 'Coxia    120', 'Etoricoxib', '120 mg', '', '', '0', '', '', '7', '14.09', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('560', '46678311651231724168', '50', 'Listoral Original', 'Eucalypytol + Menthol + Methyl Salicylate + Thymol', '92 mg + 42 mg + 60 mg + 64 mg/100 ml', '', '', '0', '', '', '7', '75.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('561', '75546942266758474919', '3', 'Novatac    20', 'Famotidine', '20 mg', '', '', '0', '', '', '7', '2.27', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('562', '36222335971363251627', '3', 'Novatac    40', 'Famotidine', '40 mg', '', '', '0', '', '', '7', '4.13', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('563', '47166514236247983993', '3', 'Febus 40', 'Febuxostat', '40 mg', '', '', '0', '', '', '7', '12.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('564', '38344327493186992541', '3', 'Febus 80', 'Febuxostat', '80 mg', '', '', '0', '', '', '7', '22.07', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('565', '16445535638628777125', '3', 'Tizabate 160', 'Fenofibrate', '160 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('566', '29383978776737555588', '4', 'Tizabate', 'Fenofibrate', '200 mg', '', '', '0', '', '', '7', '7.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('567', '26996129677854235195', '4', 'Feridex', 'Ferrous Fumarate + Folic Acid', '200 mg + 200 mcg', '', '', '0', '', '', '7', '0.53', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('568', '37461583274498999453', '8', 'Feridex', 'Ferrous Gluconate', '300 mg/5 ml', '', '', '0', '', '', '7', '32.22', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('569', '36349954817757988553', '47', 'Ferrous Sulphate + Folic Acid   Pellets', 'Ferrous Sulphate', '62%', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('570', '83425267555516585875', '4', 'Feridex  TR', 'Ferrous Sulphate + Folic Acid', '150 mg + 500 mcg', '', '', '0', '', '', '7', '2.35', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('571', '61379868232653334478', '4', 'Mylovit', 'Ferrous Sulphate + Folic Acid + Nicotinamide + Pyridoxine Hydrochloride + Riboflavin + Vitamin B1 + Vitamin C', '150 mg + 500 mcg + 10 mg + 1 mg + 2 mg + 2 mg + 50 mg', '', '', '0', '', '', '7', '3.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('572', '19567435124455444537', '4', 'Femizin  TR', 'Ferrous Sulphate + Folic Acid + Zinc', '150 mg + 500 mcg + 22.5 mg', '', '', '0', '', '', '7', '2.92', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('573', '74724669141685491572', '19', 'Ferrous Sulphate + Folic Acid', 'Ferrous Sulphate + Folic Acid + Zinc', '150 mg + 500 mcg + 61.8 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('574', '72936158959795313983', '3', 'Ritch 120', 'Fexofenadine Hydrochloride', '120 mg', '', '', '0', '', '', '7', '8.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('575', '12839512967212527711', '3', 'Ritch 180', 'Fexofenadine Hydrochloride', '180 mg', '', '', '0', '', '', '7', '10.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('576', '24596571277531312855', '3', 'Ritch 60', 'Fexofenadine Hydrochloride', '60 mg', '', '', '0', '', '', '7', '5.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('577', '48561577214283174973', '3', 'Ritch 30 Orodispersible', 'Fexofenadine Hydrochloride', '30 mg', '', '', '0', '', '', '7', '3.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('578', '28612724698638292352', '7', 'Ritch', 'Fexofenadine Hydrochloride', '30 mg/5 ml', '', '', '0', '', '', '7', '48.14', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('579', '76315914172857934726', '17', 'Ropenia S/C', 'Filgrastim', '30 MIU/.5 ml', '', '', '0', '', '', '7', '3400.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('580', '96718122923471886243', '4', 'Fluclox    250', 'Flucloxacillin', '250 mg', '', '', '0', '', '', '7', '5.80', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('581', '51185314366942684518', '4', 'Fluclox    500', 'Flucloxacillin', '500 mg', '', '', '0', '', '', '7', '10.60', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('582', '95841651519793173835', '6', 'Fluclox', 'Flucloxacillin', '125 mg/5 ml', '', '', '0', '', '', '7', '61.41', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('583', '51774677418154876747', '6', 'Fluclox  DS', 'Flucloxacillin', '125 mg/5 ml', '', '', '0', '', '', '7', '61.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('584', '96731896723524777449', '17', 'Fluclox    500', 'Flucloxacillin', '500 mg/vial', '', '', '0', '', '', '7', '45.28', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('585', '71374995347351792661', '17', 'Fluclox    250', 'Flucloxacillin', '250 mg/vial', '', '', '0', '', '', '7', '35.24', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('586', '45786211893561936918', '3', 'Canazole    150', 'Fluconazole', '150 mg', '', '', '0', '', '', '7', '22.15', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('587', '92686716972167183581', '6', 'Canazole', 'Fluconazole', '50 mg/5 ml', '', '', '0', '', '', '7', '78.53', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('588', '96385391697261311328', '3', 'Canazole    50', 'Fluconazole', '50 mg', '', '', '0', '', '', '7', '8.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('589', '29478331987615866633', '3', 'Canazole 200', 'Fluconazole', '200 mg', '', '', '0', '', '', '7', '25.08', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('590', '69919645228298154988', '22', 'Flumivet Power', 'Flumequine', '200 mg/gm', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('591', '18928963889636525224', '3', 'Fluver    10', 'Flunarizine', '10 mg', '', '', '0', '', '', '7', '5.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('592', '59482562623181118333', '3', 'Fluver    5', 'Flunarizine', '5 mg', '', '', '0', '', '', '7', '3.51', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('593', '68384894525122145336', '17', 'Fixin Vet Inj', 'Flunixin', '500 mg/10 ml', '', '', '0', '', '', '7', '200.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('594', '55335185231649169278', '17', 'Fixin Vet Inj', 'Flunixin', '1.25 gm/25 ml', '', '', '0', '', '', '7', '450.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('595', '43948679585966662758', '13', 'Skinalar N', 'Fluocinolone + Neomycin Sulphate', '25 mg + 500 mg/100 gm', '', '', '0', '', '', '7', '40.12', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('596', '78177661299143426765', '11', 'Skinalar N', 'Fluocinolone + Neomycin Sulphate', '25 mg + 500 mg/100 gm', '', '', '0', '', '', '7', '40.12', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('597', '17617159456948682659', '13', 'Skinalar', 'Fluocinolone Acetonide', '25 mg/100 gm', '', '', '0', '', '', '7', '38.12', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('598', '52258896973734167457', '11', 'Skinalar', 'Fluocinolone Acetonide', '25 mg/100 gm', '', '', '0', '', '', '7', '38.12', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('599', '77154615155473354122', '3', 'Adelax', 'Flupenthixol + Melitracen', '500 mcg + 10 mg', '', '', '0', '', '', '7', '5.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('600', '34668996776738799641', '27', 'Fluvent Nasal', 'Fluticasone Propionate', '50 mcg/Spray', '', '', '0', '', '', '7', '250.75', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('601', '16362492456616774245', '26', 'Seroxyn 25/50', 'Fluticasone Propionate + Salmeterol', '50 mcg + 25 mcg/Metered Inhalation', '', '', '0', '', '', '7', '520.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('602', '14277618334498266699', '26', 'Seroxyn 25/125', 'Fluticasone Propionate + Salmeterol', '125 mcg + 25 mcg/Metered Inhalation', '', '', '0', '', '', '7', '500.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('603', '38695374471289367695', '26', 'Seroxyn 25/250', 'Fluticasone Propionate + Salmeterol', '250 mcg + 25 mcg/Metered Inhalation', '', '', '0', '', '', '7', '700.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('604', '35711936186275828667', '51', 'Seroxyn 50/500 Acucap', 'Fluticasone Propionate + Salmeterol', '500 mcg + 50 mcg', '', '', '0', '', '', '7', '15.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('605', '53962376842697112493', '51', 'Seroxyn 50/100 Acucap', 'Fluticasone Propionate + Salmeterol', '100 mcg + 50 mcg', '', '', '0', '', '', '7', '4.86', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('606', '57641811722693294212', '51', 'Seroxyn 50/250 Acucap', 'Fluticasone Propionate + Salmeterol', '250 mcg + 50 mcg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('607', '66883844753437237629', '3', 'Oral-ZF', 'Folic Acid + Zinc', '5 mg + 20 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('608', '15517662727261876795', '52', 'fosfocin 3 gm', 'Fosfomycin', '3 gm', '', '', '0', '', '', '7', '350.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('609', '48735255233146286131', '3', 'Dilup 40/50', 'Frusemide + Spironolactone', '40 mg + 50 mg', '', '', '0', '', '', '7', '6.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('610', '14581376327169749797', '3', 'Dilup 20/50', 'Frusemide + Spironolactone', '20 mg + 50 mg', '', '', '0', '', '', '7', '6.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('611', '96935963987715954933', '3', 'Antial 4 mg', 'Galantamine', '4 mg', '', '', '0', '', '', '7', '12.09', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('612', '34965686336147497886', '3', 'Antial 8 mg', 'Galantamine', '8 mg', '', '', '0', '', '', '7', '20.14', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('613', '35276884294333897719', '3', 'Antial 12 mg', 'Galantamine', '12 mg', '', '', '0', '', '', '7', '30.20', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('614', '42467717563138797355', '4', 'Lipigem', 'Gemfibrozil', '300 mg', '', '', '0', '', '', '7', '7.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('615', '35843161922961962546', '16', 'Igen', 'Gentamicin', '300 mg/100 ml', '', '', '0', '', '', '7', '32.12', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('616', '19221967158739385758', '17', 'Acigan   vet 5', 'Gentamicin', '5 gm', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('617', '13565964446451731568', '53', 'Acigent Vet 20', 'Gentamicin', '20 gm/100 gm', '', '', '0', '', '', '7', '826.48', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('618', '52147492824953254432', '17', 'Acigent-10', 'Gentamicin', '100 mg/ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('619', '46823174845622576695', '3', 'Lozide    80', 'Gliclazide', '80 mg', '', '', '0', '', '', '7', '7.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('620', '71171678678939894661', '3', 'Diamicron MR 60 mg', 'Gliclazide', '60 mg', '', '', '0', '', '', '7', '18.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('621', '69471631589576729862', '3', 'Diamicron MR 30 mg', 'Gliclazide', '30 mg', '', '', '0', '', '', '7', '12.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('622', '49826423871254984443', '3', 'Glimirid    1', 'Glimepiride', '1 mg', '', '', '0', '', '', '7', '6.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('623', '15467375331519169993', '3', 'Glimirid    2', 'Glimepiride', '2 mg', '', '', '0', '', '', '7', '9.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('624', '74914513293685284238', '3', 'Glimirid 3', 'Glimepiride', '3 mg', '', '', '0', '', '', '7', '12.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('625', '42422311441915581866', '3', 'Glimirid 4', 'Glimepiride', '4 mg', '', '', '0', '', '', '7', '15.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('626', '58926894662673534618', '3', 'Glupain', 'Glucosamine', '500 mg', '', '', '0', '', '', '7', '3.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('627', '63347593796637913897', '15', 'Sapotor 1.15 Suppository', 'Glycerol', '1.15 gm', '', '', '0', '', '', '7', '3.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('628', '48674233488761353528', '15', 'Sapotor 2.30 Suppository', 'Glycerol', '2.3 gm', '', '', '0', '', '', '7', '5.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('629', '78692977198984878366', '16', 'Oculax Ophthalmic Solution', 'Glycerol + Hypromellose + Polyethylene Glycol 400', '200 mg + 360 mg + 1 gm/100 ml', '', '', '0', '', '', '7', '250.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('630', '41242618495513758187', '3', 'Pactorin Retard', 'Glyceryl Trinitrate', '2.6 mg', '', '', '0', '', '', '7', '4.03', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('631', '27359899387789877162', '54', 'Pactorin', 'Glyceryl Trinitrate', '400 mcg/Metered Inhalation', '', '', '0', '', '', '7', '250.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('632', '65638411315442646425', '7', 'Fulcinex', 'Griseofulvin', '125 mg/5 ml', '', '', '0', '', '', '7', '23.49', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('633', '29448231147853329757', '3', 'Fulcinex', 'Griseofulvin', '500 mg', '', '', '0', '', '', '7', '5.60', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('634', '73648156945111928897', '13', 'Helobet 0.05%', 'Halobetasol Propionate', '50 mg/100 gm', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('635', '63971472692555685531', '11', 'Halocort 0.05%', 'Halobetasol Propionate', '50 mg/100 gm', '', '', '0', '', '', '7', '135.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('636', '19485215485417418142', '38', 'Halosin', 'Halothane', '187 mg/100 ml', '', '', '0', '', '', '7', '1504.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('637', '29758138171126958539', '3', 'Rosatan H   12.5/50', 'Hydrochlorothiazide + Losartan Potassium', '12.5 mg + 50 mg', '', '', '0', '', '', '7', '6.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('638', '83553492231472789764', '3', 'Rosatan H   25/12.5', 'Hydrochlorothiazide + Losartan Potassium', '12.5 mg + 25 mg', '', '', '0', '', '', '7', '4.03', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('639', '31246377414366289586', '3', 'Abetis Plus', 'Hydrochlorothiazide + Olmesartan Medoxomil', '12.5 mg + 20 mg', '', '', '0', '', '', '7', '8.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('640', '85944585396449681379', '3', 'Abetis Plus 40', 'Hydrochlorothiazide + Olmesartan Medoxomil', '12.5 mg + 40 mg', '', '', '0', '', '', '7', '15.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('641', '87374635446435383949', '3', 'Arbitel Plus 40', 'Hydrochlorothiazide + Telmisartan', '12.5 mg + 40 mg', '', '', '0', '', '', '7', '12.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('642', '19828279416116616643', '3', 'Arbitel Plus 80', 'Hydrochlorothiazide + Telmisartan', '12.5 mg + 80 mg', '', '', '0', '', '', '7', '20.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('643', '28279689954719859836', '17', 'Hison', 'Hydrocortisone', '100 mg/vial', '', '', '0', '', '', '7', '50.34', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('644', '52859424141371573585', '13', 'Zocort    1%', 'Hydrocortisone', '1 gm/100 gm', '', '', '0', '', '', '7', '38.25', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('645', '91884812123686245822', '13', 'Micosone', 'Hydrocortisone + Miconazole Nitrate', '1 gm + 2 gm/100 gm', '', '', '0', '', '', '7', '40.27', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('646', '46625285527749129141', '11', 'Micosone', 'Hydrocortisone + Miconazole Nitrate', '1 gm + 2 gm/100 gm', '', '', '0', '', '', '7', '40.27', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('647', '75636963558141442271', '7', 'Artica', 'Hydroxyzine Hydrochloride', '10 mg/5 ml', '', '', '0', '', '', '7', '40.27', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('648', '71519243139136676224', '3', 'Artica 10', 'Hydroxyzine Hydrochloride', '10 mg', '', '', '0', '', '', '7', '1.25', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('649', '87316247956399742481', '3', 'Artica 25', 'Hydroxyzine Hydrochloride', '25 mg', '', '', '0', '', '', '7', '2.01', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('650', '34849278839553778142', '3', 'Colik    10', 'Hyoscine Butyl Bromide', '10 mg', '', '', '0', '', '', '7', '6.90', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('651', '52225927896697712837', '3', 'Colik    20', 'Hyoscine Butyl Bromide', '20 mg', '', '', '0', '', '', '7', '6.72', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('652', '29385594489152964362', '17', 'Colik', 'Hyoscine Butyl Bromide', '20 mg/ml', '', '', '0', '', '', '7', '29.90', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('653', '45298416769698935148', '16', 'Atier    0.3%', 'Hypromellose', '0.30%', '', '', '0', '', '', '7', '65.45', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('654', '41346934354397346823', '7', 'Flamex', 'Ibuprofen', '100 mg/5 ml', '', '', '0', '', '', '7', '33.81', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('655', '49422897718981693914', '3', 'Flamex    400', 'Ibuprofen', '400 mg', '', '', '0', '', '', '7', '1.43', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('656', '49296742852855316591', '4', 'Flamex 300 SR', 'Ibuprofen', '300 mg', '', '', '0', '', '', '7', '4.01', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('657', '52418193284968265919', '51', 'Oxima 150 Acucap', 'Indacaterol', '150 mcg', '', '', '0', '', '', '7', '35.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('658', '68654843485215584262', '51', 'Oxima 300 Acucap', 'Indacaterol', '300 mcg', '', '', '0', '', '', '7', '65.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('659', '46739489572219517839', '3', 'Natrilex  SR +', 'Indapamide', '1.5 mg', '', '', '0', '', '', '7', '9.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('660', '31289383561726715639', '4', 'Insaid 25', 'Indomethacin', '25 mg', '', '', '0', '', '', '7', '1.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('661', '36636752257655366496', '4', 'Insaid 75 SR', 'Indomethacin', '75 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('662', '88633953837784958368', '3', 'Inosit    500', 'Inositol', '500 mg', '', '', '0', '', '', '7', '5.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('663', '54432478193127419364', '3', 'Inosit    750', 'Inositol', '750 mg', '', '', '0', '', '', '7', '7.55', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('664', '92312834951839813265', '17', 'Acilog Biopen', 'Insulin Aspart', '300 IU/3 ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('665', '31871371332266831194', '38', 'Rinase Respiratory Solution', 'Ipratropium Bromide', '250 mcg/ml', '', '', '0', '', '', '7', '14.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('666', '15339821137823132852', '54', 'Rinase Nasal Spray', 'Ipratropium Bromide', '20 mcg/Spray', '', '', '0', '', '', '7', '150.45', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('667', '26799447756197419756', '26', 'Combair Respirator Solution', 'Ipratropium Bromide + Salbutamol', '20 mcg + 100 mcg/Metered Inhalation', '', '', '0', '', '', '7', '226.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('668', '12732987788727521482', '3', 'Isart    150', 'Irbesartan', '150 mg', '', '', '0', '', '', '7', '9.06', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('669', '21432737398661675918', '8', 'Polyron', 'Iron Hydroxide Polymaltose', '50 mg/5 ml', '', '', '0', '', '', '7', '40.12', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('670', '14387744244213723949', '3', 'MT-3', 'Isoniazid + Pyrazinamide + Rifampicin', '75 mg + 400 mg + 150 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('671', '46555473385881141486', '3', 'Moniten    20', 'Isosorbide Mononitrate', '20 mg', '', '', '0', '', '', '7', '1.42', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('672', '24687931636961723866', '17', 'Acimec    1%', 'Ivermectin', '10 mg/ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('673', '92471593123846348211', '3', 'Veratin    6', 'Ivermectin', '6 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('674', '73385583987887319421', '38', 'Acimec 1%', 'Ivermectin', '1 gm/100 gm', '', '', '0', '', '', '7', '107.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('675', '51217955365414274841', '38', 'Acimec', 'Ivermectin', '1 gm/100 gm', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('676', '76732761848568835985', '3', 'Ketron    50', 'Ketoprofen', '50 mg', '', '', '0', '', '', '7', '3.52', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('677', '57248444815378622697', '4', 'Ketron  SR  100', 'Ketoprofen', '100 mg', '', '', '0', '', '', '7', '7.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('678', '68352644152514315818', '4', 'Ketron  SR  200', 'Ketoprofen', '200 mg', '', '', '0', '', '', '7', '10.07', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('679', '13698314528774677399', '19', 'Ketoprofen   Pellets', 'Ketoprofen', '500 gm/ KG', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('680', '66737616966533486968', '19', 'Ketoprofen   Pellets', 'Ketoprofen', '700 gm/KG', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('681', '61964182747885182362', '29', 'K-Pain Vet', 'Ketoprofen', '400 mg', '', '', '0', '', '', '7', '10.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('682', '89419153819964278988', '17', 'K-Pain Vet', 'Ketoprofen', '100 mg/1 ml', '', '', '0', '', '', '7', '893.78', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('683', '43711938422788141742', '17', 'Minolac    30 mg', 'Ketorolac Tromethamine', '30 mg/ml', '', '', '0', '', '', '7', '55.38', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('684', '67716558893516654231', '3', 'Minolac    10', 'Ketorolac Tromethamine', '10 mg', '', '', '0', '', '', '7', '10.07', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('685', '95734436897366478628', '17', 'Minolac 60', 'Ketorolac Tromethamine', '60 mg/2 ml', '', '', '0', '', '', '7', '95.66', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('686', '22932637929438744875', '17', 'Minolac 10', 'Ketorolac Tromethamine', '10 mg/ml', '', '', '0', '', '', '7', '33.10', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('687', '24443313773337436884', '3', 'Prosma    1', 'Ketotifen', '1 mg', '', '', '0', '', '', '7', '2.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('688', '64926548691162226637', '16', 'Prosma    0.025%', 'Ketotifen', '0.03%', '', '', '0', '', '', '7', '100.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('689', '95497734748955736599', '8', 'Prosma', 'Ketotifen', '1 mg/5 ml', '', '', '0', '', '', '7', '55.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('690', '46465692199321754348', '55', 'Milk Aid', 'Lactase', '300 mg', '', '', '0', '', '', '7', '15.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('691', '79745822528183432372', '22', 'Lacticon Dispersible Granules', 'Lactitol', '10 gm', '', '', '0', '', '', '7', '25.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('692', '16698498381486596193', '48', 'Relacsn', 'Lactulose', '68%', '', '', '0', '', '', '7', '65.45', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('693', '18655337478667513917', '3', 'Lamitrin', 'Lamotrigine', '50 mg', '', '', '0', '', '', '7', '18.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('694', '48538391751813322396', '3', 'Lamitrin 25', 'Lamotrigine', '25 mg', '', '', '0', '', '', '7', '10.03', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('695', '95698618755252547985', '4', 'Lanz    15', 'Lansoprazole', '15 mg', '', '', '0', '', '', '7', '3.03', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('696', '18729137575915234189', '4', 'Lanz    30', 'Lansoprazole', '30 mg', '', '', '0', '', '', '7', '5.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('697', '81818185252916561271', '19', 'Lansoprazole   Pellets', 'Lansoprazole', '170 gm/ KG', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('698', '42433371571742441317', '19', 'Lansoprazole   Pellets', 'Lansoprazole', '85 gm/ KG', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('699', '57541917664779158382', '16', 'Lotensin Plus', 'Latanoprost + Timolol', '.05 mg + 5 mg/ml', '', '', '0', '', '', '7', '382.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('700', '86223432933672262171', '3', 'Sofomax Duo', 'Ledipasvir + Sofosbuvir', '90 mg + 400 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('701', '44112733776959514316', '3', 'Motoral    20', 'Leflunomide', '20 mg', '', '', '0', '', '', '7', '5.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('702', '18629322843865673662', '3', 'Motoral    100', 'Leflunomide', '100 mg', '', '', '0', '', '', '7', '20.13', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('703', '18321193598648896196', '3', 'Canider', 'Lercanidipine Hydrochloride', '10 mg', '', '', '0', '', '', '7', '5.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('704', '12419581668168567387', '3', 'Ovazol', 'Letrozole', '2.5 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('705', '82173694468511481646', '8', 'Etrax', 'Levamisole', '40 mg/5 ml', '', '', '0', '', '', '7', '24.07', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('706', '85872879792116769132', '3', 'Etrax', 'Levamisole', '40 mg', '', '', '0', '', '', '7', '1.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('707', '74953231683475519985', '3', 'Citazar 1000', 'Levetiracetam', '1000 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('708', '85378864338286422851', '3', 'Citazar 750', 'Levetiracetam', '750 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('709', '74977541162352131118', '3', 'Citazar 500', 'Levetiracetam', '500 mg', '', '', '0', '', '', '7', '25.17', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('710', '62297422446721176983', '3', 'Citazar 250', 'Levetiracetam', '250 mg', '', '', '0', '', '', '7', '15.11', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('711', '75759239471213914777', '7', 'Citazar', 'Levetiracetam', '100 mg/ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('712', '47889456885828744389', '3', 'e-Plan', 'Levo Norgestrel', '750 mcg', '', '', '0', '', '', '7', '22.89', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('713', '62223331749823547745', '3', 'e-Plan Max', 'Levo Norgestrel', '1.5 mg', '', '', '0', '', '', '7', '70.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('714', '66354484787818552996', '17', 'Pivacain-L 7.5', 'Levobupivacaine Hydrochloride', '7.5 mg/ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('715', '83736539615269953168', '17', 'Pivacain-L 5', 'Levobupivacaine Hydrochloride', '5 mg/ml', '', '', '0', '', '', '7', '70.47', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('716', '98363162378282734931', '17', 'Pivacain-L 2.5', 'Levobupivacaine Hydrochloride', '2.5 mg/ml', '', '', '0', '', '', '7', '50.34', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('717', '15414413732997739634', '38', 'Cartine', 'Levocarnitine', '10 gm/100 ml', '', '', '0', '', '', '7', '100.68', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('718', '65925466596119872985', '3', 'Cartine', 'Levocarnitine', '330 mg', '', '', '0', '', '', '7', '4.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('719', '31485997149423323651', '3', 'Acitrin-L', 'Levocetirizine Hydrochloride', '5 mg', '', '', '0', '', '', '7', '3.01', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('720', '81412996147918377729', '48', 'Acitrin-L', 'Levocetrizine Dihydrochloride', '500 mcg/ml', '', '', '0', '', '', '7', '55.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('721', '19596815687545299128', '3', 'Leflox    500', 'Levofloxacin', '500 mg', '', '', '0', '', '', '7', '15.11', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('722', '46323898216746493392', '3', 'Leflox    750', 'Levofloxacin', '750 mg', '', '', '0', '', '', '7', '20.13', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('723', '56749235426411388924', '16', 'Leflox', 'Levofloxacin', '5 mg/ml', '', '', '0', '', '', '7', '87.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('724', '63884625792751713293', '16', 'Leflox TS', 'Levofloxacin', '15 mg/ml', '', '', '0', '', '', '7', '128.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('725', '36946384784292911535', '53', 'ACI-Levo Vet', 'Levofloxacin', '10 gm/100 gm', '', '', '0', '', '', '7', '70.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('726', '77659856666192492886', '3', 'Brodil Levo    1', 'Levosalbutamol', '1 mg', '', '', '0', '', '', '7', '1.10', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('727', '36116133714566342469', '3', 'Brodil Levo    2', 'Levosalbutamol', '2 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('728', '68181192867551642228', '8', 'Brodil Levo', 'Levosalbutamol', '1 mg/5 ml', '', '', '0', '', '', '7', '30.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('729', '58335421159341886348', '26', 'Brodil Levo HFA', 'Levosalbutamol', '50 mcg/Metered Inhalation', '', '', '0', '', '', '7', '250.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('730', '65764162972659842428', '3', 'Throid', 'Levothyroxine Sodium', '50 mcg', '', '', '0', '', '', '7', '1.35', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('731', '73747564568373499383', '13', 'Xylone Plus', 'Lidocaine + Prilocaine', '2.5 gm + 2.5 gm/100 gm', '', '', '0', '', '', '7', '130.39', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('732', '89268914578331981155', '14', 'Xylone    2%', 'Lidocaine Hydrochloride', '20 mg/gm', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('733', '42637296153168199285', '17', 'Xylone    2%', 'Lidocaine Hydrochloride', '20 mg/ml', '', '', '0', '', '', '7', '3.57', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('734', '13764282629187495374', '17', 'Xylone    4%', 'Lidocaine Hydrochloride', '40 mg/ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('735', '98278935712197537162', '17', 'Oxyvet', 'Lidocaine Hydrochloride + Oxytetracycline', '2 gm + 10 gm/100 ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('736', '41188225893671499675', '3', 'Glitin', 'Linagliptin', '5 mg', '', '', '0', '', '', '7', '12.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('737', '19884262847915186788', '22', 'Acilin (Vet) Oral Powder', 'Lincomycin', '44 mg/gm', '', '', '0', '', '', '7', '21.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('738', '77435889967462875481', '3', 'Ezolid    600', 'Linezolid', '600 mg', '', '', '0', '', '', '7', '85.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('739', '16147232814546845272', '3', 'Ezolid    400', 'Linezolid', '400 mg', '', '', '0', '', '', '7', '60.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('740', '11922824373981445445', '7', 'Magpara', 'Liquid Paraffin + Magnesium Hydroxide', '1.25 ml + 300 mg/5 ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('741', '63197294639767371618', '3', 'Stril    5', 'Lisinopril', '5 mg', '', '', '0', '', '', '7', '3.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('742', '24269331823132754667', '3', 'Stril    10', 'Lisinopril', '10 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('743', '61192351716474678215', '3', 'Litiam ER', 'Lithium Carbonate', '400 mg', '', '', '0', '', '', '7', '5.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('744', '89646827725641874873', '3', 'Omeflox    400', 'Lomefloxacin', '400 mg', '', '', '0', '', '', '7', '15.11', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('745', '28467658363546642294', '16', 'Omeflox', 'Lomefloxacin', '.3 gm/100 ml', '', '', '0', '', '', '7', '68.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('746', '62798719771131738273', '3', 'Alaron', 'Loratadine', '10 mg', '', '', '0', '', '', '7', '2.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('747', '89434285455573452382', '7', 'Alaron', 'Loratadine', '5 mg/5 ml', '', '', '0', '', '', '7', '30.20', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('748', '74167661697963899419', '3', 'Rosatan    50', 'Losartan Potassium', '50 mg', '', '', '0', '', '', '7', '5.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('749', '61941793175533984757', '3', 'Rosatan    25', 'Losartan Potassium', '25 mg', '', '', '0', '', '', '7', '3.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('750', '99326889596457238755', '3', 'Lynotril', 'Lynestrenol', '5 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('751', '71187782351347777659', '3', 'Avlocid M', 'Magaldrate', '400 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('752', '62857515191739523858', '55', 'Avlocid MS', 'Magaldrate + Simethicone', '480 mg + 20 mg', '', '', '0', '', '', '7', '3.01', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('753', '15277856795973186949', '7', 'Avlocid MS', 'Magaldrate + Simethicone', '480 mg + 20 mg/5 ml', '', '', '0', '', '', '7', '100.30', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('754', '39533732297972499826', '3', 'Meba', 'Mebeverine Hydrochloride', '135 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('755', '16364591359888758132', '3', 'Pyrimac', 'Meclizine Hydrochloride + Pyridoxine Hydrochloride', '25 mg + 50 mg', '', '', '0', '', '', '7', '2.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('756', '68327251136845839845', '3', 'Phyton', 'Mecobalamin', '.5 mg', '', '', '0', '', '', '7', '4.03', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('757', '33316621554318794951', '17', 'Phyton', 'Mecobalamin', '.5 mg/ml', '', '', '0', '', '', '7', '30.20', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('758', '89875364556546893978', '3', 'Movera 5', 'Medroxyprogesterone Acetate', '5 mg', '', '', '0', '', '', '7', '5.40', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('759', '59442496599841948734', '3', 'Movera 10', 'Medroxyprogesterone Acetate', '10 mg', '', '', '0', '', '', '7', '10.03', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('760', '81429461969899238592', '3', 'Meflon', 'Mefloquine', '250 mg', '', '', '0', '', '', '7', '39.61', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('761', '89157275765917443252', '3', 'Meflon   PLUS', 'Mefloquine', '250 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('762', '86826832154526338366', '29', 'M-Pain Vet', 'Meloxicam', '100 mg', '', '', '0', '', '', '7', '6.01', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('763', '94288675468399534214', '17', 'M-Pain Vet', 'Meloxicam', '50 mg/10 ml', '', '', '0', '', '', '7', '320.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('764', '51933523447425635666', '3', 'Abixa', 'Memantine Hydrochloride', '10 mg', '', '', '0', '', '', '7', '8.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('765', '77331972822494239952', '13', 'Viscon', 'Menthol + Methyl Salicylate', '10 gm + 15 gm/100 gm', '', '', '0', '', '', '7', '40.27', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('766', '82534188321244212593', '13', 'Viscon', 'Menthol + Methyl Salicylate', '8 gm + 30 gm/100 gm', '', '', '0', '', '', '7', '60.41', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('767', '15127568899994539375', '17', 'Aronem    500 mg', 'Meropenem', '500 mg/vial', '', '', '0', '', '', '7', '654.41', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('768', '26418756635954729219', '17', 'Aronem    1 gm', 'Meropenem', '1 gm/vial', '', '', '0', '', '', '7', '1208.14', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('769', '59466861322754755478', '3', 'Metform    850', 'Metformin Hydrochloride', '850 mg', '', '', '0', '', '', '7', '6.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('770', '57164632912878875572', '3', 'Metform    500', 'Metformin Hydrochloride', '500 mg', '', '', '0', '', '', '7', '4.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('771', '16881686566197673858', '56', 'Metform  ER  1 gm', 'Metformin Hydrochloride', '1 gm', '', '', '0', '', '', '7', '9.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('772', '84157328134332382692', '56', 'Metform 500', 'Metformin Hydrochloride', '500 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('773', '84149686582225679791', '3', 'Politor    850', 'Metformin Hydrochloride + Pioglitazone', '850 mg + 15 mg', '', '', '0', '', '', '7', '11.03', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('774', '56352792832314891325', '3', 'Politor    500', 'Metformin Hydrochloride + Pioglitazone', '500 mg + 15 mg', '', '', '0', '', '', '7', '10.03', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('775', '38653193223297829227', '3', 'Sitomet 50/500', 'Metformin Hydrochloride + Sitagliptin', '500 mg + 50 mg', '', '', '0', '', '', '7', '16.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('776', '59971389297152731435', '3', 'Sitomet 50/1000', 'Metformin Hydrochloride + Sitagliptin', '1000 mg + 50 mg', '', '', '0', '', '', '7', '18.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('777', '16317589145133568958', '3', 'Aptin M 50/500', 'Metformin Hydrochloride + Vildagliptin', '500 mg + 50 mg', '', '', '0', '', '', '7', '22.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('778', '34872233796262544654', '3', 'Aptin M 50/850', 'Metformin Hydrochloride + Vildagliptin', '850 mg + 50 mg', '', '', '0', '', '', '7', '23.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('779', '39787248755974569284', '3', 'Angilat', 'Metoprolol Tartrate', '25 mg', '', '', '0', '', '', '7', '1.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('780', '85754638772375196989', '3', 'Angilat 50', 'Metoprolol Tartrate', '50 mg', '', '', '0', '', '', '7', '1.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('781', '95517959136722417187', '17', 'Angilat', 'Metoprolol Tartrate', '1 mg/ml', '', '', '0', '', '', '7', '120.36', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('782', '43716592437378297778', '3', 'Amotrex    200', 'Metronidazole', '200 mg', '', '', '0', '', '', '7', '0.69', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('783', '91936422998716238224', '3', 'Amotrex    400', 'Metronidazole', '400 mg', '', '', '0', '', '', '7', '1.27', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('784', '33484556854877133359', '7', 'Amotrex', 'Metronidazole', '200 mg/5 ml', '', '', '0', '', '', '7', '29.90', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('785', '81264958138216986315', '3', 'Amotrex  DS  800', 'Metronidazole', '800 mg', '', '', '0', '', '', '7', '2.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('786', '97911334128263115864', '20', 'Amotrex', 'Metronidazole', '500 mg/100 ml', '', '', '0', '', '', '7', '85.26', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('787', '75789526331981863373', '29', 'Acimetro-Vet', 'Metronidazole', '2 gm', '', '', '0', '', '', '7', '4.47', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('788', '82151448693192898535', '30', 'Acimetro Vet', 'Metronidazole', '30 gm/100 gm', '', '', '0', '', '', '7', '135.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('789', '51845968572554765392', '13', 'Miconex', 'Miconazole', '20 mg/gm', '', '', '0', '', '', '7', '35.24', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('790', '15298671491322728876', '57', 'Micoral', 'Miconazole', '20 mg/gm', '', '', '0', '', '', '7', '100.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('791', '57375336786627717232', '17', 'Dormilat', 'Midazolam', '15 mg/3 ml', '', '', '0', '', '', '7', '55.17', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('792', '79859161577834913876', '17', 'Dormilat', 'Midazolam', '1 mg/ml', '', '', '0', '', '', '7', '75.23', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('793', '37292238139687842289', '3', 'Dormilat', 'Midazolam', '15 mg', '', '', '0', '', '', '7', '15.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('794', '17519739817647968288', '3', 'Dormilat', 'Midazolam', '7.5 mg', '', '', '0', '', '', '7', '8.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('795', '28267835148871661222', '3', 'Diaset 25 mg', 'Miglitol', '25 mg', '', '', '0', '', '', '7', '10.07', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('796', '17429743442629845635', '3', 'Diaset 50 mg', 'Miglitol', '50 mg', '', '', '0', '', '', '7', '15.11', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('797', '85751498981268757863', '3', 'Diaset 100 mg', 'Miglitol', '100 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('798', '41187143871524933175', '58', 'Miragon 25 PR', 'Mirabegron', '25 mg', '', '', '0', '', '', '7', '30.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('799', '46426296746819831929', '3', 'Rapine 15 F/C', 'Mirtazapine', '15 mg', '', '', '0', '', '', '7', '8.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('800', '59939516791689975453', '3', 'Rapine 30 F/C', 'Mirtazapine', '30 mg', '', '', '0', '', '', '7', '15.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('801', '68184632576786341532', '3', 'Rapine 7.5', 'Mirtazapine', '7.5 mg', '', '', '0', '', '', '7', '6.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('802', '67657891226153525431', '3', 'Mastel  MR', 'Mizolastine', '10 mg', '', '', '0', '', '', '7', '6.52', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('803', '89644539555586695285', '13', 'Meloderm', 'Mometasone Furoate', '100 mg/100 gm', '', '', '0', '', '', '7', '100.30', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('804', '41511251146929849258', '11', 'Meloderm', 'Mometasone Furoate', '100 mg/100 gm', '', '', '0', '', '', '7', '100.30', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('805', '31991311177213275355', '51', 'Melonex 220 Acucap', 'Mometasone Furoate', '220 mcg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('806', '73465869465545415997', '51', 'Melonex 110 Acucap', 'Mometasone Furoate', '110 mcg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('807', '13577545874832362737', '27', 'Melonex', 'Mometasone Furoate', '50 mcg/Spray', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('808', '15766772942261927276', '38', 'Tetrasol', 'Monosulfiram', '25 gm/100 ml', '', '', '0', '', '', '7', '68.20', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('809', '85734532366337749977', '3', 'Reversair    10', 'Montelukast', '10 mg', '', '', '0', '', '', '7', '15.11', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('810', '37724929884472129333', '3', 'Reversair    5', 'Montelukast', '5 mg', '', '', '0', '', '', '7', '8.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('811', '17676831558413647555', '3', 'Reversair    4', 'Montelukast', '4 mg', '', '', '0', '', '', '7', '7.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('812', '35946959854266739711', '16', 'Maxiflox', 'Moxifloxacin', '5 mg/ml', '', '', '0', '', '', '7', '100.68', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('813', '85782465312152723426', '3', 'Moxiflox 400', 'Moxifloxacin', '400 mg', '', '', '0', '', '', '11', '50.15', '', 'Csv Uploaded Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('814', '29822573596912337219', '13', 'Tapocin    2%', 'Mupirocin', '100 mg/5 gm', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('815', '65675741771984778679', '11', 'Systop', 'Mupirocin', '100 mg/5 gm', '', '', '0', '', '', '7', '140.42', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('816', '35269729113576616567', '17', 'Nalbutin 1', 'Nalbuphine Hydrochloride', '10 mg/ml', '', '', '0', '', '', '7', '60.18', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('817', '99945224355212282867', '17', 'Nalbutin 2', 'Nalbuphine Hydrochloride', '20 mg/2 ml', '', '', '0', '', '', '7', '100.30', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('818', '61421133641555543846', '16', 'Napcon', 'Naphazoline Hydrochloride + Pheniramine Maleate', '250 mcg + 3 mg/ml', '', '', '0', '', '', '7', '70.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('819', '19451446429511166417', '15', 'Anaflex    250', 'Naproxen', '250 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('820', '52156788247575615963', '6', 'Anaflex', 'Naproxen', '125 mg/5 ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('821', '95679463415552523379', '3', 'Anaflex    500', 'Naproxen', '500 mg', '', '', '0', '', '', '7', '9.06', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('822', '65637864472568556377', '14', 'Anaflex', 'Naproxen', '10 gm/100 gm', '', '', '0', '', '', '7', '116.30', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('823', '59139786994486591652', '15', 'Anaflex    500', 'Naproxen', '500 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('824', '92754782522782118783', '3', 'Anaflex  SR  500', 'Naproxen', '500 mg', '', '', '0', '', '', '7', '14.09', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('825', '58621944158474666991', '3', 'Bipinor    2.5', 'Nebivolol', '2.5 mg', '', '', '0', '', '', '7', '5.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('826', '54979776384147946625', '3', 'Bipinor', 'Nebivolol', '5 mg', '', '', '0', '', '', '7', '8.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('827', '63788213268243432366', '3', 'Acuten', 'Nefopam Hydrochloride', '30 mg', '', '', '0', '', '', '7', '3.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('828', '45617336748164384352', '17', 'Acuten', 'Nefopam Hydrochloride', '20 mg/ml', '', '', '0', '', '', '7', '15.11', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('829', '16878735177817732988', '22', 'N-Cin Vet 50', 'Neomycin Sulphate', '50 gm/100 gm', '', '', '0', '', '', '7', '291.80', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('830', '74887364826399593163', '17', 'Stignal', 'Neostigmine Methyl Sulphate', '500 mcg/ml', '', '', '0', '', '', '7', '6.07', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('831', '38896294492958134569', '8', 'Nutrivit-B', 'Nicotinamide + Pyridoxine Hydrochloride + Riboflavin + Vitamin B1', '20 mg + 2 mg + 2 mg + 5 mg/5 ml', '', '', '0', '', '', '7', '35.65', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('832', '62719726824438612252', '3', 'Nutrivit-B', 'Nicotinamide + Pyridoxine Hydrochloride + Riboflavin + Vitamin B1', '20 mg + 2 mg + 2 mg + 5 mg', '', '', '0', '', '', '7', '0.62', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('833', '37498845495977583334', '8', 'Oral  ZB', 'Nicotinamide + Pyridoxine Hydrochloride + Riboflavin + Vitamin B1 + Zinc', '20 mg + 2 mg + 2 mg + 5 mg + 10 mg/5 ml', '', '', '0', '', '', '7', '55.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('834', '68281428817969473423', '3', 'Diar    500', 'Nitazoxanide', '500 mg', '', '', '0', '', '', '7', '10.07', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('835', '13534676355683128182', '6', 'Diar', 'Nitazoxanide', '100 mg/5 ml', '', '', '0', '', '', '7', '35.24', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('836', '26593593381828854751', '4', 'NITROFUR SR 50', 'Nitrofurantoin', '50 mg', '', '', '0', '', '', '7', '4.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('837', '24543246681428345516', '4', 'NITROFUR SR 100', 'Nitrofurantoin', '100 mg', '', '', '0', '', '', '7', '20.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('838', '39594377472783164819', '17', 'Nitroxynil', 'Nitroxynil', '25 gm/100 ml', '', '', '0', '', '', '7', '57.33', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('839', '81257757885693756388', '3', 'Menogia', 'Norethisterone', '5 mg', '', '', '0', '', '', '7', '6.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('840', '54289627178874439795', '3', 'Nortyl    25', 'Nortriptyline', '25 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('841', '36771383389785228861', '3', 'Nortyl    10', 'Nortriptyline', '10 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('842', '53337857945154755779', '7', 'Nyscan', 'Nystatin', '1 Lac Unit/ml', '', '', '0', '', '', '7', '20.44', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('843', '22422491312551443936', '3', 'Xytrex    10', 'Olanzapine', '10 mg', '', '', '0', '', '', '7', '4.53', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('844', '25157387221925657549', '3', 'Xytrex 5', 'Olanzapine', '5 mg', '', '', '0', '', '', '7', '2.52', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('845', '23758769166993972973', '3', 'Abetis    20', 'Olmesartan Medoxomil', '20 mg', '', '', '0', '', '', '7', '8.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('846', '44397783913363933232', '3', 'Abetis    40', 'Olmesartan Medoxomil', '40 mg', '', '', '0', '', '', '7', '15.11', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('847', '56871387579444474441', '3', 'Abetis', 'Olmesartan Medoxomil', '10 mg', '', '', '0', '', '', '7', '5.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('848', '25533515886175838113', '16', 'Contova 0.1%', 'Olopatadine', '1 mg/ml', '', '', '0', '', '', '7', '105.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('849', '42639597235697342938', '16', 'Contova DS', 'Olopatadine', '.2 gm/100 ml', '', '', '0', '', '', '7', '150.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('850', '52958345885367323244', '4', 'Xeldrin    10', 'Omeprazole', '10 mg', '', '', '0', '', '', '7', '2.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('851', '43656692884689538522', '4', 'Xeldrin    40', 'Omeprazole', '40 mg', '', '', '0', '', '', '7', '8.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('852', '59833128985323594371', '43', 'Xeldrin    20', 'Omeprazole', '20 mg', '', '', '0', '', '', '7', '4.03', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('853', '37199623748143799771', '17', 'Xeldrin  IV  40', 'Omeprazole', '40 mg/vial', '', '', '0', '', '', '7', '80.24', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('854', '21442931462485574255', '3', 'Osetron    8', 'Ondansetron', '8 mg', '', '', '0', '', '', '7', '10.07', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('855', '84539729356487832255', '17', 'Osetron    8', 'Ondansetron', '8 mg/4 ml', '', '', '0', '', '', '7', '25.17', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('856', '18124657968865489777', '8', 'Osetron', 'Ondansetron', '4 mg/5 ml', '', '', '0', '', '', '7', '30.20', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('857', '68576585135678217631', '37', 'Osetron ODT', 'Ondansetron', '4 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('858', '31134694495227148196', '4', 'Ornical', 'Orlistat', '120 mg', '', '', '0', '', '', '7', '55.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('859', '38795634251274495275', '4', 'Pandeflu', 'Oseltamivir', '75 mg', '', '', '0', '', '', '7', '151.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('860', '83477246297987315688', '3', 'Demarin', 'Oxaprozin', '600 mg', '', '', '0', '', '', '7', '7.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('861', '43126155483388174697', '3', 'Carbox 300', 'Oxcarbazepine', '300 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('862', '89355377886465429526', '3', 'Carbox 150', 'Oxcarbazepine', '150 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('863', '92186921416967651744', '59', 'Congesta', 'Oxymetazoline Hydrochloride', '0.03%', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('864', '93145919365638666381', '59', 'Congesta 0.05%', 'Oxymetazoline Hydrochloride', '0.05%', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('865', '27498839781967519938', '4', 'Impetet    250', 'Oxytetracycline', '250 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('866', '41598217292212764841', '22', 'Aquamycine', 'Oxytetracycline', '25 gm/100 gm', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('867', '86886692929699713239', '58', 'Palimax ER 6', 'Paliperidone', '6 mg', '', '', '0', '', '', '7', '10.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('868', '44577554147441936349', '58', 'Palimax ER 1.5', 'Paliperidone', '1.5 mg', '', '', '0', '', '', '7', '4.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('869', '44495466424563733266', '58', 'Palimax ER 3', 'Paliperidone', '3 mg', '', '', '0', '', '', '7', '7.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('870', '43518933521268658117', '3', 'Pantex    20', 'Pantoprazole', '20 mg', '', '', '0', '', '', '7', '5.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('871', '92795991545985817687', '3', 'Pantex 40 mg', 'Pantoprazole', '40 mg', '', '', '0', '', '', '7', '7.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('872', '88878596746277922957', '17', 'Pantex 40 IV', 'Pantoprazole', '40 mg/vial', '', '', '0', '', '', '7', '70.47', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('873', '55915617251933739591', '9', 'Nutrivit  MV', 'Pantothenic acid + Pyridoxine Hydrochloride + Riboflavin + Vitamin A + Vitamin B1 + Vitamin C + Vitamin D', '500 mg + 100 mg + 100 mg + 5 Lac IU + 160 mg + 5 gm + 1 gm/100 ml', '', '', '0', '', '', '7', '16.06', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('874', '91392819668831357482', '7', 'Xcel', 'Paracetamol', '120 mg/5 ml', '', '', '0', '', '', '7', '20.70', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('875', '96463322542619268771', '3', 'Xcel', 'Paracetamol', '500 mg', '', '', '0', '', '', '7', '0.80', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('876', '63432635469953563446', '15', 'Xcel    250', 'Paracetamol', '250 mg', '', '', '0', '', '', '7', '5.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('877', '99717486514768673568', '9', 'Xcel', 'Paracetamol', '80 mg/ml', '', '', '0', '', '', '7', '12.35', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('878', '56433958364735494228', '15', 'Xcel    125', 'Paracetamol', '125 mg', '', '', '0', '', '', '7', '4.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('879', '75563913999171495128', '3', 'Xcel   DISPERSABLE', 'Paracetamol', '120 mg', '', '', '0', '', '', '7', '1.28', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('880', '14555284295221921313', '8', 'Xcel', 'Paracetamol', '120 mg/5 ml', '', '', '0', '', '', '7', '20.70', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('881', '54957299637579387536', '37', 'Xcel ODT', 'Paracetamol', '500 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('882', '77274751172895898627', '29', 'Acitamol (Vet)', 'Paracetamol', '2 gm', '', '', '0', '', '', '7', '2.25', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('883', '94153172833694427522', '15', 'Xcel 500', 'Paracetamol', '500 mg', '', '', '0', '', '', '7', '8.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('884', '82444978369665785285', '3', 'Xcel Max', 'Paracetamol + Tramadol Hydrochloride', '325 mg + 37.5 mg', '', '', '0', '', '', '7', '8.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('885', '96988615385326517266', '3', 'Parotin 20', 'Paroxetine', '20 mg', '', '', '0', '', '', '7', '10.07', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('886', '36469954386957763881', '3', 'Parotin 10', 'Paroxetine', '10 mg', '', '', '0', '', '', '7', '6.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('887', '66696838199652265318', '13', 'Permisol    5%', 'Permethrin', '5 gm/100 gm', '', '', '0', '', '', '7', '30.09', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('888', '37834712791292147261', '3', 'Pevil', 'Pheniramine Maleate', '22.7 mg', '', '', '0', '', '', '7', '0.46', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('889', '39463732662848169515', '17', 'Hista-Vet', 'Pheniramine Maleate', '22.75 mg/ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('890', '38433488573462762424', '17', 'Tonadin', 'Phytomenadione', '10 mg/ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('891', '11865828982468193333', '17', 'Tonadin', 'Phytomenadione', '2 mg/.2 ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('892', '46614774532852821826', '3', 'Diatag F/C   15', 'Pioglitazone', '15 mg', '', '', '0', '', '', '7', '8.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('893', '68598399188496215735', '17', 'Tazosyn 4.5 IV', 'Piperacillin + Tazobactam', '4 gm + .5 gm/vial', '', '', '0', '', '', '7', '1003.01', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('894', '77999253977769346959', '17', 'Tazoxyn 2.25 IV', 'Piperacillin + Tazobactam', '2 gm + 250 mg/vial', '', '', '0', '', '', '7', '601.80', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('895', '79857267782479319178', '17', 'Memopil', 'Piracetam', '200 mg/ml', '', '', '0', '', '', '7', '75.51', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('896', '83248788821444197476', '8', 'Memopil', 'Piracetam', '500 mg/5 ml', '', '', '0', '', '', '7', '151.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('897', '25344847577146866635', '16', 'Oclube Ophthalmic Solution', 'Polyethylene Glycol 400 + Propylene Glycol', '400 mg + 300 mg/100 ml', '', '', '0', '', '', '7', '150.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('898', '13976682483253467212', '3', 'Blocid', 'Potassium Bicarbonate + Sodium Alginate', '100 mg + 500 mg', '', '', '0', '', '', '7', '3.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('899', '13526127471466737494', '7', 'Blocid', 'Potassium Bicarbonate + Sodium Alginate', '100 mg + 500 mg/5 ml', '', '', '0', '', '', '7', '125.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('900', '38952681958733461944', '16', 'Rovidone', 'Povidone Iodine', '5 gm/100 ml', '', '', '0', '', '', '7', '90.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('901', '66287912179669447324', '3', 'Parixol 700 mcg', 'Pramipexol', '700 mcg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('902', '23924571731994221932', '3', 'Parixol 180 mcg', 'Pramipexol', '180 mcg', '', '', '0', '', '', '7', '6.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('903', '21739216343334477118', '3', 'Parixol 88 mcg', 'Pramipexol', '88 mcg', '', '', '0', '', '', '7', '3.01', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('904', '29268452314598315228', '3', 'Hemagrel 5', 'Prasugrel', '5 mg', '', '', '0', '', '', '7', '12.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('905', '32762477276911121493', '3', 'Hemagrel 10', 'Prasugrel', '10 mg', '', '', '0', '', '', '7', '20.06', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('906', '71582477333278793725', '3', 'Solone    5', 'Prednisolone', '5 mg', '', '', '0', '', '', '7', '1.72', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('907', '11787581494924218321', '3', 'Solone    20', 'Prednisolone', '20 mg', '', '', '0', '', '', '7', '6.27', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('908', '72996521948876873236', '3', 'Solone 10', 'Prednisolone', '10 mg', '', '', '0', '', '', '7', '3.23', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('909', '51191643954591259399', '38', 'Solone Oral Solution', 'Prednisolone', '5 mg/5 ml', '', '', '0', '', '', '7', '65.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('910', '88474729164667321738', '4', 'Gabarol    75', 'Pregabalin', '75 mg', '', '', '0', '', '', '7', '16.11', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('911', '24461956956853898591', '4', 'Gabarol    100', 'Pregabalin', '100 mg', '', '', '0', '', '', '7', '22.15', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('912', '45961381459488564944', '4', 'Gabarol    150', 'Pregabalin', '150 mg', '', '', '0', '', '', '7', '30.20', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('913', '16247653327177834137', '4', 'Gabarol 50', 'Pregabalin', '50 mg', '', '', '0', '', '', '7', '12.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('914', '47329399949433192857', '4', 'Gabarol 25', 'Pregabalin', '25 mg', '', '', '0', '', '', '7', '8.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('915', '29721189193136891767', '3', 'Remaquin 15', 'Primaquine', '15 mg', '', '', '0', '', '', '7', '1.51', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('916', '63643318618313895562', '3', 'Compazine', 'Prochlorperazine Maleate', '5 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('917', '56384354875238195414', '17', 'Compazine', 'Prochlorperazine Mesilate', '12.5 mg/ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('918', '81425331933523275392', '8', 'Compazine', 'Prochlorperazine Mesilate', '5 mg/5 ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('919', '72361356583934141774', '3', 'Progic    25', 'Promethazine Hydrochloride', '25 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('920', '51974943943539943154', '8', 'Progic', 'Promethazine Hydrochloride', '5 mg/5 ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('921', '93483737759175858819', '29', 'Prozin Vet', 'Promethazine Hydrochloride', '150 mg', '', '', '0', '', '', '7', '3.32', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('922', '15462441216252748448', '3', 'Indever    10', 'Propranolol Hydrochloride', '10 mg', '', '', '0', '', '', '7', '0.51', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('923', '59478548811876266118', '3', 'Indever    40', 'Propranolol Hydrochloride', '40 mg', '', '', '0', '', '', '7', '1.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('924', '91819794746714963832', '47', 'Propranolol   Pellets', 'Propranolol Hydrochloride', '320 gm/KG', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('925', '17455365985668996339', '4', 'Inever  SR  40', 'Propranolol Hydrochloride', '40 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('926', '87285735737838191537', '22', 'Acivit B1B2B6 Powder (Vet)', 'Pyridoxine Hydrochloride + Riboflavine-5-Phosphate + Thiamine Hydrochloride', '.61 gm + 1.1 gm + 6 gm/100 gm', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('927', '12727527771874669164', '3', 'Qmax 100', 'Quetiapine', '100 mg', '', '', '0', '', '', '7', '10.03', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('928', '62749614137327343624', '3', 'Qmax 25', 'Quetiapine', '25 mg', '', '', '0', '', '', '7', '3.01', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('929', '53253393946966884212', '3', 'Paricel    20', 'Rabeprazole Sodium', '20 mg', '', '', '0', '', '', '7', '5.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('930', '27261878745232545429', '3', 'Paricel 10', 'Rabeprazole Sodium', '10 mg', '', '', '0', '', '', '7', '3.51', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('931', '13828266492651369963', '4', 'Paricel 20', 'Rabeprazole Sodium', '20 mg', '', '', '0', '', '', '7', '8.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('932', '39439695817434149327', '4', 'Radola', 'Racecadrotil', '100 mg', '', '', '0', '', '', '7', '6.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('933', '48416747244741248352', '3', 'Rolage', 'Raloxifene Hydrochloride', '60 mg', '', '', '0', '', '', '7', '10.07', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('934', '14877479285215197725', '17', 'Xantid', 'Ranitidine', '50 mg/2 ml', '', '', '0', '', '', '7', '7.55', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('935', '79558884878697457975', '3', 'Xantid    150', 'Ranitidine', '150 mg', '', '', '0', '', '', '7', '2.51', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('936', '89893872595762874274', '3', 'Xantid  HS  300', 'Ranitidine', '300 mg', '', '', '0', '', '', '7', '4.03', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('937', '29911981748585579871', '4', 'Chrocee 200', 'Ribavirin', '200 mg', '', '', '0', '', '', '7', '35.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('938', '21639994251431622369', '3', 'Henlix 20', 'Rifaximin', '200 mg', '', '', '0', '', '', '7', '25.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('939', '67699868497692158924', '3', 'Henlix 550', 'Rifaximin', '550 mg', '', '', '0', '', '', '7', '45.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('940', '12699765683418166474', '3', 'Risomax 1', 'Risperidone', '1 mg', '', '', '0', '', '', '7', '3.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('941', '51338861324796369661', '3', 'Risomax 2', 'Risperidone', '2 mg', '', '', '0', '', '', '7', '5.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('942', '91984117737552584468', '3', 'Risomax 4', 'Risperidone', '4 mg', '', '', '0', '', '', '7', '9.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('943', '21236857129273994121', '3', 'Ritopar 10', 'Ritodrine Hydrochloride', '10 mg', '', '', '0', '', '', '7', '8.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('944', '62139249337647322569', '17', 'Ritopar', 'Ritodrine Hydrochloride', '10 mg/ml', '', '', '0', '', '', '7', '8.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('945', '86754722317442314455', '3', 'Rivaban 10', 'Rivaroxaban', '10 mg', '', '', '0', '', '', '7', '25.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('946', '86726872794142264338', '3', 'Rivaban 20', 'Rivaroxaban', '20 mg', '', '', '0', '', '', '7', '45.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('947', '28947531839515669782', '3', 'Rivaban 2.5', 'Rivaroxaban', '2.5 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('948', '32488319976431668686', '3', 'Adair', 'Roflumilast', '500 mcg', '', '', '0', '', '', '7', '15.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('949', '95353379924236646581', '3', 'Rosetor 40', 'Rosuvastatin', '40 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('950', '96511265172835552584', '3', 'Rosetor 20', 'Rosuvastatin', '20 mg', '', '', '0', '', '', '7', '30.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('951', '87548243825411866612', '3', 'Rosetor 10', 'Rosuvastatin', '10 mg', '', '', '0', '', '', '7', '18.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('952', '71339456596263576371', '3', 'Rosetor 5', 'Rosuvastatin', '5 mg', '', '', '0', '', '', '7', '10.03', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('953', '28829714366776457996', '3', 'Largix', 'Rupatadine', '10 mg', '', '', '0', '', '', '7', '10.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('954', '59696399891759852742', '48', 'Largix', 'Rupatadine', '100 mg/100 ml', '', '', '0', '', '', '7', '75.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('955', '82178757883959768932', '3', 'Brodil    2', 'Salbutamol', '2 mg', '', '', '0', '', '', '7', '0.26', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('956', '16297811134432335662', '3', 'Brodil    4', 'Salbutamol', '4 mg', '', '', '0', '', '', '7', '0.46', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('957', '23442976637215677594', '8', 'Brodil', 'Salbutamol', '2 mg/5 ml', '', '', '0', '', '', '7', '14.53', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('958', '79267647979385465451', '4', 'Brodil  SR', 'Salbutamol', '8 mg', '', '', '0', '', '', '7', '2.42', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('959', '31665975275785235932', '47', 'Salbutamol   Pellets', 'Salbutamol', '48 gm/KG', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('960', '14324258425693584517', '26', 'Brodil HFA', 'Salbutamol', '100 mcg/Metered Inhalation', '', '', '0', '', '', '7', '195.59', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('961', '21488679425251238425', '60', 'Brodil Inhaler', 'Salbutamol', '100 mcg/Spray', '', '', '0', '', '', '7', '161.08', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('962', '47398149249794486192', '61', 'Brodil Respiratory Solution', 'Salbutamol', '5 mg/ml', '', '', '0', '', '', '7', '15.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('963', '96568685368923599865', '51', 'Brodil Acucap', 'Salbutamol', '200 mcg', '', '', '0', '', '', '7', '2.51', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('964', '78811237966186796899', '61', 'Brodil', 'Salbutamol', '2.5 mg/2.5 ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('965', '56763461154527919992', '3', 'Sezol  DS', 'Secnidazole', '1 gm', '', '', '0', '', '', '7', '17.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('966', '24988313944649178179', '3', 'Chear    25', 'Sertraline', '25 mg', '', '', '0', '', '', '7', '3.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('967', '76235822971796423338', '3', 'Chear    50', 'Sertraline', '50 mg', '', '', '0', '', '', '7', '6.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('968', '73451871495429337484', '3', 'Chear 100 mg', 'Sertraline', '100 mg', '', '', '0', '', '', '7', '10.07', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('969', '22331156633847249159', '3', 'Adegra 25', 'Sildenafil', '25 mg', '', '', '0', '', '', '7', '20.06', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('970', '17562166165798763122', '3', 'Adegra 50', 'Sildenafil', '50 mg', '', '', '0', '', '', '7', '30.09', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('971', '21876291653144944751', '3', 'Adegra 100', 'Sildenafil', '100 mg', '', '', '0', '', '', '7', '50.15', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('972', '51964168935934788228', '3', 'Adegra 20', 'Sildenafil', '20 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('973', '22649385936372274923', '13', 'Sibalyn', 'Silver Sulphadiazine', '1%', '', '', '0', '', '', '7', '40.12', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('974', '55955724331826589526', '9', 'Simet', 'Simethicone', '67 mg/ml', '', '', '0', '', '', '7', '30.20', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('975', '44254614195917398141', '3', 'Recol    10', 'Simvastatin', '10 mg', '', '', '0', '', '', '67', NULL, '', 'Csv Uploaded Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('976', '92817643735674597147', '3', 'Sitap 100', 'Sitagliptin', '100 mg', '', '', '0', '', '', '7', '28.08', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('977', '29429596371866654881', '3', 'Sitap 50', 'Sitagliptin', '50 mg', '', '', '0', '', '', '7', '15.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('978', '15366846876516547866', '17', 'Antivenom Injection', 'Snake Venom Antiserum', '6.7 ml/vial', '', '', '0', '', '', '90', NULL, '', 'Csv Uploaded Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('979', '65474774888552495999', '20', 'Salinor 0.9% Normal Saline', 'Sodium Chloride', '2.25 gm/250 ml', '', '', '0', '', '', '7', '50.14', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('980', '51268653515528178884', '16', 'Icrom', 'Sodium Cromoglycate', '20 mg/ml', '', '', '0', '', '', '7', '65.45', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('981', '76315476119442321476', '48', 'Sel-E Vet', 'Sodium Selenate + Vitamin E', '50 mg + 10 gm/100 ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('982', '61795238329222253417', '3', 'Sodival', 'Sodium Valproate', '200 mg', '', '', '0', '', '', '7', '2.52', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('983', '44477839954249961999', '8', 'Sodival', 'Sodium Valproate', '200 mg/5 ml', '', '', '0', '', '', '7', '80.24', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('984', '69462431498442733464', '3', 'Sodival CR 300', 'Sodium Valproate', '300 mg', '', '', '0', '', '', '7', '6.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('985', '97224988828977816338', '3', 'Sodival CR 500', 'Sodium Valproate', '500 mg', '', '', '0', '', '', '7', '10.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('986', '53485383124878342339', '3', 'Sofomax', 'Sofosbuvir', '400 mg', '', '', '0', '', '', '7', '700.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('987', '97753314787521611785', '3', 'Somfen 5', 'Solifenacin Succinate', '5 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('988', '89119749289177456648', '3', 'Somfen 10', 'Solifenacin Succinate', '10 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('989', '61867362971449363154', '3', 'Aciflox    200', 'Sparfloxacin', '200 mg', '', '', '0', '', '', '7', '12.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('990', '62617757266676611342', '17', 'Streptokinase IV', 'Streptokinase', '15 Lac IU', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('991', '31963274599964435882', '7', 'Avlotrin', 'Sulphamethoxazole + Trimethoprim', '200 mg + 40 mg/5 ml', '', '', '0', '', '', '7', '22.21', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('992', '87159771463187698647', '3', 'Avlotrin', 'Sulphamethoxazole + Trimethoprim', '400 mg + 80 mg', '', '', '0', '', '', '7', '1.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('993', '85762333884384639891', '3', 'Avlotrin', 'Sulphamethoxazole + Trimethoprim', '800 mg + 160 mg', '', '', '0', '', '', '7', '2.01', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('994', '75765641254882562988', '3', 'suvorest 10fc', 'Suvorexant', '10 mg', '', '', '0', '', '', '7', '35.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('995', '75436875549829641353', '17', 'Rapilax', 'Suxamethonium Chloride', '100 mg/2 ml', '', '', '0', '', '', '7', '17.25', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('996', '81999393134993635328', '3', 'Ciaton 5', 'Tadalafil', '5 mg', '', '', '0', '', '', '7', '18.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('997', '49549399829842374568', '3', 'Ciaton 10', 'Tadalafil', '10 mg', '', '', '0', '', '', '7', '35.11', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('998', '57775738744723653338', '3', 'Ciaton 20', 'Tadalafil', '20 mg', '', '', '0', '', '', '7', '60.18', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('999', '65312175157454143288', '4', 'Sasolin', 'Tamsulosin Hydrochloride', '400 mcg', '', '', '0', '', '', '7', '10.07', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1000', '56797946342199939726', '3', 'Oxicam    20', 'Tanoxicam', '20 mg', '', '', '0', '', '', '7', '8.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1001', '21967438285385568417', '3', 'Lopenta 50', 'Tapentadol', '50 mg', '', '', '0', '', '', '7', '14.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1002', '62168513272767693688', '3', 'Lopenta 75', 'Tapentadol', '75 mg', '', '', '0', '', '', '7', '20.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1003', '88823163989879395175', '3', 'Lopenta 100', 'Tapentadol', '100 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1004', '67293249758395487339', '3', 'Arbitel 40', 'Telmisartan', '40 mg', '', '', '0', '', '', '7', '12.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1005', '47259652171217228161', '3', 'Arbitel 80', 'Telmisartan', '80 mg', '', '', '0', '', '', '7', '20.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1006', '37814939336824661784', '3', 'Arbitel 20', 'Telmisartan', '20 mg', '', '', '0', '', '', '7', '7.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1007', '99938933193577192444', '3', 'Foviral 300', 'Tenofovir Disoproxil Fumarate', '300 mg', '', '', '0', '', '', '7', '85.26', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1008', '32237219692935899662', '13', 'Skinabin', 'Terbinafine', '1 gm/100 gm', '', '', '0', '', '', '7', '35.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1009', '68617878184919299471', '3', 'Skinabin    250', 'Terbinafine', '250 mg', '', '', '0', '', '', '7', '40.27', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1010', '21128244837297118475', '17', 'Testoren IM', 'Testosterone Decanoate + Testosterone Isocaproate + Testosterone Phenyl propionate + Testosterone Propionate', '100 mg + 60 mg + 60 mg + 30 mg/ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1011', '54162916522177127758', '4', 'Teolex  CR', 'Theophylline', '300 mg', '', '', '0', '', '', '7', '3.52', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1012', '15585628427498523997', '4', 'Teolex', 'Theophylline', '400 mg', '', '', '0', '', '', '7', '4.25', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1013', '77284944865735843149', '8', 'Teolex', 'Theophylline', '120 mg/5 ml', '', '', '0', '', '', '7', '31.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1014', '65914389178727913713', '3', 'Teolex SR 400', 'Theophylline', '400 mg', '', '', '0', '', '', '7', '2.68', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1015', '12833168215253293338', '3', 'Teolex SR 300', 'Theophylline', '300 mg', '', '', '0', '', '', '7', '2.01', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1016', '95295932521482837182', '3', 'Teolex 200 SR Tablet', 'Theophylline', '200 mg', '', '', '0', '', '', '7', '1.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1017', '56115682546576542563', '3', 'Tivit    100', 'Thiamine Hydrochloride', '100 mg', '', '', '0', '', '', '7', '0.75', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1018', '36214476521448348196', '17', 'Thiopen  IV  1 gm', 'Thiopentone Sodium', '1 gm', '', '', '0', '', '', '7', '100.68', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1019', '49134699358111415698', '17', 'Thiopen  IV  0.5 gm', 'Thiopentone Sodium', '500 mg', '', '', '0', '', '', '7', '70.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1020', '91166873895619415458', '22', 'Mycogard Vet Oral Powder', 'Tiamulin Hydrogen Fumerate', '45%', '', '', '0', '', '', '7', '1200.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1021', '43976145944995914641', '3', 'Tivion', 'Tibolone', '2.5 mg', '', '', '0', '', '', '7', '20.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1022', '32348324266125522587', '3', 'Acora 90', 'Ticagrelor', '90 mg', '', '', '0', '', '', '7', '75.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1023', '45685923383782626149', '3', 'Tynium', 'Tiemonium Methylsulphate', '50 mg', '', '', '0', '', '', '7', '8.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1024', '24361777916664882123', '17', 'Tynium', 'Tiemonium Methylsulphate', '5 mg/2 ml', '', '', '0', '', '', '7', '20.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1025', '81716627351935947991', '8', 'Tynium', 'Tiemonium Methylsulphate', '200 mg/100 ml', '', '', '0', '', '', '7', '88.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1026', '56477381283437434742', '16', 'Lotensin    .25%', 'Timolol Maleate', '0.25%', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1027', '19159464761138658656', '3', 'Tizadin', 'Tizanidine', '2 mg', '', '', '0', '', '', '7', '5.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1028', '95951148922793981983', '3', 'Namitol', 'Tolfenamic Acid', '200 mg', '', '', '0', '', '', '7', '8.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1029', '71732785748375138473', '17', 'Tendia Injection', 'Tramadol Hydrochloride', '100 mg/2 ml', '', '', '0', '', '', '7', '20.13', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1030', '15572848471457434725', '4', 'Tendia 50 mg', 'Tramadol Hydrochloride', '50 mg', '', '', '0', '', '', '7', '7.55', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1031', '28755727611996528466', '62', 'Tendia ER', 'Tramadol Hydrochloride', '100 mg', '', '', '0', '', '', '7', '14.09', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1032', '26995941613955965197', '17', 'Anaxyl    500', 'Tranexamic Acid', '500 mg/5 ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1033', '83312254778425135364', '4', 'Anaxyl', 'Tranexamic Acid', '250 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1034', '41447679345715133785', '4', 'Anaxyl 500', 'Tranexamic Acid', '500 mg', '', '', '0', '', '', '7', '15.11', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1035', '31245848231665269121', '17', 'Anaxyl', 'Tranexamic Acid', '250 mg/5 ml', '', '', '0', '', '', '7', '50.34', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1036', '81594349573896593731', '3', 'Anaxyl 500', 'Tranexamic Acid', '500 mg', '', '', '0', '', '', '7', '20.06', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1037', '54627975498215969299', '14', 'Trena', 'Tretinoin', '25 mg/100 gm', '', '', '0', '', '', '7', '45.31', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1038', '66628341829353197925', '13', 'Cortefin', 'Triamcinolone Acetonide', '1 mg/gm', '', '', '0', '', '', '7', '25.17', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1039', '63579293949813685846', '11', 'Cortefin', 'Triamcinolone Acetonide', '1 mg/gm', '', '', '0', '', '', '7', '25.08', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1040', '43311243886471185764', '27', 'Cortefin', 'Triamcinolone Acetonide', '55 mcg/Metered Inhalation', '', '', '0', '', '', '7', '200.60', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1041', '23929352134587577692', '29', 'Acinex (Vet)', 'Triclabendazole', '900 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1042', '29771255528133343442', '3', 'Tricalm', 'Trihexyphenidyl Hydrochloride', '2 mg', '', '', '0', '', '', '7', '5.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1043', '13527623573971477556', '3', 'Tricalm 5', 'Trihexyphenidyl Hydrochloride', '5 mg', '', '', '0', '', '', '7', '10.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1044', '64364546239976619621', '22', 'Tylotar', 'Tylosin', '20 gm/100 gm', '', '', '0', '', '', '7', '211.42', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1045', '98391175666237428241', '3', 'Bilicir 150', 'Ursodeoxycholic Acid', '150 mg', '', '', '0', '', '', '7', '11.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1046', '37711999254985897678', '3', 'Bilicir 300', 'Ursodeoxycholic Acid', '300 mg', '', '', '0', '', '', '7', '20.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1047', '92218134431258773151', '3', 'Alaclov', 'Valacyclovir', '500 mg', '', '', '0', '', '', '7', '40.27', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1048', '57167317788159817542', '17', 'Vecuron', 'Vecuronium Bromide', '4 mg/ml', '', '', '0', '', '', '7', '82.56', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1049', '78124969372815275879', '17', 'Vecuron  IV', 'Vecuronium Bromide', '10 mg/ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1050', '25835444746922112875', '3', 'Aptin', 'Vildagliptin', '50 mg', '', '', '0', '', '', '7', '20.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1051', '43115499396527683798', '3', 'Avintol 5', 'Vinpocetine', '5 mg', '', '', '0', '', '', '7', '3.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1052', '77459844254528644381', '17', 'Avintol', 'Vinpocetine', '10 mg/2 ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1053', '52679571996996753661', '17', 'Acivit-ADE (Vet)', 'Vitamin A + Vitamin D3 + Vitamin E', '500000 IU + 75000 IU + 50 mg/100 ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1054', '48319635888296648672', '3', 'Nutrivit C   250', 'Vitamin C', '250 mg', '', '', '0', '', '', '7', '1.90', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1055', '92881666748372217863', '9', 'Nutrivit-C', 'Vitamin C', '100 mg/ml', '', '', '0', '', '', '7', '30.20', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1056', '95728538785994985726', '8', 'Nutrivit-C', 'Vitamin C', '100 mg/5 ml', '', '', '0', '', '', '7', '33.45', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1057', '37477338929619427815', '3', 'Nutrivit C', 'Vitamin C', '500 mg', '', '', '0', '', '', '7', '9.03', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1058', '72822248142136371229', '3', 'Nutrivit C', 'Vitamin C', '1 gm', '', '', '0', '', '', '7', '12.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1059', '16189991241873762986', '22', 'Acivit C (Vet)', 'Vitamin C', '1 gm/gm', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1060', '84287924545765233876', '3', 'Nutrivit E   200', 'Vitamin E', '200 mg', '', '', '0', '', '', '7', '3.82', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1061', '41388367363124412129', '3', 'Progil    50', 'Voriconazole', '50 mg', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1062', '31726563357182578382', '17', 'Water For Injection', 'Water For Injection', '5 ml', '', '', '0', '', '', '204', NULL, '', 'Csv Uploaded Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1063', '13453341619156372118', '59', 'Sinuvin', 'Xylometazoline Hydrochloride', '50 mg/100 ml', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1064', '87928678374755953778', '8', 'Oral Z   10mg/5ml', 'Zinc', '10 mg/5 ml', '', '', '0', '', '', '7', '26.18', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1065', '57328564778255819882', '3', 'Dispazinc Dispersible', 'Zinc', '20 mg', '', '', '0', '', '', '7', '2.01', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1066', '31176168986189719732', '11', 'Zinoxy', 'Zinc Oxide', '40 gm/100 gm', '', '', '0', '', '', '7', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1067', '58733895176131422691', '3', 'Hypnoclone', 'Zopiclone', '7.5 mg', '', '', '0', '', '', '7', '4.03', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1068', '52881582529499258681', '29', 'Adrizol 600 mg', 'Albendazole', '600 mg', '', '', '0', '', '', '8', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1069', '84944434571361476315', '22', 'Advomica', 'Ammonium Bicarbonate + Gentian + Ginger + Nux vomica + Sodium Bicarbonate', '25 gm + 1.5 gm + 1.5 gm + 7 gm + 65 gm/100 gm', '', '', '0', '', '', '8', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1070', '51542415732359326217', '22', 'Adprolim Plus', 'Amprolium + Sulfaquinoxaline Sodium + Vitamin K', '170 gm + 170 gm + 1 gm/KG', '', '', '0', '', '', '8', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1071', '61568568318428385573', '29', 'Apetonic', 'Choline Bitartrate + Cobalt Sulfate + Cyanocobalamin + Ferrous Sulphate + Thiamine Mononitrate (B1)', '9.1 mg + 50 mg + 20 mg + 100 mg + 25 mg', '', '', '0', '', '', '8', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1072', '89544999811227472188', '38', 'Adcipcin', 'Ciprofloxacin', '10 gm/100 ml', '', '', '0', '', '', '8', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1073', '67455938198824548644', '29', 'Adcipcin', 'Ciprofloxacin', '1 gm', '', '', '0', '', '', '8', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1074', '69747515112573987733', '38', 'Adquine', 'Flumequine', '20 gm/100 ml', '', '', '0', '', '', '8', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1075', '52328399931762892398', '29', 'Keto-Pain', 'Ketoprofen', '400 mg', '', '', '0', '', '', '8', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1076', '23956915329563513676', '29', 'TCL VET', 'Levamisole + Triclabendazole', '600 mg + 900 mg', '', '', '0', '', '', '8', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1077', '11127979212775435428', '29', 'Adzyl 2 gm', 'Metronidazole', '2 gm', '', '', '0', '', '', '8', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1078', '54666256855557512889', '22', 'Neo Super', 'Neomycin Sulphate', '50 gm/100 gm', '', '', '0', '', '', '8', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1079', '19547398675555445549', '29', 'Adminide', 'Oxyclozanide + Tetramisole Hydrochloride', '1.4 gm + 2 gm', '', '', '0', '', '', '8', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1080', '64769766456747387562', '29', 'AD-Tetra 500mg', 'Oxytetracycline', '500 mg', '', '', '0', '', '', '8', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1081', '99872623531436982586', '22', 'AD-Tetra', 'Oxytetracycline', '20 gm/100 gm', '', '', '0', '', '', '8', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1082', '37426956936153318959', '29', 'Adcet', 'Paracetamol', '2 gm', '', '', '0', '', '', '8', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1083', '21229868362781579253', '22', 'Adrazin', 'Piperazine', '100%', '', '', '0', '', '', '8', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1084', '41617437657613533812', '29', 'Adprozin', 'Promethazine Hydrochloride', '150 mg', '', '', '0', '', '', '8', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1085', '29426716963524125561', '48', 'ADSEL-E', 'Sodium Selenate + Vitamin E', '50 mg + 10 gm/100 ml', '', '', '0', '', '', '8', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1086', '98397132342914539846', '29', 'Adsulph', 'Sulphadiazine + Sulphadimidine + Sulphapyridine', '1.666 gm + 1.666 gm + 1.666 gm', '', '', '0', '', '', '8', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1087', '84746365537538262313', '63', 'Advit-ADE', 'Vitamin A + Vitamin D3 + Vitamin E', '1 Lac IU + 20000 IU + 20 mg/ml', '', '', '0', '', '', '8', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1088', '51971144773512427554', '3', 'Claim 100', 'Aceclofenac', '100 mg', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1089', '78957175998293755685', '22', 'SummerCool Powder (Vet)', 'Acetylsalicylic Acid + Vitamin C', '6.7 gm + 20 gm/100 gm', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1090', '26999288365734876931', '29', 'Wormfree', 'Albendazole', '600 mg', '', '', '0', '', '', '9', '7.28', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1091', '21999611898131821142', '22', 'Apitazym Powder (Vet)', 'Ammonium Bicarbonate + Gentian + Ginger + Nux vomica + Sodium Bicarbonate', '25 gm + 1.5 gm + 1.5 gm + 7 gm + 65 gm/100 gm', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1092', '68851811879328776653', '22', 'Almolin Vet    30%', 'Amoxicillin', '30%', '', '', '0', '', '', '9', '1997.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1093', '61474876856137475371', '29', 'Al-molin Vet', 'Amoxicillin', '500 mg', '', '', '0', '', '', '9', '6.04', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1094', '64945353194768849397', '22', 'AMPO-VET Powder', 'Amprolium', '20%', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1095', '52211167426213235547', '22', 'Glue-C Powder (Vet)', 'Anhydrous Glucose + Vitamin C', '98 gm + 2 gm/100 gm', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1096', '22177254931914918122', '29', 'Ferum', 'Antimony Potassium Tartrate + Ferrous Sulphate', '2 gm + 2 gm', '', '', '0', '', '', '9', '8.57', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1097', '11277689824324371455', '22', 'Hyvit-BC (Vet)', 'Ascorbic Acid + Biotin + Calcium Pantothenate + Dextrose Anhydrous + Folic Acid + Nicotinamide + Pyridoxine Hydrochloride + Riboflavine Sodium Phosphate + Thiamine Hydrochloride + Vitamin B12', '500 mg + 1.5 mg + 450 mg + 97.5 gm + 25 mg + 750 mg + 150 mg + 400 mg + 200 mg + 1 mg/100 gm', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1098', '99895114823221467198', '4', 'Carbium', 'Ascorbic Acid + Elemental Iron + Folic Acid + Nicotinamide + Pyridoxine Hydrochloride + Riboflavin + Vitamin B1 + Zinc', '50 mg + 50 mg + 500 mcg + 10 mg + 1 mg + 2.2 mg + 2.2 mg + 22.5 mg', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1099', '58258152563838783744', '3', 'Thoraz 500', 'Azithromycin', '500 mg', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1100', '98418767672572936647', '3', 'Thoraz 250', 'Azithromycin', '250 mg', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1101', '98494831368895292185', '6', 'Thoraz', 'Azithromycin', '200 mg/5 ml', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1102', '76819487423572231714', '3', 'Zerolent 10', 'Baclofen', '10 mg', '', '', '0', '', '', '9', '8.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1103', '16669783962352481929', '17', 'Albu-Vet', 'Buparvaquone', '50 mg/ml', '', '', '0', '', '', '9', '626.87', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1104', '41785681592588869276', '17', 'Fatiso Vet', 'Butaphosphan + Cyanocobalamin', '10 gm + 5 mg/100 ml', '', '', '0', '', '', '9', '50.15', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1105', '73583236659939311999', '3', 'Coralium-D', 'Calcium (Coral Calcium) + Vitamin D3', '500 mg + 200 IU', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1106', '75237679172765248711', '3', 'Bonwell-D', 'Calcium + Vitamin D3', '500 mg + 200 IU', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1107', '66523986817145753693', '17', 'Calplus Vet', 'Calcium Gluconate + Dextrose + Magnesium Hypophosphite', '208 mg + 200 mg + 50 mg/ml', '', '', '0', '', '', '9', '96.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1108', '98424769186274688157', '4', 'Prex-3 200 Capsule', 'Cefixime', '200 mg', '', '', '0', '', '', '9', '30.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1109', '73979437873956429379', '4', 'Prex-3 400 Capsule', 'Cefixime', '400 mg', '', '', '0', '', '', '9', '50.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1110', '73662635669984743913', '6', 'Prex-3 powder for suspension', 'Cefixime', '200 mg/5 ml', '', '', '0', '', '', '9', '195.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1111', '71974752392873484384', '3', 'Claviator-CV 250 Tablet', 'Cefuroxime + Clavulanic Acid', '250 mg + 62.5 mg', '', '', '0', '', '', '9', '30.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1112', '99976366928412471574', '3', 'Claviator-CV 500 Tablet', 'Cefuroxime + Clavulanic Acid', '500 mg + 125 mg', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1113', '32689496835924529334', '6', 'Claviator-CV Powder for suspen', 'Cefuroxime + Clavulanic Acid', '125 mg + 31.25 mg/5 ml', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1114', '98326378477354994674', '22', 'AL-CTC Vet', 'Chlortetracycline Hydrochloride', '20 gm/100 gm', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1115', '81982512129464272265', '29', 'Hemorex', 'Choline Bitartrate + Cobalt Sulfate + Cyanocobalamin + Ferrous Sulphate + Thiamine Mononitrate (B1)', '9.1 mg + 50 mg + 20 mg + 100 mg + 25 mg', '', '', '0', '', '', '9', '2.16', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1116', '75296832868962999652', '38', 'Alcipro   Solution', 'Ciprofloxacin', '10 gm', '', '', '0', '', '', '9', '233.71', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1117', '79353596835185395941', '29', 'Alcipro', 'Ciprofloxacin', '750 mg', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1118', '31721344737283441149', '64', 'Cipex Powder for Suspension', 'Ciprofloxacin', '250 mg/5 ml', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1119', '34518422863762222686', '3', 'Cipex 500', 'Ciprofloxacin', '500 mg', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1120', '39918477411415979267', '3', 'Cipex 250', 'Ciprofloxacin', '250 mg', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1121', '34151792366783113214', '48', 'Alken Solution', 'Citric Acid Monohydrate + Potassium Citrate', '5 gm + 30 gm/100 ml', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1122', '43487146619935777657', '3', 'B3', 'Cyanocobalamin + Pyridoxine Hydrochloride + Vitamin B1', '200 mcg + 200 mg + 100 mg', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1123', '56852484289161986791', '22', 'Hylyte Powder (Vet)', 'Dextrose Anhydrous + Potassium Chloride + Sodium Bicarbonate + Sodium Chloride + Vitamin A', '18 gm + 5 gm + 50 gm + 26.6 gm + 20 Lac IU', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1124', '74972635383315724866', '22', 'Anticocci-K Powder (Vet)', 'Diaverdin + Nicotinamide + Sulphadimethoxine Sodium + Sulphadimidine + Vitamin K', '3 gm + 3 gm + 2 gm + 20 gm + 2 gm/100 gm', '', '', '0', '', '', '9', '906.01', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1125', '91177227779436476395', '22', 'Al-Doxil (Vet)', 'Doxycycline', '100 mg/gm', '', '', '0', '', '', '9', '160.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1126', '55715835527418257163', '4', 'Difitox 100 Capsule', 'Doxycycline', '100 mg', '', '', '0', '', '', '9', '2.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1127', '96875514898477958399', '38', 'Alenrol Vet', 'Enrofloxacin', '100 mg/ml', '', '', '0', '', '', '9', '910.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1128', '15624537917293634494', '22', 'Set-3 Powder (Vet)', 'Erythromycin Thiocyanate + Sulphadiazine + Trimethoprim', '18 gm + 15 gm + 3 gm/100 gm', '', '', '0', '', '', '9', '362.45', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1129', '87787251457892593539', '4', 'Raceper 20', 'Esomeprazole', '20 mg', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1130', '84535497897868427837', '4', 'Raceper 40', 'Esomeprazole', '40 mg', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1131', '68372226381648188552', '3', 'Anaprox', 'Esomeprazole + Naproxen', '20 mg + 500 mg', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1132', '56764966854847462931', '4', 'Fenogard 200', 'Fenofibrate', '200 mg', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1133', '47855788613726759912', '3', 'Rynofex 120', 'Fexofenadine Hydrochloride', '120 mg', '', '', '0', '', '', '9', '6.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1134', '62635256556454245612', '3', 'Rynofex 180', 'Fexofenadine Hydrochloride', '180 mg', '', '', '0', '', '', '9', '8.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1135', '21275188576649423717', '3', 'Uripay 100 Tablet', 'Flavoxate Hydrochloride', '100 mg', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1136', '65211358359939176758', '3', 'Uripay 200 Tablet', 'Flavoxate Hydrochloride', '200 mg', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1137', '85297458814227336657', '4', 'Flumazole 50', 'Fluconazole', '50 mg', '', '', '0', '', '', '9', '7.75', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1138', '88682147184987628629', '17', 'Algenta-Vet', 'Gentamicin', '100 mg/ml', '', '', '0', '', '', '9', '44.02', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1139', '77456854869892659432', '3', 'Zerofen 50', 'Ketoprofen', '50 mg', '', '', '0', '', '', '9', '3.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1140', '67744856348223911983', '3', 'Zerofen 100', 'Ketoprofen', '100 mg', '', '', '0', '', '', '9', '6.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1141', '31478637651916463449', '17', 'Xiroket IM/IV Injection', 'Ketorolac Tromethamine', '30 mg/ml', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1142', '68876114736794948684', '3', 'Xiroket 10', 'Ketorolac Tromethamine', '10 mg', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1143', '31851595347185661924', '22', 'Alvasol', 'Levamisole', '46 gm/100 gm', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1144', '31794236673651148758', '22', 'Alvasol', 'Levamisole', '30%', '', '', '0', '', '', '9', '140.95', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1145', '46572771814568457889', '29', 'An - Worm Bolus Vet', 'Levamisole + Triclabendazole', '600 mg + 900 mg', '', '', '0', '', '', '9', '21.07', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1146', '61724419254549313387', '53', 'LV-Vet Powder', 'Levofloxacin', '10 gm/100 gm', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1147', '64644515297775255589', '3', 'Isovox 500', 'Levofloxacin', '500 mg', '', '', '0', '', '', '9', '13.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1148', '42869132232817422241', '29', 'Mexicam Bolus (Vet)', 'Meloxicam', '100 mg', '', '', '0', '', '', '9', '6.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1149', '58658536734419515464', '29', 'Amovet', 'Metronidazole', '2 gm', '', '', '0', '', '', '9', '4.24', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1150', '89592957917934563735', '3', 'Ventilast 10', 'Montelukast', '10 mg', '', '', '0', '', '', '9', '14.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1151', '59833335562149218437', '22', 'NS-Vet', 'Neomycin Sulphate', '50 gm/100 gm', '', '', '0', '', '', '9', '55.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1152', '35624869814215383625', '63', 'Hyzine + B', 'Nicotinamide + Pyridoxine Hydrochloride + Riboflavine Sodium Phosphate + Thiamine Hydrochloride + Zinc Sulphate Monohydrate', '400 mg + 800 mg + 150 mg + 500 mg + 2 gm/100 ml', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1153', '86139713182182157322', '17', 'Nitroworm-Vet', 'Nitroxynil', '34 gm/100 ml', '', '', '0', '', '', '9', '75.44', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1154', '93162761114156197322', '4', 'Zolat 20', 'Omeprazole', '20 mg', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1155', '41385679137979444864', '29', 'Altetra', 'Oxytetracycline', '500 mg', '', '', '0', '', '', '9', '3.01', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1156', '74181542519213914844', '22', 'Altetra', 'Oxytetracycline', '20%', '', '', '0', '', '', '9', '80.54', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1157', '63398749997445829937', '17', 'Altetra-Vet LA', 'Oxytetracycline', '200 mg/ml', '', '', '0', '', '', '9', '52.03', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1158', '83734652381336852438', '3', 'Prilosec 20', 'Pantoprazole', '20 mg', '', '', '0', '', '', '9', '4.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1159', '93831982695835475355', '3', 'Prilosec 40', 'Pantoprazole', '40 mg', '', '', '0', '', '', '9', '7.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1160', '33695945815121769327', '29', 'Antifever Bolus (Vet)', 'Paracetamol', '2 gm', '', '', '0', '', '', '9', '2.27', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1161', '66556437276363445116', '17', 'Alhista Vet', 'Pheniramine Maleate', '22.75 mg/ml', '', '', '0', '', '', '9', '15.05', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1162', '63311797841119712836', '22', 'Helmacid', 'Piperazine', '36 gm/100 gm', '', '', '0', '', '', '9', '1450.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1163', '63577491456589816167', '29', 'Promethazine', 'Promethazine Hydrochloride', '150 mg', '', '', '0', '', '', '9', '3.34', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1164', '26891961587639331567', '22', 'Thiarip Powder (Vet)', 'Pyridoxine Hydrochloride + Riboflavine-5-Phosphate + Thiamine Hydrochloride', '.61 gm + 1.1 gm + 6 gm/100 gm', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1165', '51477882986792217876', '3', 'Zetidin 150', 'Ranitidine', '150 mg', '', '', '0', '', '', '9', '2.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1166', '27821528539196398621', '48', 'Hyvit ES Liquid (Vet)', 'Sodium Selenate + Vitamin E', '50 mg + 10 gm/100 ml', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1167', '82649517752995615747', '22', 'Cocsomix   PLUS', 'Sodium Sulfachloropyridazine + Trimethoprim', '10 gm + 2 gm/100 gm', '', '', '0', '', '', '9', '35.23', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1168', '13383474576448554573', '22', 'Alcocci Pow Vet', 'Sulfaclozine', '30%', '', '', '0', '', '', '9', '1750.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1169', '21579263461162394541', '29', 'Al-Sulpha', 'Sulphadiazine + Sulphadimidine + Sulphapyridine', '1.666 gm + 1.666 gm + 1.666 gm', '', '', '0', '', '', '9', '16.34', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1170', '75938757747695978648', '7', 'Trimosul', 'Sulphadiazine + Trimethoprim', '40 gm + 8 gm/100 ml', '', '', '0', '', '', '9', '166.01', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1171', '95697228531658493745', '29', 'Sulmidine Bolus (Vet)', 'Sulphadimidine', '5 gm', '', '', '0', '', '', '9', '8.06', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1172', '61735499236278371319', '4', 'Urivent', 'Tamsulosin Hydrochloride', '400 mcg', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1173', '14147863237216748657', '48', 'Tilvet Liquid', 'Tilmicosin', '250 mg/ml', '', '', '0', '', '', '9', '800.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1174', '41183343242933667427', '38', 'T-Zuril Vet', 'Toltrazuril', '2.5 gm/100 ml', '', '', '0', '', '', '9', '2100.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1175', '15188861369479946166', '22', 'Tylotrat 20    20%', 'Tylosin', '20 gm/100 gm', '', '', '0', '', '', '9', '206.26', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1176', '66299722993827714112', '30', 'Tylva-Vet Powder', 'Tylvalosin', '62.5 gm/100 gm', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1177', '45238984352292995889', '17', 'Hyvit ADE Vet', 'Vitamin A + Vitamin D3 + Vitamin E', '500000 IU + 75000 IU + 50 mg/100 ml', '', '', '0', '', '', '9', '120.06', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1178', '92976753846493197146', '22', 'Asvit-C Powder (Vet)', 'Vitamin C', '1 gm/gm', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1179', '63283685853182113476', '63', 'Zinc Liquid (Vet)', 'Zinc Sulphate Monohydrate', '2 gm/100 ml', '', '', '0', '', '', '9', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1180', '42175348665215317517', '3', 'Aceclofenac', 'Aceclofenac', '100 mg', '', '', '0', '', '', '10', '2.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1181', '47187895874642581488', '13', 'Acirux', 'Acyclovir', '5 gm/100 gm', '', '', '0', '', '', '10', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1182', '35447255541524364215', '3', 'Albendazole-DS', 'Albendazole', '400 mg', '', '', '0', '', '', '10', '4.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1183', '46693368956241432575', '29', 'Bendol-Al', 'Albendazole', '600 mg', '', '', '0', '', '', '10', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1184', '38827776341175957292', '3', 'Alprazol 0.25', 'Alprazolam', '.25 mg', '', '', '0', '', '', '10', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1185', '82483261978449155763', '3', 'Alprazole 0.5', 'Alprazolam', '.5 mg', '', '', '0', '', '', '10', '2.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1186', '96653681522714126189', '7', 'Pentocil', 'Aluminium Oxide + Magnesium Hydroxide', '175 mg + 225 mg/5 ml', '', '', '0', '', '', '10', '30.50', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1187', '24925133187956727359', '7', 'Antacid', 'Aluminium Oxide + Magnesium Hydroxide + Simethicone', '200 mg + 400 mg + 30 mg/5 ml', '', '', '0', '', '', '10', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1188', '24968376992863724991', '3', 'Reptylin 10', 'Amitriptyline Hydrochloride', '10 mg', '', '', '0', '', '', '10', NULL, '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufacturer_price`, `unit`, `product_details`, `image`, `status`, `tax0`, `tax1`, `tax2`) VALUES ('1189', '12928593754437948282', '3', 'Reptylin 25', 'Amitriptyline Hydrochloride', '25 mg', '', '', '0', '', '', '10', '1.00', '', 'Csv Product', 'http://localhost/pharmacarebd2-v-9/my-assets/image/product.png', '1', NULL, NULL, NULL);
INSERT INTO `product_information` (`id`, `product_id`, `category_id`, `product_name`, `generic_name`, `strength`, `box_size`, `product_location`, `price`, `tax`, `product_model`, `manufacturer_id`, `manufactur