<?php
 
defined('BASEPATH') OR exit('No direct script access allowed');

class Termination extends MY_Controller {
	
	 public function __construct() {
        Parent::__construct();
		$this->load->library('session');
		$this->load->helper('form');
		$this->load->helper('url');
		$this->load->helper('html');
		$this->load->database();
		$this->load->library('form_validation');
		//load the model
		$this->load->model("Termination_model");
		$this->load->model("Xin_model");
	}
	
	/*Function to set JSON output*/
	public function output($Return=array()){
		/*Set response header*/
		header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		/*Final JSON response*/
		exit(json_encode($Return));
	}
	
	 public function index()
     {
		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('');
		}
		$data['title'] = $this->Xin_model->site_title();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_termination_types'] = $this->Termination_model->all_termination_types();
		$data['breadcrumbs'] = $this->lang->line('left_terminations');
		$data['path_url'] = 'termination';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if(in_array('23',$role_resources_ids)) {
			if(!empty($session)){ 
			$data['subview'] = $this->load->view("termination/termination_list", $data, TRUE);
			$this->load->view('layout_main', $data); //page load
			} else {
				redirect('');
			}
		} else {
			redirect('dashboard/');
		}
     }
 
    public function termination_list()
     {

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if(!empty($session)){ 
			$this->load->view("termination/termination_list", $data);
		} else {
			redirect('');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		
		
		$termination = $this->Termination_model->get_terminations();
		
		$data = array();

        foreach($termination->result() as $r) {
			 			  
		// get user > warning to
		$euser = $this->Xin_model->read_user_info($r->employee_id);
		// user full name
		if(!is_null($euser)){
			$ful_name = $euser[0]->first_name.' '.$euser[0]->last_name;
		} else {
			$ful_name = '--';	
		}
		// get notice date
		$notice_date = $this->Xin_model->set_date_format($r->notice_date);
		// get termination date
		$termination_date = $this->Xin_model->set_date_format($r->termination_date);
				
		// get status
		if($r->status==0): $status = $this->lang->line('xin_pending');
		elseif($r->status==1): $status = $this->lang->line('xin_accepted'); else: $status = $this->lang->line('xin_rejected'); endif;
		// get warning type
		$termination_type = $this->Termination_model->read_termination_type_information($r->termination_type_id);
		if(!is_null($termination_type)){
			$ttype = $termination_type[0]->type;
		} else {
			$ttype = '--';	
		}
		
		$data[] = array(
			'<span data-toggle="tooltip" data-placement="top" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn btn-secondary btn-sm m-b-0-0 waves-effect waves-light"  data-toggle="modal" data-target=".edit-modal-data"  data-termination_id="'. $r->termination_id . '"><i class="fa fa-pencil-square-o"></i></button></span><span data-toggle="tooltip" data-placement="top" title="'.$this->lang->line('xin_view').'"><button type="button" class="btn btn-secondary btn-sm m-b-0-0 waves-effect waves-light" data-toggle="modal" data-target=".view-modal-data" data-termination_id="'. $r->termination_id . '"><i class="fa fa-eye"></i></button></span><span data-toggle="tooltip" data-placement="top" title="'.$this->lang->line('xin_delete').'"><button type="button" class="btn btn-danger btn-sm m-b-0-0 waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="'. $r->termination_id . '"><i class="fa fa-trash-o"></i></button></span>',
			$ful_name,
			$ttype,
			$notice_date,
			$termination_date,
			$status
		);
      }

	  $output = array(
		   "draw" => $draw,
			 "recordsTotal" => $termination->num_rows(),
			 "recordsFiltered" => $termination->num_rows(),
			 "data" => $data
		);
	  echo json_encode($output);
	  exit();
     }
	 
	 public function read()
	{
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->input->get('termination_id');
		$result = $this->Termination_model->read_termination_information($id);
		$data = array(
				'termination_id' => $result[0]->termination_id,
				'employee_id' => $result[0]->employee_id,
				'terminated_by' => $result[0]->terminated_by,
				'termination_type_id' => $result[0]->termination_type_id,
				'termination_date' => $result[0]->termination_date,
				'notice_date' => $result[0]->notice_date,
				'description' => $result[0]->description,
				'status' => $result[0]->status,
				'all_employees' => $this->Xin_model->all_employees(),
				'all_termination_types' => $this->Termination_model->all_termination_types(),
				);
		$session = $this->session->userdata('username');
		if(!empty($session)){ 
			$this->load->view('termination/dialog_termination', $data);
		} else {
			redirect('');
		}
	}
	
	// Validate and add info in database
	public function add_termination() {
	
		if($this->input->post('add_type')=='termination') {		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'');
			
		/* Server side PHP input validation */
		$notice_date = $this->input->post('notice_date');
		$termination_date = $this->input->post('termination_date');
		$nt_date = strtotime($notice_date);
    	$tt_date = strtotime($termination_date);
		$description = $this->input->post('description');
		$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);
		
		if($this->input->post('employee_id')==='') {
       		 $Return['error'] = $this->lang->line('xin_error_employee_id');
		} else if($this->input->post('notice_date')==='') {
			$Return['error'] = $this->lang->line('xin_error_resignation_notice_date');
		} else if($this->input->post('termination_date')==='') {
			 $Return['error'] = $this->lang->line('xin_error_termination_date');
		} else if($nt_date > $tt_date) {
        	$Return['error'] = $this->lang->line('xin_error_termination_notice_date_less');
		} else if(empty($this->input->post('type'))) {
			 $Return['error'] = $this->lang->line('xin_error_termination_type');
		}
				
		if($Return['error']!=''){
       		$this->output($Return);
    	}
	
		$data = array(
		'employee_id' => $this->input->post('employee_id'),
		'notice_date' => $this->input->post('notice_date'),
		'description' => $qt_description,
		'termination_date' => $this->input->post('termination_date'),
		'termination_type_id' => $this->input->post('type'),
		'terminated_by' => $this->input->post('user_id'),
		'status' => '0',
		'created_at' => date('d-m-Y'),
		);
		$result = $this->Termination_model->add($data);
		if ($result == TRUE) {
			$Return['result'] = $this->lang->line('xin_success_termination_added');
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
		exit;
		}
	}
	
	// Validate and update info in database
	public function update() {
	
		if($this->input->post('edit_type')=='termination') {
			
		$id = $this->uri->segment(3);
		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'');
			
		/* Server side PHP input validation */
		$notice_date = $this->input->post('notice_date');
		$termination_date = $this->input->post('termination_date');
		$nt_date = strtotime($notice_date);
    	$tt_date = strtotime($termination_date);
		$description = $this->input->post('description');
		$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);
		
		if($this->input->post('employee_id')==='') {
       		 $Return['error'] = $this->lang->line('xin_error_employee_id');
		} else if($this->input->post('notice_date')==='') {
			$Return['error'] = $this->lang->line('xin_error_resignation_notice_date');
		} else if($this->input->post('termination_date')==='') {
			 $Return['error'] = $this->lang->line('xin_error_termination_date');
		} else if($nt_date > $tt_date) {
        	$Return['error'] = $this->lang->line('xin_error_termination_notice_date_less');
		} else if(empty($this->input->post('type'))) {
			 $Return['error'] = $this->lang->line('xin_error_termination_type');
		}
				
		if($Return['error']!=''){
       		$this->output($Return);
    	}
	
		$data = array(
		'employee_id' => $this->input->post('employee_id'),
		'notice_date' => $this->input->post('notice_date'),
		'description' => $qt_description,
		'termination_date' => $this->input->post('termination_date'),
		'termination_type_id' => $this->input->post('type'),
		'terminated_by' => $this->input->post('user_id'),
		'status' => $this->input->post('status'),
		);
		
		$result = $this->Termination_model->update_record($data,$id);		
		
		if ($result == TRUE) {
			$Return['result'] = $this->lang->line('xin_success_termination_updated');
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
		exit;
		}
	}
	
	public function delete() {
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'');
		$id = $this->uri->segment(3);
		$result = $this->Termination_model->delete_record($id);
		if(isset($id)) {
			$Return['result'] = $this->lang->line('xin_success_termination_deleted');
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
	}
}
